/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ProgramBlock {
    protected Combo fApplicationCombo;
    private Button fProductButton;
    private Combo fProductCombo;
    private Button fApplicationButton;
    private AbstractLauncherTab fTab;
    private Listener fListener = new Listener();

    public ProgramBlock(AbstractLauncherTab tab) {
        this.fTab = tab;
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.ProgramBlock_programToRun);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.createProductSection((Composite)group);
        this.createApplicationSection((Composite)group);
    }

    protected void createProductSection(Composite parent) {
        this.fProductButton = new Button(parent, 16);
        this.fProductButton.setText(PDEUIMessages.ProgramBlock_runProduct);
        this.fProductButton.addSelectionListener((SelectionListener)this.fListener);
        this.fProductCombo = new Combo(parent, 12);
        this.fProductCombo.setItems(TargetPlatform.getProducts());
        this.fProductCombo.setLayoutData((Object)new GridData(768));
        this.fProductCombo.addSelectionListener((SelectionListener)this.fListener);
    }

    protected void createApplicationSection(Composite parent) {
        this.fApplicationButton = new Button(parent, 16);
        this.fApplicationButton.setText(PDEUIMessages.ProgramBlock_runApplication);
        this.fApplicationCombo = new Combo(parent, 12);
        this.fApplicationCombo.setItems(this.getApplicationNames());
        this.fApplicationCombo.setLayoutData((Object)new GridData(768));
        this.fApplicationCombo.addSelectionListener((SelectionListener)this.fListener);
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        this.initializeProductSection(config);
        this.initializeApplicationSection(config);
        boolean useProduct = config.getAttribute("useProduct", false) && this.fProductCombo.getItemCount() > 0;
        this.fApplicationButton.setSelection(!useProduct);
        this.fApplicationCombo.setEnabled(!useProduct);
        this.fProductButton.setSelection(useProduct);
        this.fProductButton.setEnabled(this.fProductCombo.getItemCount() > 0);
        this.fProductCombo.setEnabled(useProduct);
    }

    protected void initializeProductSection(ILaunchConfiguration config) throws CoreException {
        if (this.fProductCombo.getItemCount() > 0) {
            int index;
            String productName = config.getAttribute("product", null);
            int n = index = productName == null ? -1 : this.fProductCombo.indexOf(productName);
            if (index == -1) {
                index = 0;
            }
            this.fProductCombo.setText(this.fProductCombo.getItem(index));
        }
    }

    protected void initializeApplicationSection(ILaunchConfiguration config) throws CoreException {
        String attribute = this.getApplicationAttribute();
        String application = config.getAttribute(attribute, null);
        if (application == null || this.fApplicationCombo.indexOf(application) == -1) {
            application = null;
            StringTokenizer tokenizer = new StringTokenizer(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""));
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equals("-application") || !tokenizer.hasMoreTokens()) continue;
                application = tokenizer.nextToken();
                break;
            }
            int index = -1;
            if (application != null) {
                index = this.fApplicationCombo.indexOf(application);
            }
            if (index == -1) {
                index = this.fApplicationCombo.indexOf(TargetPlatform.getDefaultApplication());
            }
            if (index != -1) {
                this.fApplicationCombo.setText(this.fApplicationCombo.getItem(index));
            } else if (this.fApplicationCombo.getItemCount() > 0) {
                this.fApplicationCombo.setText(this.fApplicationCombo.getItem(0));
            }
        } else {
            this.fApplicationCombo.setText(application);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.saveApplicationSection(config);
        this.saveProductSection(config);
    }

    protected void saveProductSection(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("useProduct", this.fProductButton.getSelection());
        config.setAttribute("product", this.fProductCombo.getText());
    }

    protected void saveApplicationSection(ILaunchConfigurationWorkingCopy config) {
        String text = this.fApplicationCombo.getText();
        String attribute = this.getApplicationAttribute();
        if (text.length() == 0 || text.equals(TargetPlatform.getDefaultApplication())) {
            config.setAttribute(attribute, null);
        } else {
            config.setAttribute(attribute, text);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        String product = TargetPlatform.getDefaultProduct();
        if (product != null) {
            config.setAttribute("useProduct", true);
            config.setAttribute("product", product);
        }
    }

    protected String[] getApplicationNames() {
        return TargetPlatform.getApplications();
    }

    protected String getApplicationAttribute() {
        return "application";
    }

    class Listener
    extends SelectionAdapter {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ProgramBlock.this.fProductButton) {
                boolean enabled = ProgramBlock.this.fProductButton.getSelection();
                ProgramBlock.this.fProductCombo.setEnabled(enabled);
                ProgramBlock.this.fApplicationCombo.setEnabled(!enabled);
            }
            ProgramBlock.this.fTab.updateLaunchConfigurationDialog();
        }
    }
}

