/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.itarget.IImplicitDependenciesInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferencePage;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class TargetImplicitPluginsTab {
    private TableViewer fElementViewer;
    protected Set fElements;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fRemoveAllButton;
    private TargetPlatformPreferencePage fPage;

    public TargetImplicitPluginsTab(TargetPlatformPreferencePage page) {
        this.fPage = page;
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createLabel(container);
        this.createTable(container);
        this.createButtons(container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.implicit_plugins_preference_page");
        return container;
    }

    private void createLabel(Composite container) {
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.TargetImplicitPluginsTab_desc);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    private void createTable(Composite container) {
        this.fElementViewer = new TableViewer(container, 2564);
        GridData gd = new GridData(1808);
        this.fElementViewer.getControl().setLayoutData((Object)gd);
        this.fElementViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fElementViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fElementViewer.setInput((Object)PDEPlugin.getDefault());
        this.fElementViewer.setComparator(new ViewerComparator());
        this.fElementViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetImplicitPluginsTab.this.updateButtons();
            }
        });
        this.fElementViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && e.stateMask == 0) {
                    TargetImplicitPluginsTab.this.handleRemove();
                }
            }
        });
    }

    protected void loadTable() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        String value = preferences.getString("implicit_dependencies");
        StringTokenizer tokens = new StringTokenizer(value, ",");
        this.fElements = new HashSet(1 * tokens.countTokens() + 1);
        while (tokens.hasMoreElements()) {
            IPluginModelBase base = PluginRegistry.findModel((String)tokens.nextToken());
            if (base == null) continue;
            BundleDescription desc = base.getBundleDescription();
            this.fElements.add(desc);
            this.fElementViewer.add((Object)desc);
        }
    }

    private void createButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        this.fAddButton = new Button(buttonContainer, 8);
        this.fAddButton.setText(PDEUIMessages.SourceBlock_add);
        this.fAddButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetImplicitPluginsTab.this.handleAdd();
            }
        });
        this.fRemoveButton = new Button(buttonContainer, 8);
        this.fRemoveButton.setText(PDEUIMessages.SourceBlock_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetImplicitPluginsTab.this.handleRemove();
            }
        });
        this.fRemoveAllButton = new Button(buttonContainer, 8);
        this.fRemoveAllButton.setText(PDEUIMessages.TargetImplicitPluginsTab_removeAll3);
        this.fRemoveAllButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fRemoveAllButton);
        this.fRemoveAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetImplicitPluginsTab.this.handleRemoveAll();
            }
        });
        if (this.fElements.size() == 0) {
            this.fRemoveButton.setEnabled(false);
            this.fRemoveAllButton.setEnabled(false);
        }
    }

    private void updateButtons() {
        boolean empty = this.fElementViewer.getSelection().isEmpty();
        this.fRemoveButton.setEnabled(!empty);
        this.fRemoveAllButton.setEnabled(this.fElementViewer.getElementAt(0) != null);
    }

    private void handleAdd() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        dialog.setElements(this.getValidBundles());
        dialog.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        dialog.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        dialog.setMultipleSelection(true);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.implicit_plugins_selection_dialog");
        if (dialog.open() == 0) {
            Object[] bundles = dialog.getResult();
            int i = 0;
            while (i < bundles.length) {
                this.fElementViewer.add(bundles[i]);
                this.fElements.add(bundles[i]);
                ++i;
            }
            this.updateButtons();
        }
    }

    protected Object[] getValidBundles() {
        HashSet<String> currentPlugins = new HashSet<String>(1 * this.fElements.size() + 1);
        Iterator it = this.fElements.iterator();
        while (it.hasNext()) {
            BundleDescription desc = (BundleDescription)it.next();
            currentPlugins.add(desc.getSymbolicName());
        }
        IPluginModelBase[] models = this.fPage.getCurrentModels();
        HashSet<BundleDescription> result = new HashSet<BundleDescription>(1 * models.length + 1);
        int i = 0;
        while (i < models.length) {
            BundleDescription desc = models[i].getBundleDescription();
            if (!currentPlugins.contains(desc.getSymbolicName())) {
                result.add(desc);
            }
            ++i;
        }
        return result.toArray();
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fElementViewer.getSelection();
        Iterator it = ssel.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            this.fElements.remove(item);
            this.fElementViewer.remove(item);
        }
        if (this.fElements.size() == 0) {
            this.fRemoveButton.setEnabled(false);
        }
        this.updateButtons();
    }

    private void handleRemoveAll() {
        this.fElementViewer.remove(this.fElements.toArray());
        this.fElements.clear();
        this.updateButtons();
    }

    public void performDefauls() {
        this.fElementViewer.remove(this.fElements.toArray());
        this.fElements.clear();
        this.fRemoveButton.setEnabled(false);
    }

    public void performOk() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.fElements.iterator();
        while (it.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            BundleDescription desc = (BundleDescription)it.next();
            buffer.append(desc.getSymbolicName());
        }
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        preferences.setValue("implicit_dependencies", buffer.toString());
    }

    public void loadTargetProfile(ITarget target) {
        this.fElements.clear();
        IImplicitDependenciesInfo info = target.getImplicitPluginsInfo();
        if (info != null) {
            State state = this.fPage.getCurrentState().getState();
            ITargetPlugin[] plugins = info.getPlugins();
            int i = 0;
            while (i < plugins.length) {
                BundleDescription desc = state.getBundle(plugins[i].getId(), null);
                if (desc != null) {
                    this.fElements.add(desc);
                }
                ++i;
            }
        }
        this.fElementViewer.refresh();
    }

    protected String[] getImplicitPlugins() {
        String[] result = new String[this.fElements.size()];
        Iterator iter = this.fElements.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = ((BundleDescription)iter.next()).getSymbolicName();
        }
        return result;
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (TargetImplicitPluginsTab.this.fElements == null) {
                TargetImplicitPluginsTab.this.loadTable();
            }
            return TargetImplicitPluginsTab.this.fElements.toArray();
        }
    }
}

