/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.util.SAXParserWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLRootElementMatcher {
    public static boolean fileMatchesElement(IFile file, String element) {
        try {
            return XMLRootElementMatcher.matchFile(file.getContents(), element);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean fileMatchesElement(File file, String element) {
        try {
            FileInputStream stream = new FileInputStream(file);
            return XMLRootElementMatcher.matchFile(stream, element);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    private static boolean matchFile(InputStream stream, String element) {
        XMLContentTypeHandler handler = new XMLContentTypeHandler();
        try {
            SAXParserWrapper parser = new SAXParserWrapper();
            parser.parse(stream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return false;
        }
        catch (AbortParseException abortParseException) {
            return handler.isRootType(element);
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return handler.isRootType(element);
    }

    private static class AbortParseException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public AbortParseException() {
            super("Parsing operation forcibly aborted to save on performance time.");
        }
    }

    private static class XMLContentTypeHandler
    extends DefaultHandler {
        private String fRootElem = null;

        private XMLContentTypeHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.fRootElem = qName;
            throw new AbortParseException();
        }

        public boolean isRootType(String rootType) {
            return this.fRootElem != null && this.fRootElem.equals(rootType);
        }
    }
}

