/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.cheatsheet;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSDescription;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.text.cheatsheet.simple.SimpleCSModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.BaseCSCreationOperation;

public class SimpleCSCreationOperation
extends BaseCSCreationOperation {
    public SimpleCSCreationOperation(IFile file) {
        super(file);
    }

    public SimpleCSCreationOperation(ISchedulingRule rule) {
        super(rule);
    }

    protected void createContent() throws CoreException {
        SimpleCSModel model = new SimpleCSModel((IDocument)CoreUtility.getTextDocument((InputStream)this.fFile.getContents()), false);
        model.setUnderlyingResource((IResource)this.fFile);
        this.initializeCS(model.getSimpleCS());
        model.save();
        model.dispose();
    }

    protected void initializeCS(ISimpleCS simpleCS) {
        ISimpleCSModelFactory factory = simpleCS.getModel().getFactory();
        ISimpleCSIntro intro = factory.createSimpleCSIntro((ISimpleCSObject)simpleCS);
        ISimpleCSDescription description = factory.createSimpleCSDescription((ISimpleCSObject)intro);
        description.setContent(SimpleCSCreationOperation.formatTextBold(PDEUIMessages.SimpleCheatSheetCreationOperation_0));
        intro.setDescription(description);
        ISimpleCSItem item = factory.createSimpleCSItem((ISimpleCSObject)simpleCS);
        item.setTitle(PDEUIMessages.SimpleCheatSheetCreationOperation_1);
        ISimpleCSDescription description2 = factory.createSimpleCSDescription((ISimpleCSObject)item);
        description2.setContent(SimpleCSCreationOperation.formatTextBold(PDEUIMessages.SimpleCheatSheetCreationOperation_2));
        item.setDescription(description2);
        simpleCS.setTitle(PDEUIMessages.SimpleCheatSheetCreationOperation_3);
        simpleCS.setIntro(intro);
        simpleCS.addItem(item);
    }
}

