/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.provisioner.update;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.provisioner.update.IUpdateSiteProvisionerEntry;
import org.eclipse.pde.internal.ui.wizards.provisioner.update.UpdateSiteProvisionerDialog;
import org.eclipse.pde.internal.ui.wizards.provisioner.update.UpdateSiteProvisionerEntry;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class UpdateSiteProvisionerPage
extends WizardPage {
    private List fElements = new ArrayList();
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private TableViewer fViewer;

    protected UpdateSiteProvisionerPage(String pageName) {
        super(pageName);
        this.setTitle(PDEUIMessages.UpdateSiteWizardPage_title);
        this.setDescription(PDEUIMessages.UpdateSiteWizardPage_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        Label label = new Label(client, 0);
        label.setText(PDEUIMessages.UpdateSiteWizardPage_label);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fViewer = new TableViewer(client, 2048);
        this.fViewer.setContentProvider((IContentProvider)new UpdateSiteContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
                return provider.get(PDEPluginImages.DESC_SITE_OBJ);
            }

            public String getText(Object element) {
                IUpdateSiteProvisionerEntry entry = (IUpdateSiteProvisionerEntry)element;
                return entry.getSiteLocation();
            }
        });
        this.fViewer.setInput((Object)this.fElements);
        gd = new GridData(1808);
        gd.verticalSpan = 3;
        this.fViewer.getControl().setLayoutData((Object)gd);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UpdateSiteProvisionerPage.this.updateButtons();
            }
        });
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && UpdateSiteProvisionerPage.this.fViewer.getSelection() != null) {
                    UpdateSiteProvisionerPage.this.handleRemove();
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, "org.eclipse.pde.doc.user.update_site_provisioning_page");
        this.createButtons(client);
        this.setControl((Control)client);
    }

    protected void createButtons(Composite parent) {
        this.fAddButton = new Button(parent, 8);
        this.fAddButton.setText(PDEUIMessages.UpdateSiteWizardPage_add);
        this.fAddButton.setLayoutData((Object)new GridData(2));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateSiteProvisionerPage.this.handleAdd();
            }
        });
        this.fEditButton = new Button(parent, 8);
        this.fEditButton.setText(PDEUIMessages.UpdateSiteWizardPage_edit);
        this.fEditButton.setLayoutData((Object)new GridData(2));
        SWTUtil.setButtonDimensionHint(this.fEditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IUpdateSiteProvisionerEntry entry = (IUpdateSiteProvisionerEntry)((IStructuredSelection)UpdateSiteProvisionerPage.this.fViewer.getSelection()).getFirstElement();
                UpdateSiteProvisionerPage.this.handleEdit(entry);
            }
        });
        this.fRemoveButton = new Button(parent, 8);
        this.fRemoveButton.setText(PDEUIMessages.UpdateSiteWizardPage_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(2));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateSiteProvisionerPage.this.handleRemove();
            }
        });
        this.updateButtons();
    }

    protected void handleRemove() {
        Object[] elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        int i = 0;
        while (i < elements.length) {
            this.fElements.remove(elements[i]);
            ++i;
        }
        this.fViewer.refresh();
        this.updateButtons();
        this.fViewer.getTable().select(this.fElements.size() - 1);
        this.setPageComplete(!this.fElements.isEmpty());
    }

    protected void handleAdd() {
        UpdateSiteProvisionerDialog dialog = new UpdateSiteProvisionerDialog(this.getShell(), null, null, PDEUIMessages.UpdateSiteProvisionerDialog_addTitle);
        int status = dialog.open();
        if (status == 0) {
            this.fElements.add(dialog.getEntry());
            this.fViewer.refresh();
            this.fViewer.getTable().select(this.fElements.indexOf(dialog.getEntry()));
            this.setPageComplete(true);
            this.updateButtons();
        }
    }

    protected void handleEdit(IUpdateSiteProvisionerEntry entry) {
        UpdateSiteProvisionerDialog dialog = new UpdateSiteProvisionerDialog(this.getShell(), entry.getInstallLocation(), entry.getSiteLocation(), PDEUIMessages.UpdateSiteProvisionerDialog_editTitle);
        int status = dialog.open();
        if (status == 0) {
            this.fElements.remove(entry);
            this.fElements.add(dialog.getEntry());
            this.fViewer.refresh();
            this.fViewer.getTable().select(this.fElements.indexOf(dialog.getEntry()));
            this.setPageComplete(true);
        }
        this.updateButtons();
    }

    protected void updateButtons() {
        int num = this.fViewer.getTable().getSelectionCount();
        this.fRemoveButton.setEnabled(num > 0);
        this.fEditButton.setEnabled(num == 1);
    }

    public IUpdateSiteProvisionerEntry[] getEntries() {
        return this.fElements.toArray(new UpdateSiteProvisionerEntry[this.fElements.size()]);
    }

    class UpdateSiteContentProvider
    implements IStructuredContentProvider {
        UpdateSiteContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

