/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.toc;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.toc.HelpEditorUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class TocHTMLWizardPage
extends WizardNewFileCreationPage {
    private String fLastFilename;

    public TocHTMLWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    protected boolean validatePage() {
        this.fLastFilename = this.getFileName().trim();
        if (this.fLastFilename.length() == 0) {
            this.setErrorMessage(null);
            return false;
        }
        if (this.fLastFilename.charAt(0) == '.') {
            this.setErrorMessage(PDEUIMessages.PDEWizardNewFileCreationPage_errorMsgStartsWithDot);
            return false;
        }
        if (!HelpEditorUtil.hasValidPageExtension((IPath)new Path(this.fLastFilename))) {
            String message = NLS.bind((String)PDEUIMessages.TocHTMLWizardPage_badExtension, (Object)HelpEditorUtil.getPageExtensionList());
            this.setErrorMessage(message);
            return false;
        }
        return super.validatePage();
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
    }

    protected void createLinkTarget() {
    }

    protected void createAdvancedControls(Composite parent) {
    }

    public String getFileName() {
        if (this.getControl() != null && this.getControl().isDisposed()) {
            return this.fLastFilename;
        }
        return super.getFileName();
    }
}

