/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.mirror;

import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.metadata.mirror.Mirroring;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;

public class MirrorApplication
implements IApplication {
    private String[] rootSpecs;
    private MetadataRepositoryManager repoManager = new MetadataRepositoryManager();
    private URL sourceLocation;
    private URL destinationLocation;
    private IMetadataRepository source;
    private IMetadataRepository destination;
    private boolean transitive = false;

    public static String[] getArrayArgsFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            if ((token.indexOf(91) >= 0 || token.indexOf(40) >= 0) && tokens.hasMoreTokens()) {
                result.add(String.valueOf(token) + separator + tokens.nextToken());
                continue;
            }
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public Object start(IApplicationContext context) throws Exception {
        this.initializeFromArguments((String[])context.getArguments().get("application.args"));
        this.setupRepositories();
        new Mirroring().mirror(this.source, this.destination, this.rootSpecs, this.transitive);
        return IApplication.EXIT_OK;
    }

    private void setupRepositories() throws ProvisionException {
        if (this.destinationLocation == null || this.sourceLocation == null) {
            throw new IllegalStateException("Must specify a source and destination");
        }
        this.destination = this.initializeDestination();
        this.source = this.repoManager.loadRepository(this.sourceLocation, null);
    }

    private IMetadataRepository initializeDestination() throws ProvisionException {
        try {
            IMetadataRepository repository = this.repoManager.loadRepository(this.destinationLocation, null);
            if (!repository.isModifiable()) {
                throw new IllegalArgumentException("Metadata repository not modifiable: " + this.destinationLocation);
            }
            return repository;
        }
        catch (ProvisionException provisionException) {
            String repositoryName = this.destinationLocation + " - metadata";
            return this.repoManager.createRepository(this.destinationLocation, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
    }

    public void stop() {
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-source")) {
                    this.sourceLocation = new URL(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-destination")) {
                    this.destinationLocation = new URL(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-roots")) {
                    this.rootSpecs = MirrorApplication.getArrayArgsFromString(arg, ",");
                }
                if (args[i - 1].equalsIgnoreCase("-transitive")) {
                    this.transitive = true;
                }
            }
            ++i;
        }
    }
}

