/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CommitAction;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceModelParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceSynchronizeParticipant;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutWizard;
import org.eclipse.team.internal.ui.mapping.ModelElementSelectionPage;
import org.eclipse.team.internal.ui.synchronize.GlobalRefreshElementSelectionPage;
import org.eclipse.team.internal.ui.synchronize.GlobalRefreshResourceSelectionPage;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ParticipantSynchronizeWizard;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public class ModelSynchronizeWizard
extends ParticipantSynchronizeWizard {
    private GlobalRefreshElementSelectionPage selectionPage;

    private boolean isShowModelSync() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("enableModelSync");
    }

    protected void createParticipant() {
        if (this.isShowModelSync()) {
            ISynchronizeParticipant participant = this.createParticipant(((ModelElementSelectionPage)this.selectionPage).getSelectedMappings());
            TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            participant.run(null);
        } else {
            IResource[] resources = ((GlobalRefreshResourceSelectionPage)this.selectionPage).getRootResources();
            if (resources != null && resources.length > 0) {
                SubscriberParticipant participant = this.createParticipant(((GlobalRefreshResourceSelectionPage)this.selectionPage).getSynchronizeScope());
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
                participant.run(null);
            }
        }
    }

    protected final WizardPage createScopeSelectionPage() {
        this.selectionPage = this.isShowModelSync() ? new ModelElementSelectionPage(this.getRootResources()) : new GlobalRefreshResourceSelectionPage(this.getRootResources());
        return this.selectionPage;
    }

    public static ISynchronizeParticipant createWorkspaceParticipant(ResourceMapping[] selectedMappings, Shell shell) {
        SubscriberScopeManager manager = WorkspaceSubscriberContext.createWorkspaceScopeManager(selectedMappings, true, CommitAction.isIncludeChangeSets(shell, CVSUIMessages.SyncAction_1));
        WorkspaceModelParticipant p = new WorkspaceModelParticipant((SynchronizationContext)WorkspaceSubscriberContext.createContext((ISynchronizationScopeManager)manager, 3));
        return p;
    }

    public ModelSynchronizeWizard() {
        this.setNeedsProgressMonitor(this.isShowModelSync());
    }

    protected ISynchronizeParticipant createParticipant(ResourceMapping[] selectedMappings) {
        return ModelSynchronizeWizard.createWorkspaceParticipant(selectedMappings, this.getShell());
    }

    protected SubscriberParticipant createParticipant(ISynchronizeScope scope) {
        WorkspaceSynchronizeParticipant participant;
        IResource[] roots = scope.getRoots();
        if (roots == null) {
            roots = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().roots();
        }
        if ((participant = (WorkspaceSynchronizeParticipant)SubscriberParticipant.getMatchingParticipant((String)"org.eclipse.team.cvs.ui.cvsworkspace-participant", (IResource[])roots)) == null) {
            return new WorkspaceSynchronizeParticipant(scope);
        }
        return participant;
    }

    protected String getPageTitle() {
        ISynchronizeParticipantDescriptor desc = TeamUI.getSynchronizeManager().getParticipantDescriptor("org.eclipse.team.cvs.ui.workspace-participant");
        if (desc != null) {
            return desc.getName();
        }
        return CVSUIMessages.CVSSynchronizeWizard_0;
    }

    protected IWizard getImportWizard() {
        return new CheckoutWizard();
    }

    protected IResource[] getRootResources() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().roots();
    }
}

