/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import java.net.URL;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.StorageLoginDialog;
import org.eclipse.equinox.internal.security.ui.storage.StorageUtils;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DefaultPasswordProvider
extends PasswordProvider {
    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        String defaultFile;
        if (!this.useUI(container)) {
            return null;
        }
        boolean newPassword = (passwordType & 1) != 0;
        boolean passwordChange = (passwordType & 2) != 0;
        String location = container.getLocation().getFile();
        URL defaultURL = InternalExchangeUtils.defaultStorageLocation();
        if (defaultURL != null && (defaultFile = defaultURL.getFile()) != null && defaultFile.equals(location)) {
            location = null;
        }
        final StorageLoginDialog loginDialog = new StorageLoginDialog(newPassword, passwordChange, location);
        final PBEKeySpec[] result = new PBEKeySpec[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = loginDialog.open() == 0 ? loginDialog.getGeneratedPassword() : null;
            }
        });
        return result[0];
    }

    public boolean retryOnError(Exception e, IPreferencesContainer container) {
        if (!this.useUI(container)) {
            return false;
        }
        final Boolean[] result = new Boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                boolean reply = MessageDialog.openConfirm((Shell)StorageUtils.getShell(), (String)SecUIMessages.exceptionTitle, (String)SecUIMessages.exceptionDecode);
                result[0] = new Boolean(reply);
            }
        });
        return result[0];
    }

    private boolean useUI(IPreferencesContainer container) {
        Object promptHint;
        if (!StorageUtils.showUI()) {
            return false;
        }
        if (container.hasOption((Object)"org.eclipse.equinox.security.storage.promptUser") && (promptHint = container.getOption((Object)"org.eclipse.equinox.security.storage.promptUser")) instanceof Boolean) {
            return (Boolean)promptHint;
        }
        return true;
    }
}

