/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator.features;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.generator.features.DefaultSiteParser;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteCategory;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteFeature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.URLEntry;

public class SiteModel {
    private List archiveReferences;
    private Map categories;
    private URLEntry description;
    private List features;
    private URL locationURL;
    private String locationURLString;
    private List mirrors;
    private String mirrorsURLString;
    private boolean supportsPack200;
    private String type;
    private URLEntry[] associateSites;
    private String digestURLString;
    private List messageKeys;
    private Map localizations;

    public void addArchive(URLEntry archiveReference) {
        if (this.archiveReferences == null) {
            this.archiveReferences = new ArrayList();
        }
        if (!this.archiveReferences.contains(archiveReference)) {
            this.archiveReferences.add(archiveReference);
        }
    }

    public void addCategory(SiteCategory category) {
        if (this.categories == null) {
            this.categories = new HashMap();
        }
        if (!this.categories.containsKey(category.getName())) {
            this.categories.put(category.getName(), category);
            if (this.localizations != null && !this.localizations.isEmpty()) {
                category.setLocalizations(this.localizations);
            }
        }
    }

    public void addFeature(SiteFeature featureReference) {
        if (this.features == null) {
            this.features = new ArrayList();
        }
        this.features.add(featureReference);
    }

    public void addMirror(URLEntry mirror) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        if (!this.mirrors.contains(mirror)) {
            this.mirrors.add(mirror);
        }
    }

    private void doSetMirrorSiteEntryModels(URLEntry[] newMirrors) {
        this.mirrors = newMirrors == null || newMirrors.length == 0 ? null : new ArrayList<URLEntry>(Arrays.asList(newMirrors));
    }

    public URLEntry[] getArchives() {
        if (this.archiveReferences == null || this.archiveReferences.size() == 0) {
            return new URLEntry[0];
        }
        return this.archiveReferences.toArray(new URLEntry[0]);
    }

    public URLEntry[] getAssociatedSites() {
        return this.associateSites;
    }

    public SiteCategory[] getCategories() {
        if (this.categories == null || this.categories.size() == 0) {
            return new SiteCategory[0];
        }
        return this.categories.values().toArray(new SiteCategory[0]);
    }

    public SiteCategory getCategory(String name) {
        return this.categories == null ? null : this.categories.get(name);
    }

    public URLEntry getDescription() {
        return this.description;
    }

    public SiteFeature[] getFeatures() {
        if (this.features == null || this.features.size() == 0) {
            return new SiteFeature[0];
        }
        return this.features.toArray(new SiteFeature[0]);
    }

    public Map getLocalizations() {
        return this.localizations;
    }

    public URL getLocationURL() {
        if (this.locationURL == null && this.locationURLString != null) {
            try {
                this.locationURL = new URL(this.locationURLString);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.locationURL;
    }

    public String getLocationURLString() {
        return this.locationURLString;
    }

    public List getMessageKeys() {
        return this.messageKeys;
    }

    public URLEntry[] getMirrors() {
        if ((this.mirrors == null || this.mirrors.size() == 0) && this.mirrorsURLString != null) {
            this.doSetMirrorSiteEntryModels(DefaultSiteParser.getMirrors(this.mirrorsURLString));
        }
        if (this.mirrors == null || this.mirrors.size() == 0) {
            return new URLEntry[0];
        }
        return this.mirrors.toArray(new URLEntry[0]);
    }

    public String getMirrorsURL() {
        return this.mirrorsURLString;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPack200Supported() {
        return this.supportsPack200;
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
    }

    public void setDescription(URLEntry description) {
        this.description = description;
    }

    public void setLocalizations(Map localizations) {
        this.localizations = localizations;
        if (localizations != null && !localizations.isEmpty() && this.categories != null && !this.categories.isEmpty()) {
            Iterator catIter = this.categories.entrySet().iterator();
            while (catIter.hasNext()) {
                Map.Entry entry = catIter.next();
                SiteCategory category = (SiteCategory)entry.getValue();
                category.setLocalizations(localizations);
            }
        }
    }

    public void setLocationURLString(String locationURLString) {
        this.locationURLString = locationURLString;
    }

    public void setMessageKeys(List keys) {
        this.messageKeys = keys;
    }

    public void setMirrors(URLEntry[] mirrors) {
        this.doSetMirrorSiteEntryModels(mirrors);
    }

    public void setMirrorsURLString(String mirrorsURL) {
        this.mirrorsURLString = mirrorsURL;
    }

    public void setSupportsPack200(boolean value) {
        this.supportsPack200 = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAssociateSites(URLEntry[] associateSites) {
        this.associateSites = associateSites;
    }

    public void setDigestURLString(String digestURLString) {
        this.digestURLString = digestURLString;
    }

    public String getDigestURLString() {
        return this.digestURLString;
    }
}

