/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.DiffProject;
import org.eclipse.compare.internal.patch.FileDiff;
import org.eclipse.compare.internal.patch.FileDiffResult;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.LineReader;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchReader;
import org.eclipse.compare.internal.patch.WorkspaceFileDiffResult;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

public class Patcher {
    protected static final String REJECT_FILE_EXTENSION = ".rej";
    protected static final String MARKER_TYPE = "org.eclipse.compare.rejectedPatchMarker";
    public static final String PROP_PATCHER = "org.eclipse.compare.patcher";
    private FileDiff[] fDiffs;
    private IResource fTarget;
    private Set disabledElements = new HashSet();
    private Map diffResults = new HashMap();
    private final Map contentCache = new HashMap();
    private Set mergedHunks = new HashSet();
    private final PatchConfiguration configuration = new PatchConfiguration();
    private boolean fGenerateRejectFile = false;

    public Patcher() {
        this.configuration.setProperty(PROP_PATCHER, this);
    }

    public FileDiff[] getDiffs() {
        if (this.fDiffs == null) {
            return new FileDiff[0];
        }
        return this.fDiffs;
    }

    public IPath getPath(FileDiff diff) {
        return diff.getStrippedPath(this.getStripPrefixSegments(), this.isReversed());
    }

    boolean setStripPrefixSegments(int strip) {
        if (strip != this.getConfiguration().getPrefixSegmentStripCount()) {
            this.getConfiguration().setPrefixSegmentStripCount(strip);
            return true;
        }
        return false;
    }

    int getStripPrefixSegments() {
        return this.getConfiguration().getPrefixSegmentStripCount();
    }

    boolean setFuzz(int fuzz) {
        if (fuzz != this.getConfiguration().getFuzz()) {
            this.getConfiguration().setFuzz(fuzz);
            return true;
        }
        return false;
    }

    int getFuzz() {
        return this.getConfiguration().getFuzz();
    }

    boolean setIgnoreWhitespace(boolean ignoreWhitespace) {
        if (ignoreWhitespace != this.getConfiguration().isIgnoreWhitespace()) {
            this.getConfiguration().setIgnoreWhitespace(ignoreWhitespace);
            return true;
        }
        return false;
    }

    boolean isIgnoreWhitespace() {
        return this.getConfiguration().isIgnoreWhitespace();
    }

    public boolean isGenerateRejectFile() {
        return this.fGenerateRejectFile;
    }

    public void setGenerateRejectFile(boolean generateRejectFile) {
        this.fGenerateRejectFile = generateRejectFile;
    }

    public void parse(IStorage storage) throws IOException, CoreException {
        BufferedReader reader = Patcher.createReader(storage);
        try {
            this.parse(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
    }

    public static BufferedReader createReader(IStorage storage) throws CoreException {
        String charset = null;
        if (storage instanceof IEncodedStorage) {
            IEncodedStorage es = (IEncodedStorage)storage;
            charset = es.getCharset();
        }
        InputStreamReader in = null;
        if (charset != null) {
            InputStream contents = storage.getContents();
            try {
                in = new InputStreamReader(contents, charset);
            }
            catch (UnsupportedEncodingException e) {
                CompareUIPlugin.log(e);
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (in == null) {
            in = new InputStreamReader(storage.getContents());
        }
        return new BufferedReader(in);
    }

    public void parse(BufferedReader reader) throws IOException {
        PatchReader patchReader = new PatchReader();
        patchReader.parse(reader);
        this.patchParsed(patchReader);
    }

    protected void patchParsed(PatchReader patchReader) {
        this.fDiffs = patchReader.getDiffs();
    }

    public void countLines() {
        FileDiff[] fileDiffs = this.getDiffs();
        int i = 0;
        while (i < fileDiffs.length) {
            int addedLines = 0;
            int removedLines = 0;
            FileDiff fileDiff = fileDiffs[i];
            int j = 0;
            while (j < fileDiff.getHunkCount()) {
                Hunk hunk = fileDiff.getHunks()[j];
                String[] lines = hunk.getLines();
                int k = 0;
                while (k < lines.length) {
                    char c = lines[k].charAt(0);
                    switch (c) {
                        case '+': {
                            ++addedLines;
                            break;
                        }
                        case '-': {
                            ++removedLines;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            fileDiff.setAddedLines(addedLines);
            fileDiff.setRemovedLines(removedLines);
            ++i;
        }
    }

    public void applyAll(IProgressMonitor pm, Shell shell, String title) throws CoreException {
        int i;
        IFile singleFile = null;
        IContainer container = null;
        if (this.fTarget instanceof IContainer) {
            container = (IContainer)this.fTarget;
        } else if (this.fTarget instanceof IFile) {
            singleFile = (IFile)this.fTarget;
            container = singleFile.getParent();
        } else {
            Assert.isTrue((boolean)false);
        }
        ArrayList<IFile> list = new ArrayList<IFile>();
        if (singleFile != null) {
            list.add(singleFile);
        } else {
            i = 0;
            while (i < this.fDiffs.length) {
                FileDiff diff = this.fDiffs[i];
                if (this.isEnabled(diff)) {
                    switch (diff.getDiffType(this.isReversed())) {
                        case 3: {
                            list.add(this.createPath(container, this.getPath(diff)));
                        }
                    }
                }
                ++i;
            }
        }
        if (!Utilities.validateResources(list, shell, title)) {
            return;
        }
        if (pm != null) {
            String message = PatchMessages.Patcher_Task_message;
            pm.beginTask(message, this.fDiffs.length * 10);
        }
        i = 0;
        while (i < this.fDiffs.length) {
            int workTicks = 10;
            FileDiff diff = this.fDiffs[i];
            if (this.isEnabled(diff)) {
                IPath pp;
                IPath path = this.getPath(diff);
                if (pm != null) {
                    pm.subTask(path.toString());
                }
                IFile file = singleFile != null ? singleFile : this.createPath(container, path);
                ArrayList failed = new ArrayList();
                int type = diff.getDiffType(this.isReversed());
                switch (type) {
                    case 1: {
                        List result = this.apply(diff, file, true, failed);
                        if (result != null) {
                            this.store(Patcher.createString(this.isPreserveLineDelimeters(), result), file, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                        }
                        workTicks -= 10;
                        break;
                    }
                    case 2: {
                        file.delete(true, true, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                        workTicks -= 10;
                        break;
                    }
                    case 3: {
                        List result = this.apply(diff, file, false, failed);
                        if (result != null) {
                            this.store(Patcher.createString(this.isPreserveLineDelimeters(), result), file, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                        }
                        workTicks -= 10;
                    }
                }
                if (this.isGenerateRejectFile() && failed.size() > 0 && (file = this.createPath(container, pp = this.getRejectFilePath(path))) != null) {
                    this.store(Patcher.getRejected(failed), file, pm);
                    try {
                        IMarker marker = file.createMarker(MARKER_TYPE);
                        marker.setAttribute("message", (Object)PatchMessages.Patcher_Marker_message);
                        marker.setAttribute("priority", 2);
                    }
                    catch (CoreException coreException) {}
                }
            }
            if (pm != null) {
                if (pm.isCanceled()) break;
                if (workTicks > 0) {
                    pm.worked(workTicks);
                }
            }
            ++i;
        }
    }

    private IPath getRejectFilePath(IPath path) {
        IPath pp = null;
        if (path.segmentCount() > 1) {
            pp = path.removeLastSegments(1);
            pp = pp.append(String.valueOf(path.lastSegment()) + REJECT_FILE_EXTENSION);
        } else {
            pp = new Path(String.valueOf(path.lastSegment()) + REJECT_FILE_EXTENSION);
        }
        return pp;
    }

    public static List load(IStorage file, boolean create) {
        List lines;
        block18: {
            lines = null;
            if (!create && file != null && Patcher.exists(file)) {
                String charset = Utilities.getCharset(file);
                InputStream is = null;
                try {
                    try {
                        is = file.getContents();
                        InputStreamReader streamReader = null;
                        try {
                            streamReader = new InputStreamReader(is, charset);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            streamReader = new InputStreamReader(is);
                        }
                        BufferedReader reader = new BufferedReader(streamReader);
                        lines = Patcher.readLines(reader);
                    }
                    catch (CoreException ex) {
                        CompareUIPlugin.log(ex);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (lines == null) {
            lines = new ArrayList();
        }
        return lines;
    }

    private static boolean exists(IStorage file) {
        if (file instanceof IFile) {
            return ((IFile)file).exists();
        }
        return true;
    }

    private static List readLines(BufferedReader reader) {
        LineReader lr = new LineReader(reader);
        if (!"carbon".equals(SWT.getPlatform())) {
            lr.ignoreSingleCR();
        }
        List lines = lr.readLines();
        return lines;
    }

    List apply(FileDiff diff, IFile file, boolean create, List failedHunks) {
        FileDiffResult result = this.getDiffResult(diff);
        List lines = Patcher.load((IStorage)file, create);
        result.patch(lines, null);
        failedHunks.addAll(result.getFailedHunks());
        if (this.hasCachedContents(diff)) {
            return this.getCachedLines(diff);
        }
        if (!result.hasMatches()) {
            return null;
        }
        return result.getLines();
    }

    protected void store(String contents, IFile file, IProgressMonitor pm) throws CoreException {
        byte[] bytes;
        try {
            bytes = contents.getBytes(Utilities.getCharset(file));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = contents.getBytes();
        }
        this.store(bytes, file, pm);
    }

    protected void store(byte[] bytes, IFile file, IProgressMonitor pm) throws CoreException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            if (file.exists()) {
                file.setContents((InputStream)is, false, true, pm);
            } else {
                file.create((InputStream)is, false, pm);
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String createString(boolean preserveLineDelimeters, List lines) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = lines.iterator();
        if (preserveLineDelimeters) {
            while (iter.hasNext()) {
                sb.append((String)iter.next());
            }
        } else {
            String lineSeparator = System.getProperty("line.separator");
            while (iter.hasNext()) {
                String line = (String)iter.next();
                int l = Patcher.length(line);
                if (l < line.length()) {
                    sb.append(line.substring(0, l));
                    sb.append(lineSeparator);
                    continue;
                }
                sb.append(line);
            }
        }
        return sb.toString();
    }

    protected boolean isPreserveLineDelimeters() {
        return false;
    }

    public static String getRejected(List failedHunks) {
        if (failedHunks.size() <= 0) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        Iterator iter = failedHunks.iterator();
        while (iter.hasNext()) {
            Hunk hunk = (Hunk)iter.next();
            sb.append(hunk.getRejectedDescription());
            sb.append(lineSeparator);
            sb.append(hunk.getContent());
        }
        return sb.toString();
    }

    protected IFile createPath(IContainer container, IPath path) throws CoreException {
        if (path.segmentCount() > 1) {
            IFolder childContainer;
            if (container instanceof IWorkspaceRoot) {
                IProject project = ((IWorkspaceRoot)container).getProject(path.segment(0));
                if (!project.exists()) {
                    project.create(null);
                }
                if (!project.isOpen()) {
                    project.open(null);
                }
                childContainer = project;
            } else {
                IFolder f = container.getFolder(path.uptoSegment(1));
                if (!f.exists()) {
                    f.create(false, true, null);
                }
                childContainer = f;
            }
            return this.createPath((IContainer)childContainer, path.removeFirstSegments(1));
        }
        return container.getFile(path);
    }

    static int length(String s) {
        int l = s.length();
        if (l > 0) {
            char c = s.charAt(l - 1);
            if (c == '\r') {
                return l - 1;
            }
            if (c == '\n') {
                if (l > 1 && s.charAt(l - 2) == '\r') {
                    return l - 2;
                }
                return l - 1;
            }
        }
        return l;
    }

    public IResource getTarget() {
        return this.fTarget;
    }

    public void setTarget(IResource target) {
        this.fTarget = target;
    }

    protected IFile getTargetFile(FileDiff diff) {
        IPath path = diff.getStrippedPath(this.getStripPrefixSegments(), this.isReversed());
        return this.existsInTarget(path);
    }

    public IFile existsInTarget(IPath path) {
        IContainer c;
        if (this.fTarget instanceof IFile) {
            IFile file = (IFile)this.fTarget;
            if (this.matches(file.getFullPath(), path)) {
                return file;
            }
        } else if (this.fTarget instanceof IContainer && (c = (IContainer)this.fTarget).exists(path)) {
            return c.getFile(path);
        }
        return null;
    }

    private boolean matches(IPath fullpath, IPath path) {
        IPath p = fullpath;
        while (path.segmentCount() <= p.segmentCount()) {
            if (p.equals((Object)path)) {
                return true;
            }
            p = p.removeFirstSegments(1);
        }
        return false;
    }

    public int calculatePrefixSegmentCount() {
        int length = 99;
        if (this.fDiffs != null) {
            int i = 0;
            while (i < this.fDiffs.length) {
                FileDiff diff = this.fDiffs[i];
                length = Math.min(length, diff.segmentCount());
                ++i;
            }
        }
        return length;
    }

    public void addDiff(FileDiff newDiff) {
        FileDiff[] temp = new FileDiff[this.fDiffs.length + 1];
        System.arraycopy(this.fDiffs, 0, temp, 0, this.fDiffs.length);
        temp[this.fDiffs.length] = newDiff;
        this.fDiffs = temp;
    }

    public void removeDiff(FileDiff diffToRemove) {
        FileDiff[] temp = new FileDiff[this.fDiffs.length - 1];
        int counter = 0;
        int i = 0;
        while (i < this.fDiffs.length) {
            if (this.fDiffs[i] != diffToRemove) {
                temp[counter++] = this.fDiffs[i];
            }
            ++i;
        }
        this.fDiffs = temp;
    }

    public void setEnabled(Object element, boolean enabled) {
        if (element instanceof DiffProject) {
            this.setEnabledProject((DiffProject)element, enabled);
        }
        if (element instanceof FileDiff) {
            this.setEnabledFile((FileDiff)element, enabled);
        }
        if (element instanceof Hunk) {
            this.setEnabledHunk((Hunk)element, enabled);
        }
    }

    private void setEnabledProject(DiffProject projectDiff, boolean enabled) {
        FileDiff[] diffFiles = projectDiff.getFileDiffs();
        int i = 0;
        while (i < diffFiles.length) {
            this.setEnabledFile(diffFiles[i], enabled);
            ++i;
        }
    }

    private void setEnabledFile(FileDiff fileDiff, boolean enabled) {
        Hunk[] hunks = fileDiff.getHunks();
        int i = 0;
        while (i < hunks.length) {
            this.setEnabledHunk(hunks[i], enabled);
            ++i;
        }
    }

    private void setEnabledHunk(Hunk hunk, boolean enabled) {
        if (enabled) {
            this.disabledElements.remove(hunk);
            FileDiff file = hunk.getParent();
            this.disabledElements.remove(file);
            DiffProject project = file.getProject();
            if (project != null) {
                this.disabledElements.remove(project);
            }
        } else {
            this.disabledElements.add(hunk);
            FileDiff file = hunk.getParent();
            if (this.disabledElements.containsAll(Arrays.asList(file.getHunks()))) {
                this.disabledElements.add(file);
                DiffProject project = file.getProject();
                if (project != null && this.disabledElements.containsAll(Arrays.asList(project.getFileDiffs()))) {
                    this.disabledElements.add(project);
                }
            }
        }
    }

    public boolean isEnabled(Object element) {
        if (this.disabledElements.contains(element)) {
            return false;
        }
        Object parent = this.getElementParent(element);
        if (parent == null) {
            return true;
        }
        return this.isEnabled(parent);
    }

    protected Object getElementParent(Object element) {
        if (element instanceof Hunk) {
            Hunk hunk = (Hunk)element;
            return hunk.getParent();
        }
        return null;
    }

    public int guessFuzzFactor(IProgressMonitor monitor) {
        try {
            monitor.beginTask(PatchMessages.PreviewPatchPage_GuessFuzzProgress_text, -1);
            FileDiff[] diffs = this.getDiffs();
            if (diffs == null || diffs.length <= 0) {
                return -1;
            }
            int fuzz = -1;
            int i = 0;
            while (i < diffs.length) {
                FileDiff d = diffs[i];
                IFile file = this.getTargetFile(d);
                if (file != null && file.exists()) {
                    List lines = Patcher.load((IStorage)file, false);
                    FileDiffResult result = this.getDiffResult(d);
                    int f = result.calculateFuzz(lines, monitor);
                    if (f > fuzz) {
                        fuzz = f;
                    }
                }
                ++i;
            }
            int n = fuzz;
            return n;
        }
        finally {
            monitor.done();
        }
    }

    public void refresh() {
        this.diffResults.clear();
        this.refresh(this.getDiffs());
    }

    protected void refresh(FileDiff[] diffs) {
        int i = 0;
        while (i < diffs.length) {
            FileDiff diff = diffs[i];
            FileDiffResult result = this.getDiffResult(diff);
            ((WorkspaceFileDiffResult)result).refresh();
            ++i;
        }
    }

    public FileDiffResult getDiffResult(FileDiff diff) {
        FileDiffResult result = (FileDiffResult)this.diffResults.get(diff);
        if (result == null) {
            result = new WorkspaceFileDiffResult(diff, this.getConfiguration());
            this.diffResults.put(diff, result);
        }
        return result;
    }

    public PatchConfiguration getConfiguration() {
        return this.configuration;
    }

    public DiffProject getProject(FileDiff diff) {
        return diff.getProject();
    }

    public boolean setReversed(boolean reverse) {
        if (this.getConfiguration().isReversed() != reverse) {
            this.getConfiguration().setReversed(reverse);
            this.refresh();
            return true;
        }
        return false;
    }

    public boolean isReversed() {
        return this.getConfiguration().isReversed();
    }

    public void cacheContents(FileDiff diff, byte[] contents) {
        this.contentCache.put(diff, contents);
    }

    public boolean hasCachedContents(FileDiff diff) {
        return this.contentCache.containsKey(diff);
    }

    public List getCachedLines(FileDiff diff) {
        byte[] contents = (byte[])this.contentCache.get(diff);
        if (contents != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(contents)));
            return Patcher.readLines(reader);
        }
        return null;
    }

    public byte[] getCachedContents(FileDiff diff) {
        return (byte[])this.contentCache.get(diff);
    }

    public boolean hasCachedContents() {
        return !this.contentCache.isEmpty();
    }

    public void clearCachedContents() {
        this.contentCache.clear();
        this.mergedHunks.clear();
    }

    public void setProperty(String key, Object value) {
        this.getConfiguration().setProperty(key, value);
    }

    public Object getProperty(String key) {
        return this.getConfiguration().getProperty(key);
    }

    public boolean isManuallyMerged(Hunk hunk) {
        return this.mergedHunks.contains(hunk);
    }

    public void setManuallyMerged(Hunk hunk, boolean merged) {
        if (merged) {
            this.mergedHunks.add(hunk);
        } else {
            this.mergedHunks.remove(hunk);
        }
    }

    public IProject getTargetProject(FileDiff diff) {
        DiffProject dp = this.getProject(diff);
        if (dp != null) {
            return dp.getProject();
        }
        IResource tr = this.getTarget();
        if (tr instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)tr;
            return root.getProject(diff.getPath(this.isReversed()).segment(0));
        }
        return tr.getProject();
    }

    public static Patcher getPatcher(PatchConfiguration configuration) {
        return (Patcher)configuration.getProperty(PROP_PATCHER);
    }

    public boolean hasRejects() {
        Iterator iterator = this.diffResults.values().iterator();
        while (iterator.hasNext()) {
            FileDiffResult result = (FileDiffResult)iterator.next();
            if (!result.hasRejects()) continue;
            return true;
        }
        return false;
    }
}

