/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.wpf.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }

    public TransferData[] getSupportedTypes() {
        int[] ids = this.getTypeIds();
        TransferData[] result = new TransferData[ids.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new TransferData();
            result[i].type = ids[i];
            ++i;
        }
        return result;
    }

    protected String[] getTypeNames() {
        int[] ids = this.getTypeIds();
        String[] result = new String[ids.length];
        int i = 0;
        while (i < result.length) {
            result[i] = ByteArrayTransfer.getTypeName(ids[i]);
            ++i;
        }
        return result;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] ids = this.getTypeIds();
        int i = 0;
        while (i < ids.length) {
            if (transferData.type == ids[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] buffer;
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((buffer = (byte[])object).length == 0) {
            return;
        }
        int typeid = OS.Byte_typeid();
        int pValue = OS.Array_CreateInstance(typeid, buffer.length);
        OS.GCHandle_Free(typeid);
        if (pValue == 0) {
            return;
        }
        OS.memcpy(pValue, buffer, buffer.length);
        transferData.pValue = pValue;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int byteArray = transferData.pValue;
        int length = OS.Array_GetLength(byteArray, 0);
        byte[] buffer = new byte[length];
        if (length == 0) {
            return buffer;
        }
        OS.memcpy(buffer, transferData.pValue, length);
        return buffer;
    }
}

