/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.wpf.OS;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static int TYPEID = ImageTransfer.getTypeId();

    static int getTypeId() {
        int format = OS.DataFormats_Bitmap();
        String name = ImageTransfer.createJavaString(format);
        OS.GCHandle_Free(format);
        return ImageTransfer.registerType(name);
    }

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        ImageData imgData;
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((imgData = (ImageData)object) == null) {
            SWT.error(4);
        }
        Image image = new Image(null, imgData);
        transferData.pValue = image.handle;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        Image image = Image.wpf_new(null, 0, transferData.pValue);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

