/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int dialog = OS.gcnew_ColorDialog();
        if (this.rgb != null) {
            int color = OS.DrawingColor_FromArgb(174, this.rgb.red, this.rgb.blue, this.rgb.green);
            OS.ColorDialog_Color(dialog, color);
            OS.GCHandle_Free(color);
        }
        Display display = this.parent.getDisplay();
        int customColors = display.customColors;
        OS.ColorDialog_AnyColor(dialog, true);
        OS.ColorDialog_CustomColors(dialog, customColors);
        int result = OS.FormsCommonDialog_ShowDialog(dialog);
        RGB rgb = null;
        if (result == 1) {
            int color = OS.ColorDialog_Color(dialog);
            int argb = OS.DrawingColor_ToArgb(color);
            int red = (argb & 0xFF0000) >> 16;
            int green = (argb & 0xFF00) >> 8;
            int blue = argb & 0xFF;
            OS.GCHandle_Free(color);
            rgb = new RGB(red, green, blue);
            if (customColors != 0) {
                OS.GCHandle_Free(customColors);
            }
            display.customColors = OS.ColorDialog_CustomColors(dialog);
        }
        OS.GCHandle_Free(dialog);
        return rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

