/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.effects.Effect;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    Cursor cursor;
    Menu menu;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Image backgroundImage;
    Region region;
    int foreground;
    int background;
    int x;
    int y;
    int width;
    int height;
    Font font;
    Composite parent;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    void addWidget() {
        this.parent.addChild(this);
    }

    int borderHandle() {
        return this.handle;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0) {
                if (mode == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x100) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBorder() {
        if (this.getBorderWidth() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return this.computeSize(this.handle, wHint, hHint, changed);
    }

    Point computeSize(int handle, int wHint, int hHint, boolean changed) {
        double requestHeight;
        double requestWidth;
        int availSize;
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = Integer.MAX_VALUE;
        }
        if (hHint == -1) {
            height = Integer.MAX_VALUE;
        }
        if ((availSize = OS.gcnew_Size(width = Math.max(0, width), height = Math.max(0, height))) == 0) {
            this.error(2);
        }
        if ((requestWidth = OS.FrameworkElement_Width(handle)) >= 0.0) {
            int widthDP = OS.FrameworkElement_WidthProperty();
            OS.DependencyObject_ClearValue(handle, widthDP);
            OS.GCHandle_Free(widthDP);
        }
        if ((requestHeight = OS.FrameworkElement_Height(handle)) >= 0.0) {
            int heightDP = OS.FrameworkElement_HeightProperty();
            OS.DependencyObject_ClearValue(handle, heightDP);
            OS.GCHandle_Free(heightDP);
        }
        OS.UIElement_Measure(handle, availSize);
        OS.GCHandle_Free(availSize);
        int size = OS.UIElement_DesiredSize(handle);
        width = (int)OS.Size_Width(size);
        height = (int)OS.Size_Height(size);
        OS.GCHandle_Free(size);
        if (requestWidth >= 0.0) {
            OS.FrameworkElement_Width(handle, requestWidth);
        }
        if (requestHeight >= 0.0) {
            OS.FrameworkElement_Height(handle, requestHeight);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createWidget() {
        this.state |= 0x8000;
        this.checkOrientation(this.parent);
        super.createWidget();
        this.checkBackground();
        this.checkBuffered();
        this.setClipping();
        if (this.defaultBackground() != 0 || (this.state & 0x400) != 0) {
            this.setBackground();
        }
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
        OS.UIElement_Opacity(this.handle, (double)(alpha & 0xFF) / 255.0);
    }

    void setClipping() {
    }

    int defaultBackground() {
        return 0;
    }

    Font defaultFont() {
        return this.display.getSystemFont();
    }

    int defaultForeground() {
        return this.display.getSystemColor((int)2).handle;
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.removeChild(this);
        this.releaseHandle();
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    boolean dragDetect(int button, int count, int stateMask, int x, int y) {
        if (button != 1 || count != 1) {
            return false;
        }
        boolean dragging = this.dragDetect(x, y, false);
        if (dragging) {
            return this.sendDragEvent(button, stateMask, x, y);
        }
        return false;
    }

    void dragHandler() {
        int frame = this.display.dragDetectFrame = OS.gcnew_DispatcherFrame();
        OS.Dispatcher_PushFrame(frame);
        OS.GCHandle_Free(frame);
        OS.GCHandle_Free(this.display.dragRect);
        if (this.display.dragMouseDown != 0) {
            OS.GCHandle_Free(this.display.dragMouseDown);
        }
        this.display.dragRect = 0;
        this.display.dragDetectFrame = 0;
        this.display.dragMouseDown = 0;
    }

    boolean dragDetect(double x, double y, boolean post) {
        this.display.dragging = false;
        double minH = OS.SystemParameters_MinimumHorizontalDragDistance();
        double minV = OS.SystemParameters_MinimumVerticalDragDistance();
        this.display.dragRect = OS.gcnew_Rect(x - minH, y - minV, minH * 2.0, minV * 2.0);
        if (post) {
            int handler = OS.gcnew_NoArgsDelegate(this.jniRef, "dragHandler");
            int operation = OS.Dispatcher_BeginInvoke(this.display.dispatcher, 10, handler);
            OS.GCHandle_Free(operation);
            OS.GCHandle_Free(handler);
        } else {
            this.dragHandler();
        }
        return this.display.dragging;
    }

    void enableWidget(boolean enabled) {
        OS.UIElement_IsEnabled(this.handle, enabled);
    }

    boolean drawGripper(int x, int y, int width, int height, boolean vertical) {
        return false;
    }

    Control findBackgroundControl() {
        if (this.background != 0 || this.backgroundImage != null) {
            return this;
        }
        return (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Control findThemeControl() {
        return this.background == 0 && this.backgroundImage == null ? this.parent.findThemeControl() : null;
    }

    Control findImageControl() {
        Control control = this.findBackgroundControl();
        return control != null && control.backgroundImage != null ? control : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    char findMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        OS.UIElement_Focus(shell.shellHandle);
    }

    public boolean forceFocus() {
        this.checkWidget();
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.setSavedFocus(null);
        OS.UIElement_Focus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        shell.setSavedFocus(this);
        return this.isFocusControl();
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public int getAlpha() {
        this.checkWidget();
        return (int)(255.0 * OS.UIElement_Opacity(this.handle));
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.wpf_new(this.display, control.getBackgroundColor());
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    int getBackgroundColor() {
        int color = this.background;
        if (color == 0) {
            color = this.defaultBackground();
        }
        if (color == 0) {
            color = OS.SystemColors_ControlColor;
        }
        return color;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 2;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.topHandle();
        Point location = this.parent.getLocation(this);
        int width = (int)OS.FrameworkElement_Width(topHandle);
        int height = (int)OS.FrameworkElement_Height(topHandle);
        return new Rectangle(location.x, location.y, width, height);
    }

    String getClipboardText() {
        String string = "";
        int text = OS.Clipboard_GetText();
        if (text != 0) {
            string = Control.createJavaString(text);
            OS.GCHandle_Free(text);
        }
        return string;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x8000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.wpf_new(this.display, this.getForegroundColor());
    }

    int getForegroundColor() {
        return this.foreground != 0 ? this.foreground : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        return this.parent.getLocation(this);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        return this.display.getPrimaryMonitor();
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int width = (int)OS.FrameworkElement_Width(topHandle);
        int height = (int)OS.FrameworkElement_Height(topHandle);
        return new Point(width, height);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public Transform getTransform() {
        int transform = OS.FrameworkElement_RenderTransform(this.handle);
        int matrix = OS.MatrixTransform_Matrix(transform);
        OS.GCHandle_Free(transform);
        float m11 = (float)OS.Matrix_M11(matrix);
        float m12 = (float)OS.Matrix_M12(matrix);
        float m21 = (float)OS.Matrix_M21(matrix);
        float m22 = (float)OS.Matrix_M22(matrix);
        float dx = (float)OS.Matrix_OffsetX(matrix);
        float dy = (float)OS.Matrix_OffsetY(matrix);
        OS.GCHandle_Free(matrix);
        return new Transform(this.display, m11, m12, m21, m22, dx, dy);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.UIElement_Visibility(this.topHandle()) == 0;
    }

    Control getWidgetControl() {
        return this;
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_KeyEventHandler(this.jniRef, "HandlePreviewKeyDown");
        OS.UIElement_PreviewKeyDown(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_KeyEventHandler(this.jniRef, "HandlePreviewKeyUp");
        OS.UIElement_PreviewKeyUp(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_TextCompositionEventHandler(this.jniRef, "HandlePreviewTextInput");
        OS.UIElement_PreviewTextInput(this.handle, handler);
        OS.GCHandle_Free(handler);
        int topHandle = this.topHandle();
        handler = OS.gcnew_MouseButtonEventHandler(this.jniRef, "HandlePreviewMouseDown");
        OS.UIElement_PreviewMouseDown(topHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseButtonEventHandler(this.jniRef, "HandlePreviewMouseUp");
        OS.UIElement_PreviewMouseUp(topHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseEventHandler(this.jniRef, "HandleMouseEnter");
        OS.UIElement_MouseEnter(topHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseEventHandler(this.jniRef, "HandleMouseLeave");
        OS.UIElement_MouseLeave(topHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseEventHandler(this.jniRef, "HandlePreviewMouseMove");
        OS.UIElement_PreviewMouseMove(topHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseWheelEventHandler(this.jniRef, "HandlePreviewMouseWheel");
        OS.UIElement_PreviewMouseWheel(topHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_KeyboardFocusChangedEventHandler(this.jniRef, "HandlePreviewGotKeyboardFocus");
        OS.UIElement_PreviewGotKeyboardFocus(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_KeyboardFocusChangedEventHandler(this.jniRef, "HandleLostKeyboardFocus");
        OS.UIElement_LostKeyboardFocus(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_ContextMenuEventHandler(this.jniRef, "HandleContextMenuOpening");
        OS.FrameworkElement_ContextMenuOpening(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_SizeChangedEventHandler(this.jniRef, "HandleSizeChanged");
        OS.FrameworkElement_SizeChanged(topHandle, handler);
        OS.GCHandle_Free(handler);
        int typeid = OS.Canvas_typeid();
        handler = OS.gcnew_EventHandler(this.jniRef, "HandleTopChanged");
        int property = OS.Canvas_TopProperty();
        int dpd = OS.DependencyPropertyDescriptor_FromProperty(property, typeid);
        OS.DependencyPropertyDescriptor_AddValueChanged(dpd, topHandle, handler);
        OS.GCHandle_Free(handler);
        OS.GCHandle_Free(property);
        OS.GCHandle_Free(dpd);
        handler = OS.gcnew_EventHandler(this.jniRef, "HandleLeftChanged");
        property = OS.Canvas_LeftProperty();
        dpd = OS.DependencyPropertyDescriptor_FromProperty(property, typeid);
        OS.DependencyPropertyDescriptor_AddValueChanged(dpd, topHandle, handler);
        OS.GCHandle_Free(handler);
        OS.GCHandle_Free(property);
        OS.GCHandle_Free(dpd);
        OS.GCHandle_Free(typeid);
    }

    void HandleLeftChanged(int sender, int e) {
        int topHandle = this.topHandle();
        int x = (int)OS.Canvas_GetLeft(topHandle);
        int y = (int)OS.Canvas_GetTop(topHandle);
        if (x != this.x || y != this.y) {
            this.x = x;
            this.y = y;
            this.sendEvent(10);
        }
    }

    void HandleTopChanged(int sender, int e) {
        int topHandle = this.topHandle();
        int x = (int)OS.Canvas_GetLeft(topHandle);
        int y = (int)OS.Canvas_GetTop(topHandle);
        if (x != this.x || y != this.y) {
            this.x = x;
            this.y = y;
            this.sendEvent(10);
        }
    }

    void HandleContextMenuOpening(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int mouse = OS.Mouse_GetPosition(this.handle);
        int x = (int)OS.Point_X(mouse);
        int y = (int)OS.Point_Y(mouse);
        OS.GCHandle_Free(mouse);
        Point point = this.display.map(this, null, x, y);
        this.showMenu(point.x, point.y);
        OS.RoutedEventArgs_Handled(e, true);
    }

    void HandlePreviewGotKeyboardFocus(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (OS.UIElement_IsKeyboardFocusWithin(this.handle)) {
            return;
        }
        this.sendFocusEvent(15);
    }

    void HandleLostKeyboardFocus(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (OS.UIElement_IsKeyboardFocusWithin(this.handle)) {
            return;
        }
        this.sendFocusEvent(16);
    }

    void HandlePreviewKeyDown(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.display.dragDetectFrame != 0 && OS.KeyEventArgs_Key(e) == 13) {
            OS.DispatcherFrame_Continue(this.display.dragDetectFrame, false);
        }
        if (this.translateTraversal(e)) {
            OS.RoutedEventArgs_Handled(e, true);
            return;
        }
        this.sendKeyEvent(1, e, false);
    }

    void HandlePreviewKeyUp(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendKeyEvent(2, e, false);
    }

    void HandlePreviewMouseDown(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.state & 2) != 0) {
            OS.UIElement_CaptureMouse(this.handle);
        }
        if (OS.MouseButtonEventArgs_ChangedButton(e) == 0 && OS.MouseButtonEventArgs_ClickCount(e) == 1 && (this.state & 0x8000) != 0 && this.hooks(29)) {
            int point = OS.MouseEventArgs_GetPosition(e, this.handle);
            double x = OS.Point_X(point);
            double y = OS.Point_Y(point);
            OS.GCHandle_Free(point);
            this.display.dragMouseDown = OS.GCHandle_Alloc(e);
            this.dragDetect(x, y, true);
        }
        this.sendMouseEvent(3, e, false);
    }

    void HandlePreviewMouseUp(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.state & 2) != 0) {
            OS.UIElement_ReleaseMouseCapture(this.handle);
        }
        if (this.display.dragDetectFrame != 0) {
            OS.DispatcherFrame_Continue(this.display.dragDetectFrame, false);
        }
        this.sendMouseEvent(4, e, false);
    }

    void HandleMouseEnter(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        Control control = this.display.getCursorControl();
        if (control != this) {
            return;
        }
        Control lastMouseControl = this.display.mouseControl;
        if (lastMouseControl != null && !lastMouseControl.isDisposed() && lastMouseControl != this && OS.Visual_IsDescendantOf(this.topHandle(), lastMouseControl.topHandle())) {
            lastMouseControl.sendMouseEvent(7, e, false);
        }
        this.display.mouseControl = this;
        this.sendMouseEvent(6, e, false);
    }

    void HandleMouseLeave(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this != this.display.mouseControl) {
            return;
        }
        this.sendMouseEvent(7, e, false);
    }

    void HandlePreviewMouseMove(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.display.dragDetectFrame != 0) {
            OS.RoutedEventArgs_Handled(e, true);
            int point = OS.MouseEventArgs_GetPosition(e, this.handle);
            boolean contains = OS.Rect_Contains(this.display.dragRect, point);
            OS.GCHandle_Free(point);
            if (!contains) {
                this.display.dragging = true;
                OS.DispatcherFrame_Continue(this.display.dragDetectFrame, false);
                if (this.display.dragMouseDown != 0) {
                    this.sendDragEvent(this.display.dragMouseDown);
                    OS.GCHandle_Free(this.display.dragMouseDown);
                    this.display.dragMouseDown = 0;
                }
            }
            return;
        }
        Control lastMouseControl = this.display.mouseControl;
        if (lastMouseControl != null && !lastMouseControl.isDisposed() && lastMouseControl != this && OS.Visual_IsAncestorOf(this.topHandle(), lastMouseControl.topHandle())) {
            this.sendMouseEvent(6, e, false);
        }
        this.display.mouseControl = this;
        this.sendMouseEvent(5, e, false);
    }

    void HandlePreviewMouseWheel(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendMouseEvent(37, e, false);
    }

    void HandlePreviewTextInput(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendKeyEvent(1, e, true);
    }

    void HandleSizeChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int topHandle = this.topHandle();
        int width = (int)OS.FrameworkElement_ActualWidth(topHandle);
        int height = (int)OS.FrameworkElement_ActualHeight(topHandle);
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.resized();
        }
    }

    void resized() {
        this.sendEvent(11);
    }

    boolean hasFocus() {
        return this.display.getFocusControl() == this;
    }

    public int internal_new_GC(GCData data) {
        this.checkWidget();
        int drawingContext = data != null ? data.drawingContext : 0;
        int visual = this.handle;
        double width = OS.FrameworkElement_ActualWidth(this.handle);
        double height = OS.FrameworkElement_ActualHeight(this.handle);
        int rect = OS.gcnew_Rect(0.0, 0.0, width, height);
        int clip = OS.gcnew_RectangleGeometry(rect);
        if (drawingContext != 0) {
            OS.DrawingContext_PushClip(drawingContext, clip);
        } else {
            if ((this.state & 2) != 0) {
                visual = OS.SWTCanvas_Visual(this.handle);
                if (visual == 0) {
                    visual = OS.gcnew_DrawingVisual();
                    if (visual == 0) {
                        SWT.error(2);
                    }
                    OS.SWTCanvas_Visual(this.handle, visual);
                }
            } else {
                visual = OS.gcnew_DrawingVisual();
                if (visual == 0) {
                    SWT.error(2);
                }
            }
            OS.ContainerVisual_Clip(visual, clip);
            int dc = OS.DrawingVisual_RenderOpen(visual);
            if (dc == 0) {
                SWT.error(2);
            }
            drawingContext = dc;
            int drawing = OS.DrawingVisual_Drawing(visual);
            OS.DrawingContext_DrawDrawing(drawingContext, drawing);
            OS.GCHandle_Free(drawing);
        }
        OS.GCHandle_Free(rect);
        OS.GCHandle_Free(clip);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            }
            data.device = this.display;
            data.foreground = this.getForegroundColor();
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            data.background = control.getBackgroundColor();
            data.font = this.font != null ? this.font : this.defaultFont();
            data.visual = visual;
        }
        return drawingContext;
    }

    public void internal_dispose_GC(int dc, GCData data) {
        this.checkWidget();
        if (data != null && data.drawingContext == 0) {
            OS.DrawingContext_Close(dc);
            OS.GCHandle_Free(dc);
            OS.GCHandle_Free(data.visual);
        }
    }

    boolean isActive() {
        Control shell = null;
        Shell[] modalShells = this.display.modalShells;
        if (modalShells != null) {
            int bits = 196608;
            int index = modalShells.length;
            while (--index >= 0) {
                Shell modal = modalShells[index];
                if (modal == null) continue;
                if ((modal.style & bits) != 0) {
                    Control control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control == modal) break;
                    return false;
                }
                if ((modal.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (modal.parent != shell) continue;
                return false;
            }
        }
        if (shell == null) {
            shell = this.getShell();
        }
        return shell.getEnabled();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, 0)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, 0)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        int topHandle = this.topHandle();
        this.updateLayout(topHandle);
        return OS.UIElement_IsVisible(topHandle);
    }

    void markLayout(boolean changed, boolean all) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (this.parent == null) {
            return;
        }
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        int parentHandle = this.parent.parentingHandle();
        int children = OS.Panel_Children(parentHandle);
        int index = control != null ? OS.UIElementCollection_IndexOf(children, control.topHandle()) : OS.UIElementCollection_Count(children) - 1;
        int topHandle = this.topHandle();
        if (OS.UIElementCollection_IndexOf(children, topHandle) < index) {
            OS.UIElementCollection_Remove(children, topHandle);
            OS.UIElementCollection_Insert(children, index, topHandle);
        }
        OS.GCHandle_Free(children);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (this.parent == null) {
            return;
        }
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        int parentHandle = this.parent.parentingHandle();
        int children = OS.Panel_Children(parentHandle);
        int index = control != null ? Math.max(0, OS.UIElementCollection_IndexOf(children, control.topHandle()) - 1) : (parentHandle != this.parent.handle ? 1 : 0);
        int topHandle = this.topHandle();
        if (OS.UIElementCollection_IndexOf(children, topHandle) > index) {
            OS.UIElementCollection_Remove(children, topHandle);
            OS.UIElementCollection_Insert(children, index, topHandle);
        }
        OS.GCHandle_Free(children);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean all) {
        OS.UIElement_InvalidateVisual(this.topHandle());
        OS.UIElement_InvalidateVisual(this.handle);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        this.redraw(true);
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    void releaseParent() {
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    boolean sendFocusEvent(int type) {
        Shell shell = this.getShell();
        Display display = this.display;
        display.focusControl = this;
        this.sendEvent(type);
        display.focusControl = null;
        if (!shell.isDisposed()) {
            switch (type) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
        return true;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            if (this.background != 0 && OS.Object_Equals(color.handle, this.background)) {
                return;
            }
            this.background = color.handle;
        } else {
            if (this.background == 0) {
                return;
            }
            this.background = 0;
        }
        this.setBackground();
    }

    int backgroundHandle() {
        return this.handle;
    }

    int backgroundProperty() {
        return OS.Control_BackgroundProperty();
    }

    void setBackground() {
        int backgroundHandle = this.backgroundHandle();
        int property = this.backgroundProperty();
        int brush = 0;
        if ((this.state & 0x400) == 0) {
            if (this.backgroundImage != null) {
                int imageHandle = this.backgroundImage.handle;
                brush = OS.gcnew_ImageBrush(imageHandle);
                OS.TileBrush_TileMode(brush, 4);
                OS.TileBrush_Stretch(brush, 1);
                OS.TileBrush_ViewportUnits(brush, 0);
                int rect = OS.gcnew_Rect(0.0, 0.0, OS.BitmapSource_PixelWidth(imageHandle), OS.BitmapSource_PixelHeight(imageHandle));
                OS.TileBrush_Viewport(brush, rect);
                OS.GCHandle_Free(rect);
            } else {
                int color = this.background;
                if (color == 0) {
                    Control themeControl;
                    color = this.defaultBackground();
                    if ((this.state & 0x100) != 0 && (themeControl = this.findThemeControl()) != null && color != 0) {
                        color = OS.Colors_Transparent;
                    }
                }
                if (color != 0) {
                    brush = OS.gcnew_SolidColorBrush(color);
                }
            }
        }
        if (brush != 0) {
            OS.DependencyObject_SetValue(backgroundHandle, property, brush);
            OS.GCHandle_Free(brush);
        } else {
            OS.DependencyObject_ClearValue(backgroundHandle, property);
        }
        OS.GCHandle_Free(property);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
        this.setBackground();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        int flags = 24576;
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), flags);
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        int result = 0;
        int topHandle = this.topHandle();
        if ((flags & 0x2000) != 0) {
            int oldX = (int)OS.Canvas_GetLeft(topHandle);
            int oldY = (int)OS.Canvas_GetTop(topHandle);
            if (oldX != x) {
                this.x = x;
                OS.Canvas_SetLeft(topHandle, x);
            }
            if (oldY != y) {
                this.y = y;
                OS.Canvas_SetTop(topHandle, y);
            }
            if (oldX != x || oldY != y) {
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                result |= 0x2000;
            }
        }
        if ((flags & 0x4000) != 0) {
            int oldWidth = (int)OS.FrameworkElement_Width(topHandle);
            int oldHeight = (int)OS.FrameworkElement_Height(topHandle);
            if (oldWidth != width) {
                this.width = width;
                OS.FrameworkElement_Width(topHandle, width);
            }
            if (oldHeight != height) {
                this.height = height;
                OS.FrameworkElement_Height(topHandle, height);
            }
            if (oldWidth != width || oldHeight != height) {
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return 0;
                }
                result |= 0x4000;
            }
        }
        return result;
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
        if (capture) {
            OS.UIElement_CaptureMouse(this.handle);
        } else {
            OS.UIElement_ReleaseMouseCapture(this.handle);
        }
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            SWT.error(5);
        }
        this.cursor = cursor;
        if (cursor != null) {
            OS.FrameworkElement_Cursor(this.handle, cursor.handle);
        } else {
            int property = OS.FrameworkElement_CursorProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
        this.state = dragDetect ? (this.state |= 0x8000) : (this.state &= 0xFFFF7FFF);
    }

    public void setEffect(Effect effect) {
        this.checkWidget();
        if (effect != null && effect.isDisposed()) {
            this.error(5);
        }
        if (effect != null) {
            OS.UIElement_BitmapEffect(this.handle, effect.handle);
            OS.UIElement_ClipToBounds(this.topHandle(), false);
        } else {
            OS.UIElement_BitmapEffect(this.handle, 0);
            this.setClipping();
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        if (font == null) {
            font = this.defaultFont();
        }
        this.setFont(font.handle, font.size);
    }

    void setFont(int font, double size) {
        if (font != 0) {
            int fontFamily = OS.Typeface_FontFamily(font);
            int style = OS.Typeface_Style(font);
            int weight = OS.Typeface_Weight(font);
            int stretch = OS.Typeface_Stretch(font);
            OS.Control_FontFamily(this.handle, fontFamily);
            OS.Control_FontStyle(this.handle, style);
            OS.Control_FontWeight(this.handle, weight);
            OS.Control_FontStretch(this.handle, stretch);
            OS.Control_FontSize(this.handle, size);
            OS.GCHandle_Free(fontFamily);
            OS.GCHandle_Free(style);
            OS.GCHandle_Free(weight);
            OS.GCHandle_Free(stretch);
        } else {
            int property = OS.Control_FontFamilyProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontStyleProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontWeightProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontStretchProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontSizeProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        int brush = 0;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            if (this.foreground != 0 && OS.Object_Equals(color.handle, this.foreground)) {
                return;
            }
            this.foreground = color.handle;
            brush = OS.gcnew_SolidColorBrush(this.foreground);
        } else {
            if (this.foreground == 0) {
                return;
            }
            this.foreground = 0;
        }
        this.setForegroundBrush(brush);
        if (brush != 0) {
            OS.GCHandle_Free(brush);
        }
    }

    void setForegroundBrush(int brush) {
        if (brush != 0) {
            OS.Control_Foreground(this.handle, brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        int flags = 8192;
        this.setBounds(x, y, 0, 0, flags);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
        OS.FrameworkElement_ContextMenu(this.handle, menu != null ? menu.handle : 0);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        this.redraw();
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        OS.UIElement_Clip(this.topHandle(), region.handle);
        this.region = region;
    }

    boolean setSavedFocus() {
        return this.forceFocus();
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        int flags = 16384;
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), flags);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        if (string != null && string.length() == 0) {
            string = null;
        }
        int strPtr = this.createDotNetString(string, false);
        OS.FrameworkElement_ToolTip(this.handle, strPtr);
        if (strPtr != 0) {
            OS.GCHandle_Free(strPtr);
        }
    }

    public void setTransform(Transform t) {
        this.checkWidget();
        if (t == null) {
            OS.FrameworkElement_RenderTransform(this.handle, 0);
            return;
        }
        int matrixTransform = OS.gcnew_MatrixTransform(t.handle);
        OS.FrameworkElement_RenderTransform(this.handle, matrixTransform);
        OS.GCHandle_Free(matrixTransform);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int topHandle = this.topHandle();
        if (OS.UIElement_Visibility(topHandle) == 0 == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean fixFocus = false;
        if (!visible) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        OS.UIElement_Visibility(topHandle, visible ? (byte)0 : 1);
        if (this.isDisposed()) {
            return;
        }
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void sortAscending(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] >= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        return this.display.map(null, this, x, y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        return this.display.map(this, null, x, y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(int e) {
        int code;
        int key = OS.KeyEventArgs_Key(e);
        if (key < 32) {
            return false;
        }
        int keyboardDevice = OS.KeyboardEventArgs_KeyboardDevice(e);
        int modifiers = OS.KeyboardDevice_Modifiers(keyboardDevice);
        OS.GCHandle_Free(keyboardDevice);
        if (modifiers == 0 ? ((code = this.traversalCode(key, e)) & 0x80) == 0 : (modifiers & 1) == 0) {
            return false;
        }
        Decorations shell = this.menuShell();
        if (shell.isVisible() && shell.isEnabled()) {
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, 31, e)) {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
        }
        return false;
    }

    int traversalCode(int key, int event) {
        int code = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean translateTraversal(int e) {
        int detail = 0;
        int key = OS.KeyEventArgs_Key(e);
        int code = this.traversalCode(key, e);
        boolean all = false;
        switch (key) {
            case 13: {
                all = true;
                detail = 2;
                break;
            }
            case 6: {
                all = true;
                detail = 4;
                break;
            }
            case 3: {
                int keyboardDevice = OS.KeyboardEventArgs_KeyboardDevice(e);
                int modifiers = OS.KeyboardDevice_Modifiers(keyboardDevice);
                OS.GCHandle_Free(keyboardDevice);
                boolean next = (modifiers & 4) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                boolean next = key == 26 || key == 25;
                detail = next ? 64 : 32;
                break;
            }
            case 19: 
            case 20: {
                all = true;
                int keyboardDevice = OS.KeyboardEventArgs_KeyboardDevice(e);
                int modifiers = OS.KeyboardDevice_Modifiers(keyboardDevice);
                OS.GCHandle_Free(keyboardDevice);
                if ((modifiers & 2) == 0) {
                    return false;
                }
                detail = key == 20 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        event.time = OS.InputEventArgs_Timestamp(e);
        if (!this.setKeyState(event, 31, e)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        this.checkWidget();
    }

    void updateBackgroundColor() {
    }

    void updateBackgroundImage() {
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x400;
        this.checkBackground();
        if (oldState != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void updateFont(Font oldFont, Font newFont) {
        if (this.getFont().equals(oldFont)) {
            this.setFont(newFont);
        }
    }

    void updateImages() {
    }

    void updateLayout(boolean resize, boolean all) {
    }

    int widgetParent() {
        return this.parent.handle;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        return false;
    }
}

