/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class Decorations
extends Canvas {
    int shellHandle;
    Image image;
    Image[] images;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void bringToTop() {
    }

    static int checkStyle(int style) {
        if ((style & 8) != 0) {
            style &= 0xFFFFF30F;
        }
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    void checkBorder() {
    }

    void checkOpened() {
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    int compare(ImageData data1, ImageData data2) {
        int transparent2;
        int transparent1 = data1.getTransparencyType();
        if (transparent1 == (transparent2 = data2.getTransparencyType())) {
            if (data1.depth != data2.depth) {
                return data1.depth > data2.depth ? -1 : 1;
            }
            if (data1.width * data1.height != data2.width * data2.height) {
                return data1.width * data1.height > data2.width * data2.height ? -1 : 1;
            }
        }
        if (transparent1 == 1) {
            return -1;
        }
        if (transparent2 == 1) {
            return 1;
        }
        if (transparent1 == 2) {
            return -1;
        }
        if (transparent2 == 2) {
            return 1;
        }
        if (transparent1 == 4) {
            return -1;
        }
        if (transparent2 == 4) {
            return 1;
        }
        return 0;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (!(this instanceof Shell)) {
            this.setVisible(false);
            if (!this.traverseDecorations(false)) {
                Shell shell = this.getShell();
                shell.setFocus();
            }
        }
        super.dispose();
    }

    Menu findMenu(int hMenu) {
        if (this.menus == null) {
            return null;
        }
        int i = 0;
        while (i < this.menus.length) {
            Menu menu = this.menus[i];
            if (menu != null && hMenu == menu.handle) {
                return menu;
            }
            ++i;
        }
        return null;
    }

    void fixDecorations(Decorations newDecorations, Control control, Menu[] menus) {
        if (this == newDecorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menus == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            int index = 0;
            while (index < menus.length) {
                if (menus[index] == menu) {
                    control.setMenu(null);
                    return;
                }
                ++index;
            }
            menu.fixMenus(newDecorations);
        }
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] result = new Image[this.images.length];
        System.arraycopy(this.images, 0, result, 0, this.images.length);
        return result;
    }

    public boolean getMaximized() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return false;
        }
        return OS.Window_WindowState(this.shellHandle) == 2;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return false;
        }
        return OS.Window_WindowState(this.shellHandle) == 1;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return "";
        }
        int shellHandle = this.topHandle();
        int str = OS.Window_Title(shellHandle);
        String string = Decorations.createJavaString(str);
        OS.GCHandle_Free(str);
        return string;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void releaseChildren(boolean destroy) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(destroy);
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++i;
            }
            this.menus = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        return this.savedFocus != null && this.savedFocus.setSavedFocus();
    }

    void saveFocus() {
        Control control = this.display._getFocusControl();
        if (control != null && control != this && this == control.menuShell()) {
            this.setSavedFocus(control);
        }
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean save) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (save) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (save) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        this.setImages(image, null);
    }

    void setImages(Image image, Image[] images) {
        if ((this.style & 0x4000) != 0) {
            return;
        }
        int encoder = OS.gcnew_TiffBitmapEncoder();
        int frames = OS.BitmapEncoder_Frames(encoder);
        if (image != null) {
            int frame = OS.BitmapFrame_Create(image.handle);
            OS.BitmapFrameCollection_Add(frames, frame);
            OS.GCHandle_Free(frame);
        }
        if (images != null) {
            if (images.length > 1) {
                ImageData[] datas = null;
                Image[] bestImages = new Image[images.length];
                System.arraycopy(images, 0, bestImages, 0, images.length);
                datas = new ImageData[images.length];
                int i = 0;
                while (i < datas.length) {
                    datas[i] = images[i].getImageData();
                    ++i;
                }
                images = bestImages;
                this.sort(images, datas);
            }
            int i = 0;
            while (i < images.length) {
                int frame = OS.BitmapFrame_Create(images[i].handle);
                OS.BitmapFrameCollection_Add(frames, frame);
                OS.GCHandle_Free(frame);
                ++i;
            }
        }
        OS.GCHandle_Free(frames);
        int stream = OS.gcnew_MemoryStream();
        OS.BitmapEncoder_Save(encoder, stream);
        OS.GCHandle_Free(encoder);
        int decoder = OS.BitmapDecoder_Create(stream, 0, 0);
        OS.GCHandle_Free(stream);
        frames = OS.BitmapDecoder_Frames(decoder);
        int icon = OS.BitmapFrameCollection_default(frames, 0);
        OS.GCHandle_Free(frames);
        OS.GCHandle_Free(decoder);
        OS.Window_Icon(this.shellHandle, icon);
        OS.GCHandle_Free(icon);
    }

    public void setImages(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(5);
        }
        int i = 0;
        while (i < images.length) {
            if (images[i] == null || images[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        this.images = images;
        this.setImages(null, images);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return;
        }
        int state = maximized ? 2 : 0;
        OS.Window_WindowState(this.shellHandle, state);
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        int children = OS.Panel_Children(this.scrolledHandle);
        if (this.menuBar != null) {
            OS.Menu_IsMainMenu(this.menuBar.handle, false);
            OS.UIElementCollection_Remove(children, this.menuBar.handle);
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            int menuHandle = this.menuBar.handle;
            OS.Menu_IsMainMenu(menuHandle, true);
            OS.Grid_SetRow(menuHandle, 0);
            OS.Grid_SetColumn(menuHandle, 0);
            OS.Grid_SetColumnSpan(menuHandle, 2);
            OS.UIElementCollection_Add(children, menuHandle);
        }
        OS.GCHandle_Free(children);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return;
        }
        int state = minimized ? 1 : 0;
        OS.Window_WindowState(this.shellHandle, state);
    }

    void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 0x4000) != 0) {
            return;
        }
        int strPtr = this.createDotNetString(string, false);
        int shellHandle = this.topHandle();
        OS.Window_Title(shellHandle, strPtr);
        OS.GCHandle_Free(strPtr);
    }

    void sort(Image[] images, ImageData[] datas) {
        int length = images.length;
        if (length <= 1) {
            return;
        }
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (this.compare(datas[j], datas[j + gap]) >= 0) {
                        Image swap = images[j];
                        images[j] = images[j + gap];
                        images[j + gap] = swap;
                        ImageData swapData = datas[j];
                        datas[j] = datas[j + gap];
                        datas[j + gap] = swapData;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    boolean traverseDecorations(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !(child instanceof Decorations) || !child.setFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.sendEvent(13);
        return true;
    }
}

