/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    int parentingHandle;
    String text;

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int backgroundProperty() {
        return OS.Control_BackgroundProperty();
    }

    int clientHandle() {
        return this.parentingHandle;
    }

    void createHandle() {
        this.state |= 0x100;
        this.handle = OS.gcnew_GroupBox();
        if (this.handle == 0) {
            this.error(2);
        }
        this.parentingHandle = OS.gcnew_Canvas();
        if (this.parentingHandle == 0) {
            this.error(2);
        }
        OS.ContentControl_Content(this.handle, this.parentingHandle);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        int topHandle = this.topHandle();
        int clientHandle = this.clientHandle();
        if (clientHandle != topHandle) {
            double currentWidth = OS.FrameworkElement_Width(topHandle);
            double currentHeight = OS.FrameworkElement_Height(topHandle);
            OS.FrameworkElement_Width(topHandle, 100.0);
            OS.FrameworkElement_Height(topHandle, 100.0);
            this.updateLayout(topHandle);
            int w = (int)OS.FrameworkElement_ActualWidth(topHandle);
            int h = (int)OS.FrameworkElement_ActualHeight(topHandle);
            int clientWidth = (int)OS.FrameworkElement_ActualWidth(clientHandle);
            int clientHeight = (int)OS.FrameworkElement_ActualHeight(clientHandle);
            int point = OS.gcnew_Point(0.0, 0.0);
            int result = OS.UIElement_TranslatePoint(clientHandle, point, topHandle);
            x -= (int)OS.Point_X(result);
            y -= (int)OS.Point_Y(result);
            width += w - clientWidth;
            height += h - clientHeight;
            OS.GCHandle_Free(point);
            OS.GCHandle_Free(result);
            OS.FrameworkElement_Width(topHandle, currentWidth);
            OS.FrameworkElement_Height(topHandle, currentHeight);
        }
        return new Rectangle(x, y, width, height);
    }

    int defaultBackground() {
        return OS.SystemColors_ControlColor;
    }

    void enableWidget(boolean enabled) {
        OS.UIElement_IsHitTestVisible(this.handle, enabled);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        int accessText = OS.HeaderedContentControl_Header(this.handle);
        boolean result = super.mnemonicMatch(accessText, key);
        OS.GCHandle_Free(accessText);
        return result;
    }

    void releaseHandle() {
        super.releaseHandle();
        OS.GCHandle_Free(this.parentingHandle);
        this.parentingHandle = 0;
    }

    void setForegroundBrush(int brush) {
        if (brush != 0) {
            OS.Control_Foreground(this.handle, brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        int ptr = this.createDotNetString(this.text, true);
        int accessText = OS.gcnew_AccessText();
        if (ptr != 0) {
            OS.AccessText_Text(accessText, ptr);
        }
        OS.HeaderedContentControl_Header(this.handle, accessText);
        if (ptr != 0) {
            OS.GCHandle_Free(ptr);
        }
        OS.GCHandle_Free(accessText);
    }

    int parentingHandle() {
        return this.parentingHandle;
    }
}

