/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;
    int scrolledHandle;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    int clientHandle() {
        return this.handle;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.verticalBar != null) {
            width = (int)((double)width + OS.SystemParameters_VerticalScrollBarWidth());
        }
        if (this.horizontalBar != null) {
            height = (int)((double)height + OS.SystemParameters_HorizontalScrollBarHeight());
        }
        return new Rectangle(x, y, width, height);
    }

    ScrollBar createScrollBar(int type) {
        return new ScrollBar(this, type);
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
        this.fixScrollbarVisibility();
    }

    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    int findScrollViewer(int current, int scrollViewerType) {
        int type = OS.Object_GetType(current);
        boolean found = OS.Object_Equals(scrollViewerType, type);
        OS.GCHandle_Free(type);
        if (found) {
            return current;
        }
        int childCount = OS.VisualTreeHelper_GetChildrenCount(current);
        int i = 0;
        while (i < childCount) {
            int result;
            int child = OS.VisualTreeHelper_GetChild(current, i);
            if (child != (result = this.findScrollViewer(child, scrollViewerType))) {
                OS.GCHandle_Free(child);
            }
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    void fixScrollbarVisibility() {
        if ((this.style & 0x100) == 0) {
            OS.ScrollViewer_SetHorizontalScrollBarVisibility(this.handle, 2);
        }
        if ((this.style & 0x200) == 0) {
            OS.ScrollViewer_SetVerticalScrollBarVisibility(this.handle, 2);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int clientHandle = this.clientHandle();
        int topHandle = this.topHandle();
        this.updateLayout(topHandle);
        int width = (int)OS.FrameworkElement_ActualWidth(clientHandle);
        int height = (int)OS.FrameworkElement_ActualHeight(clientHandle);
        return new Rectangle(0, 0, width, height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    int getScrollBarHandle(int style) {
        int scrollbar = 0;
        if (this.scrolledHandle != 0) {
            int children = OS.Panel_Children(this.scrolledHandle);
            int enumerator = OS.UIElementCollection_GetEnumerator(children);
            int scrollType = OS.ScrollBar_typeid();
            while (OS.IEnumerator_MoveNext(enumerator)) {
                int current = OS.IEnumerator_Current(enumerator);
                if (OS.Type_IsInstanceOfType(scrollType, current)) {
                    int orientation = OS.ScrollBar_Orientation(current);
                    if ((style & 0x100) != 0 && orientation == 0) {
                        scrollbar = current;
                        break;
                    }
                    if ((style & 0x200) != 0 && orientation == 1) {
                        scrollbar = current;
                        break;
                    }
                }
                OS.GCHandle_Free(current);
            }
            OS.GCHandle_Free(scrollType);
            OS.GCHandle_Free(enumerator);
            OS.GCHandle_Free(children);
        } else {
            this.updateLayout(this.handle);
            int scrollViewerType = OS.ScrollViewer_typeid();
            int scrollViewer = this.findScrollViewer(this.handle, scrollViewerType);
            int template = OS.Control_Template(scrollViewer);
            int part = (style & 0x100) != 0 ? this.createDotNetString("PART_HorizontalScrollBar", false) : this.createDotNetString("PART_VerticalScrollBar", false);
            scrollbar = OS.FrameworkTemplate_FindName(template, part, scrollViewer);
            OS.GCHandle_Free(part);
            OS.GCHandle_Free(template);
            OS.GCHandle_Free(scrollViewer);
            OS.GCHandle_Free(scrollViewerType);
        }
        return scrollbar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void HandlePreviewMouseWheel(int sender, int e) {
        super.HandlePreviewMouseWheel(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.state & 2) != 0 && this.verticalBar != null) {
            double value;
            int vHandle = this.verticalBar.handle;
            int delta = OS.MouseWheelEventArgs_Delta(e);
            int lines = OS.SystemParameters_WheelScrollLines();
            double newValue = value = OS.RangeBase_Value(vHandle);
            Event event = new Event();
            if (lines != -1) {
                double smallIncrement = OS.RangeBase_SmallChange(vHandle);
                newValue += smallIncrement * (double)(-delta / 120) * (double)lines;
                event.detail = delta < 0 ? 0x1000002 : 0x1000001;
            } else {
                double largeIncrement = OS.RangeBase_LargeChange(vHandle);
                newValue += largeIncrement * (double)(-delta / 120);
                event.detail = delta < 0 ? 0x1000006 : 0x1000005;
            }
            OS.RangeBase_Value(vHandle, newValue);
            newValue = OS.RangeBase_Value(vHandle);
            if (value != newValue) {
                this.verticalBar.postEvent(13, event);
            }
        }
    }

    void register() {
        super.register();
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseChildren(boolean destroy) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.scrolledHandle != 0) {
            OS.GCHandle_Free(this.scrolledHandle);
        }
        this.scrolledHandle = 0;
    }

    int topHandle() {
        return this.scrolledHandle != 0 ? this.scrolledHandle : super.topHandle();
    }
}

