/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    Image[] images;
    String[] strings;
    Color[] cellBackground;
    Color[] cellForeground;
    Font[] cellFont;
    int rowHandle;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color background;
    Color foreground;
    Font font;

    public TableItem(Table parent, int style) {
        this(parent, style, -1);
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, 0);
    }

    TableItem(Table parent, int style, int index, int handle) {
        super(parent, style);
        this.parent = parent;
        this.handle = handle;
        if (handle == 0) {
            parent.createItem(this, index);
        } else {
            this.createWidget();
        }
    }

    double computeWidth(int columnIndex) {
        int rowPresenterType = OS.GridViewRowPresenter_typeid();
        double width = 0.0;
        if (this.rowHandle != 0) {
            int contentPresenter = OS.VisualTreeHelper_GetChild(this.rowHandle, columnIndex);
            int availSize = OS.gcnew_Size(2.147483647E9, 2.147483647E9);
            OS.UIElement_Measure(contentPresenter, availSize);
            OS.GCHandle_Free(availSize);
            int size = OS.UIElement_DesiredSize(contentPresenter);
            width = OS.Size_Width(size);
            OS.GCHandle_Free(size);
            OS.GCHandle_Free(contentPresenter);
        }
        OS.GCHandle_Free(rowPresenterType);
        return width;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void columnAdded(int index) {
        Object[] temp;
        int newLength = this.parent.columnCount + 1;
        if (this.strings != null) {
            temp = new String[newLength];
            System.arraycopy(this.strings, 0, temp, 0, index);
            System.arraycopy(this.strings, index, temp, index + 1, this.parent.columnCount - index);
            this.strings = temp;
        }
        if (this.images != null) {
            temp = new Image[newLength];
            System.arraycopy(this.images, 0, temp, 0, index);
            System.arraycopy(this.images, index, temp, index + 1, this.parent.columnCount - index);
            this.images = temp;
        }
        if (this.cellBackground != null) {
            temp = new Color[newLength];
            System.arraycopy(this.cellBackground, 0, temp, 0, index);
            System.arraycopy(this.cellBackground, index, temp, index + 1, this.parent.columnCount - index);
            this.cellBackground = temp;
        }
        if (this.cellForeground != null) {
            temp = new Color[newLength];
            System.arraycopy(this.cellForeground, 0, temp, 0, index);
            System.arraycopy(this.cellForeground, index, temp, index + 1, this.parent.columnCount - index);
            this.cellForeground = temp;
        }
        if (this.cellFont != null) {
            temp = new Font[newLength];
            System.arraycopy(this.cellFont, 0, temp, 0, index);
            System.arraycopy(this.cellFont, index, temp, index + 1, this.parent.columnCount - index);
            this.cellFont = temp;
        }
    }

    void columnRemoved(int index) {
        Object[] temp;
        if (this.strings != null) {
            temp = new String[this.parent.columnCount];
            System.arraycopy(this.strings, 0, temp, 0, index);
            System.arraycopy(this.strings, index + 1, temp, index, this.parent.columnCount - index);
            this.strings = temp;
        }
        if (this.images != null) {
            temp = new Image[this.parent.columnCount];
            System.arraycopy(this.images, 0, temp, 0, index);
            System.arraycopy(this.images, index + 1, temp, index, this.parent.columnCount - index);
            this.images = temp;
        }
        if (this.cellBackground != null) {
            temp = new Color[this.parent.columnCount];
            System.arraycopy(this.cellBackground, 0, temp, 0, index);
            System.arraycopy(this.cellBackground, index + 1, temp, index, this.parent.columnCount - index);
            this.cellBackground = temp;
        }
        if (this.cellForeground != null) {
            temp = new Color[this.parent.columnCount];
            System.arraycopy(this.cellForeground, 0, temp, 0, index);
            System.arraycopy(this.cellForeground, index + 1, temp, index, this.parent.columnCount - index);
            this.cellForeground = temp;
        }
        if (this.cellFont != null) {
            temp = new Font[this.parent.columnCount];
            System.arraycopy(this.cellFont, 0, temp, 0, index);
            System.arraycopy(this.cellFont, index + 1, temp, index, this.parent.columnCount - index);
            this.cellFont = temp;
        }
    }

    void createHandle() {
        if (this.handle == 0) {
            this.handle = OS.gcnew_ListViewItem();
            if (this.handle == 0) {
                this.error(2);
            }
        }
        OS.Control_HorizontalContentAlignment(this.handle, 3);
        OS.Control_VerticalContentAlignment(this.handle, 3);
    }

    void clear() {
        int part;
        this.strings = null;
        this.images = null;
        this.grayed = false;
        this.checked = false;
        this.setFont(null);
        this.setForeground(null);
        this.setBackground(null);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
        this.updateCheck();
        int columns = this.parent.columnCount == 0 ? 1 : this.parent.columnCount;
        int i = 0;
        while (i < columns) {
            this.updateText(i);
            this.updateImage(i);
            this.updateBackground(i);
            this.updateForeground(i);
            this.updateFont(i);
            ++i;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
        if ((part = this.findPart(0, "SWT_PART_RENDERPANEL")) != 0) {
            OS.UIElement_InvalidateVisual(part);
        }
        OS.GCHandle_Free(part);
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    int findRowPresenter(int current, int rowPresenterType) {
        int type = OS.Object_GetType(current);
        boolean found = OS.Object_Equals(rowPresenterType, type);
        OS.GCHandle_Free(type);
        if (found) {
            return current;
        }
        int childCount = OS.VisualTreeHelper_GetChildrenCount(current);
        int i = 0;
        while (i < childCount) {
            int result;
            int child = OS.VisualTreeHelper_GetChild(current, i);
            if (child != (result = this.findRowPresenter(child, rowPresenterType))) {
                OS.GCHandle_Free(child);
            }
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    int findPart(int column, String partName) {
        int columnHandle;
        if (this.rowHandle == 0) {
            return 0;
        }
        this.updateLayout(this.rowHandle);
        int contentPresenter = OS.VisualTreeHelper_GetChild(this.rowHandle, column);
        if (contentPresenter == 0) {
            return 0;
        }
        if (this.parent.columnCount == 0) {
            int columns = OS.GridView_Columns(this.parent.gridViewHandle);
            columnHandle = OS.GridViewColumnCollection_default(columns, column);
            OS.GCHandle_Free(columns);
        } else {
            columnHandle = this.parent.columns[column].handle;
        }
        int cellTemplate = OS.GridViewColumn_CellTemplate(columnHandle);
        int name = this.createDotNetString(partName, false);
        int result = OS.FrameworkTemplate_FindName(cellTemplate, name, contentPresenter);
        OS.GCHandle_Free(contentPresenter);
        if (this.parent.columnCount == 0) {
            OS.GCHandle_Free(columnHandle);
        }
        OS.GCHandle_Free(cellTemplate);
        OS.GCHandle_Free(name);
        return result;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[index] == null) {
            return this.getBackground();
        }
        return this.cellBackground[index];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getTextBounds(0);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (index != 0 && !this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index >= this.parent.columnCount) {
            return new Rectangle(0, 0, 0, 0);
        }
        int rowPresenterType = OS.GridViewRowPresenter_typeid();
        int contentPresenter = OS.VisualTreeHelper_GetChild(this.rowHandle, index);
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int parentHandle = this.parent.topHandle();
        int location = OS.UIElement_TranslatePoint(contentPresenter, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        int width = (int)OS.FrameworkElement_ActualWidth(contentPresenter);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        OS.GCHandle_Free(rowPresenterType);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        OS.GCHandle_Free(contentPresenter);
        return new Rectangle(x, y, width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[index] == null) {
            return this.getForeground();
        }
        return this.cellForeground[index];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int parentHandle = this.parent.topHandle();
        int image = this.findPart(index, "SWT_PART_IMAGE");
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(image, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(image);
        int height = (int)OS.FrameworkElement_ActualHeight(image);
        OS.GCHandle_Free(image);
        return new Rectangle(x, y, width, height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return 0;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int parentHandle = this.parent.topHandle();
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int textBlock = this.findPart(index, "SWT_PART_TEXT");
        int renderPanel = this.findPart(index, "SWT_PART_RENDERPANEL");
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (textBlock != 0 && renderPanel != 0) {
            int location = OS.UIElement_TranslatePoint(textBlock, point, parentHandle);
            int x = (int)OS.Point_X(location);
            int y = (int)OS.Point_Y(location);
            OS.GCHandle_Free(location);
            double textWidth = OS.FrameworkElement_ActualWidth(textBlock);
            int panelLocation = OS.UIElement_TranslatePoint(textBlock, point, renderPanel);
            double visibleWidth = Math.max(0.0, OS.FrameworkElement_ActualWidth(renderPanel) - OS.Point_X(panelLocation));
            OS.GCHandle_Free(panelLocation);
            int width = (int)Math.min(textWidth, visibleWidth);
            int height = (int)OS.FrameworkElement_ActualHeight(textBlock);
            result = new Rectangle(x, y, width, height);
        }
        OS.GCHandle_Free(point);
        if (textBlock != 0) {
            OS.GCHandle_Free(textBlock);
        }
        if (renderPanel != 0) {
            OS.GCHandle_Free(renderPanel);
        }
        return result;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            return this.strings[index] != null ? this.strings[index] : "";
        }
        return "";
    }

    Control getWidgetControl() {
        return this.parent;
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        if (this.rowHandle != 0) {
            OS.GCHandle_Free(this.rowHandle);
        }
        this.rowHandle = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color != null) {
            int brush = OS.gcnew_SolidColorBrush(color.handle);
            OS.Control_Background(this.handle, brush);
            OS.GCHandle_Free(brush);
        } else {
            int property = OS.Control_BackgroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
        this.background = color;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new Color[count];
        }
        this.cellBackground[index] = color;
        this.updateBackground(index);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.updateCheck();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (font != null) {
            int family = OS.Typeface_FontFamily(font.handle);
            OS.Control_FontFamily(this.handle, family);
            OS.GCHandle_Free(family);
            int stretch = OS.Typeface_Stretch(font.handle);
            OS.Control_FontStretch(this.handle, stretch);
            OS.GCHandle_Free(stretch);
            int style = OS.Typeface_Style(font.handle);
            OS.Control_FontStyle(this.handle, style);
            OS.GCHandle_Free(style);
            int weight = OS.Typeface_Weight(font.handle);
            OS.Control_FontWeight(this.handle, weight);
            OS.GCHandle_Free(weight);
            OS.Control_FontSize(this.handle, font.size);
        } else {
            int property = OS.Control_FontFamilyProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontStyleProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontStretchProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontWeightProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontSizeProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
        this.font = font;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setFont(int index, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[count];
        }
        if ((oldFont = this.cellFont[index]) == font) {
            return;
        }
        this.cellFont[index] = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.updateFont(index);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color != null) {
            int brush = OS.gcnew_SolidColorBrush(color.handle);
            OS.Control_Foreground(this.handle, brush);
            OS.GCHandle_Free(brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
        this.foreground = color;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new Color[count];
        }
        this.cellForeground[index] = color;
        this.updateForeground(index);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.updateCheck();
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.images == null) {
            this.images = new Image[count];
        }
        this.images[index] = image;
        this.updateImage(index);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.strings == null) {
            this.strings = new String[count];
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.strings[index] = string;
        this.updateText(index);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void updateBackground(int index) {
        int panel = this.findPart(index, "SWT_PART_CONTENTPANEL");
        if (panel != 0) {
            if (this.cellBackground != null && this.cellBackground[index] != null) {
                int current;
                int brush = OS.gcnew_SolidColorBrush(this.cellBackground[index].handle);
                if (!OS.Object_Equals(brush, current = OS.Panel_Background(panel))) {
                    OS.Panel_Background(panel, brush);
                }
                OS.GCHandle_Free(current);
                OS.GCHandle_Free(brush);
            } else {
                int property = OS.Panel_BackgroundProperty();
                OS.DependencyObject_ClearValue(panel, property);
                OS.GCHandle_Free(property);
            }
            OS.GCHandle_Free(panel);
        }
    }

    void updateCheck() {
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int checkBox = this.findPart(0, "SWT_PART_CHECKBOX");
        if (checkBox != 0) {
            this.parent.ignoreSelection = true;
            if (!this.grayed) {
                OS.ToggleButton_IsChecked(checkBox, this.checked);
            } else if (this.checked) {
                OS.ToggleButton_IsCheckedNullSetter(checkBox);
            }
            this.parent.ignoreSelection = false;
            OS.GCHandle_Free(checkBox);
        }
    }

    void updateFont(int index) {
        int textBlock = this.findPart(index, "SWT_PART_TEXT");
        if (textBlock != 0) {
            Font font;
            Font font2 = font = this.cellFont != null ? this.cellFont[index] : null;
            if (font != null) {
                int family = OS.Typeface_FontFamily(font.handle);
                OS.TextBlock_FontFamily(textBlock, family);
                OS.GCHandle_Free(family);
                int stretch = OS.Typeface_Stretch(font.handle);
                OS.TextBlock_FontStretch(textBlock, stretch);
                OS.GCHandle_Free(stretch);
                int style = OS.Typeface_Style(font.handle);
                OS.TextBlock_FontStyle(textBlock, style);
                OS.GCHandle_Free(style);
                int weight = OS.Typeface_Weight(font.handle);
                OS.TextBlock_FontWeight(textBlock, weight);
                OS.GCHandle_Free(weight);
                OS.TextBlock_FontSize(textBlock, font.size);
            } else {
                int property = OS.TextBlock_FontFamilyProperty();
                OS.DependencyObject_ClearValue(textBlock, property);
                OS.GCHandle_Free(property);
                property = OS.TextBlock_FontSizeProperty();
                OS.DependencyObject_ClearValue(textBlock, property);
                OS.GCHandle_Free(property);
                property = OS.TextBlock_FontStretchProperty();
                OS.DependencyObject_ClearValue(textBlock, property);
                OS.GCHandle_Free(property);
                property = OS.TextBlock_FontWeightProperty();
                OS.DependencyObject_ClearValue(textBlock, property);
                OS.GCHandle_Free(property);
                property = OS.TextBlock_FontStyleProperty();
                OS.DependencyObject_ClearValue(textBlock, property);
                OS.GCHandle_Free(property);
            }
            OS.GCHandle_Free(textBlock);
        }
    }

    void updateForeground(int index) {
        int textBlock = this.findPart(index, "SWT_PART_TEXT");
        if (textBlock != 0) {
            if (this.cellForeground != null && this.cellForeground[index] != null) {
                int brush = OS.gcnew_SolidColorBrush(this.cellForeground[index].handle);
                OS.TextBlock_Foreground(textBlock, brush);
                OS.GCHandle_Free(brush);
            } else {
                int property = OS.Control_ForegroundProperty();
                OS.DependencyObject_ClearValue(textBlock, property);
                OS.GCHandle_Free(property);
            }
            OS.GCHandle_Free(textBlock);
        }
    }

    void updateImage(int index) {
        int img = this.findPart(index, "SWT_PART_IMAGE");
        if (img != 0) {
            int src = 0;
            if (this.images != null) {
                src = this.images[index] != null ? this.images[index].handle : 0;
            }
            int current = OS.Image_Source(img);
            OS.Image_Source(img, src);
            OS.GCHandle_Free(current);
            OS.GCHandle_Free(img);
        }
    }

    void updateText(int index) {
        int textBlock = this.findPart(index, "SWT_PART_TEXT");
        if (textBlock != 0) {
            if (this.strings != null && this.strings[index] != null) {
                int strPtr = this.createDotNetString(this.strings[index], false);
                OS.TextBlock_Text(textBlock, strPtr);
                OS.GCHandle_Free(strPtr);
            } else {
                int property = OS.TextBlock_TextProperty();
                OS.DependencyObject_ClearValue(textBlock, property);
                OS.GCHandle_Free(property);
            }
            OS.GCHandle_Free(textBlock);
        }
    }
}

