/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    int parentingHandle;
    int trayHandle;
    int itemCount;
    Control[] children;
    int childCount;
    static boolean IsVertical;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    static int checkStyle(int style) {
        IsVertical = (style & 0x200) != 0;
        return style & 0xFFFFFCFF;
    }

    void addChild(Control widget) {
        super.addChild(widget);
        if (this.childCount == this.children.length) {
            Control[] newChildren = new Control[this.childCount + 4];
            System.arraycopy(this.children, 0, newChildren, 0, this.childCount);
            this.children = newChildren;
        }
        this.children[this.childCount++] = widget;
    }

    int backgroundProperty() {
        return OS.Control_BackgroundProperty();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return super.computeSize(this.handle, wHint, hHint, changed);
    }

    void createHandle() {
        this.parentingHandle = OS.gcnew_Canvas();
        if (this.parentingHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gcnew_ToolBar();
        if (this.handle == 0) {
            this.error(2);
        }
        this.trayHandle = OS.gcnew_ToolBarTray();
        if (this.trayHandle == 0) {
            this.error(2);
        }
        int brush = OS.Brushes_Transparent();
        OS.ToolBarTray_Background(this.trayHandle, brush);
        OS.GCHandle_Free(brush);
        int toolbars = OS.ToolBarTray_ToolBars(this.trayHandle);
        OS.IList_Add(toolbars, this.handle);
        OS.GCHandle_Free(toolbars);
        if (IsVertical) {
            OS.ToolBarTray_Orientation(this.trayHandle, 1);
        }
        int children = OS.Panel_Children(this.parentingHandle);
        OS.UIElementCollection_Add(children, this.trayHandle);
        OS.GCHandle_Free(children);
    }

    void createItem(ToolItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        item.createWidget();
        int items = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Insert(items, index, item.topHandle());
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount == count) {
            this.error(14);
        }
        ++this.itemCount;
    }

    void createWidget() {
        super.createWidget();
        this.children = new Control[4];
        this.updateLayout(this.parentingHandle);
        this.setThumbVisibility((byte)2);
        this.setButtonVisibility((byte)2);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.parentingHandle);
    }

    int defaultBackground() {
        if ((this.style & 0x800000) != 0) {
            return OS.Colors_Transparent;
        }
        return 0;
    }

    void destroyItem(ToolItem item) {
        int items = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Remove(items, item.topHandle());
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount == count) {
            this.error(15);
        }
        --this.itemCount;
    }

    Control[] _getChildren() {
        Control[] result = new Control[this.childCount];
        int i = 0;
        while (i < this.childCount) {
            result[this.childCount - i - 1] = this.children[i];
            ++i;
        }
        return result;
    }

    ToolItem getItem(int items, int index) {
        int item = OS.ItemCollection_GetItemAt(items, index);
        ToolItem result = (ToolItem)this.display.getWidget(item);
        OS.GCHandle_Free(item);
        return result;
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        ToolItem result = this.getItem(items, index);
        OS.GCHandle_Free(items);
        return result;
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Rectangle rect = items[i].getBounds();
            if (rect.contains(point)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] result = new ToolItem[this.itemCount];
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.getItem(items, i);
            ++i;
        }
        OS.GCHandle_Free(items);
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    boolean hasItems() {
        return true;
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int index = OS.ItemCollection_IndexOf(items, item.topHandle());
        OS.GCHandle_Free(items);
        return index;
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.parentingHandle, this);
    }

    void releaseChildren(boolean destroy) {
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.getItem(items, i);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        super.releaseChildren(destroy);
    }

    void removeChild(Control control) {
        super.removeChild(control);
        int index = 0;
        while (index < this.childCount) {
            if (this.children[index] == control) break;
            ++index;
        }
        if (index == this.childCount) {
            return;
        }
        System.arraycopy(this.children, index + 1, this.children, index, --this.childCount - index);
        this.children[this.childCount] = null;
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.parentingHandle != 0) {
            OS.GCHandle_Free(this.parentingHandle);
        }
        this.parentingHandle = 0;
        if (this.trayHandle != 0) {
            OS.GCHandle_Free(this.trayHandle);
        }
        this.trayHandle = 0;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.getItem(items, i);
            if (item.control == control) {
                item.setControl(null);
                break;
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    void setButtonVisibility(byte visibility) {
        int overFlowName;
        int template = OS.Control_Template(this.handle);
        int overFlowGrid = OS.FrameworkTemplate_FindName(template, overFlowName = this.createDotNetString("OverflowGrid", false), this.handle);
        if (overFlowGrid != 0) {
            OS.UIElement_Visibility(overFlowGrid, visibility);
            OS.GCHandle_Free(overFlowGrid);
        }
        OS.GCHandle_Free(overFlowName);
        int borderName = this.createDotNetString("MainPanelBorder", false);
        int border = OS.FrameworkTemplate_FindName(template, borderName, this.handle);
        if (border != 0) {
            int left = visibility == 0 ? 11 : 0;
            int margin = OS.gcnew_Thickness(0.0, 0.0, left, 0.0);
            OS.FrameworkElement_Margin(border, margin);
            OS.GCHandle_Free(border);
            OS.GCHandle_Free(margin);
        }
        OS.GCHandle_Free(borderName);
        OS.GCHandle_Free(template);
    }

    void setForegroundBrush(int brush) {
        if (brush != 0) {
            OS.Control_Foreground(this.handle, brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    void setThumbVisibility(byte visibility) {
        int thumbName;
        int template = OS.Control_Template(this.handle);
        int thumb = OS.FrameworkTemplate_FindName(template, thumbName = this.createDotNetString("ToolBarThumb", false), this.handle);
        if (thumb != 0) {
            OS.UIElement_Visibility(thumb, visibility);
            OS.GCHandle_Free(thumb);
        }
        OS.GCHandle_Free(thumbName);
        OS.GCHandle_Free(template);
    }

    int topHandle() {
        return this.parentingHandle;
    }
}

