/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    int imageHandle;
    int textHandle;
    int arrowHandle;
    ToolBar parent;
    Control control;
    String toolTipText;
    Image disabledImage;
    Image hotImage;
    boolean ignoreSelection;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int createArrow() {
        int geometry = OS.gcnew_StreamGeometry();
        int context = OS.StreamGeometry_Open(geometry);
        int start = OS.gcnew_Point(0.0, 1.0);
        int point = OS.gcnew_Point(3.0, 4.0);
        int end = OS.gcnew_Point(6.0, 1.0);
        OS.StreamGeometryContext_BeginFigure(context, start, true, true);
        OS.StreamGeometryContext_LineTo(context, point, true, true);
        OS.StreamGeometryContext_LineTo(context, end, true, true);
        OS.StreamGeometryContext_Close(context);
        int path = OS.gcnew_Path();
        OS.Path_Data(path, geometry);
        int padding = OS.gcnew_Thickness(3.0, 0.0, 0.0, 0.0);
        OS.FrameworkElement_Margin(path, padding);
        int brush = OS.Brushes_Black();
        OS.Path_Fill(path, brush);
        OS.FrameworkElement_Width(path, 6.0);
        OS.FrameworkElement_Height(path, 6.0);
        OS.FrameworkElement_HorizontalAlignment(path, 1);
        OS.FrameworkElement_VerticalAlignment(path, 1);
        OS.GCHandle_Free(padding);
        OS.GCHandle_Free(start);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(end);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(context);
        OS.GCHandle_Free(geometry);
        return path;
    }

    void createHandle() {
        if ((this.style & 2) != 0) {
            this.handle = OS.gcnew_Separator();
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        int bits = 60;
        switch (this.style & bits) {
            case 16: {
                this.handle = OS.gcnew_RadioButton();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = OS.gcnew_CheckBox();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 4: {
                this.handle = OS.gcnew_Button();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gcnew_Button();
                if (this.handle != 0) break;
                this.error(2);
            }
        }
        OS.ToolBar_SetOverflowMode(this.handle, 2);
        this.imageHandle = OS.gcnew_Image();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.Image_Stretch(this.imageHandle, 0);
        OS.UIElement_Visibility(this.imageHandle, (byte)2);
        this.textHandle = OS.gcnew_AccessText();
        if (this.textHandle == 0) {
            this.error(2);
        }
        OS.FrameworkElement_VerticalAlignment(this.textHandle, 1);
        OS.FrameworkElement_HorizontalAlignment(this.textHandle, 1);
        int panel = OS.gcnew_StackPanel();
        if (panel == 0) {
            this.error(2);
        }
        int orientation = (this.parent.style & 0x20000) != 0 ? 0 : 1;
        OS.StackPanel_Orientation(panel, orientation);
        int thickness = OS.gcnew_Thickness(1.0, 1.0, 1.0, 1.0);
        if (thickness == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(panel, thickness);
        OS.GCHandle_Free(thickness);
        int children = OS.Panel_Children(panel);
        OS.UIElementCollection_Add(children, this.imageHandle);
        OS.UIElementCollection_Add(children, this.textHandle);
        if ((this.style & 4) != 0) {
            this.arrowHandle = this.createArrow();
            if ((this.parent.style & 0x20000) != 0) {
                OS.UIElementCollection_Add(children, this.arrowHandle);
            } else {
                int newPanel = OS.gcnew_StackPanel();
                OS.StackPanel_Orientation(newPanel, 0);
                int horizontalChildren = OS.Panel_Children(newPanel);
                OS.UIElementCollection_Add(horizontalChildren, panel);
                OS.UIElementCollection_Add(horizontalChildren, this.arrowHandle);
                OS.GCHandle_Free(horizontalChildren);
                OS.GCHandle_Free(panel);
                panel = newPanel;
            }
        }
        OS.ContentControl_Content(this.handle, panel);
        OS.GCHandle_Free(children);
        OS.GCHandle_Free(panel);
        int margin = OS.gcnew_Thickness(0.0, 0.0, 0.0, 0.0);
        OS.Control_Padding(this.handle, margin);
        OS.GCHandle_Free(margin);
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int parentHandle = this.parent.handle;
        int topHandle = this.control == null ? this.topHandle() : this.control.topHandle();
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(topHandle, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(topHandle);
        int height = (int)OS.FrameworkElement_ActualHeight(topHandle);
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.UIElement_IsEnabled(this.handle);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.ToggleButton_IsChecked(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    Control getWidgetControl() {
        return this.parent;
    }

    public int getWidth() {
        this.checkWidget();
        return (int)OS.FrameworkElement_ActualWidth(this.topHandle());
    }

    void HandleChecked(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        this.postEvent(13);
    }

    void HandleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        Event event = new Event();
        if ((this.style & 4) != 0) {
            int mousePos = OS.Mouse_GetPosition(this.handle);
            int zero = OS.gcnew_Point(0.0, OS.FrameworkElement_ActualHeight(this.topHandle()));
            int arrowPos = OS.UIElement_TranslatePoint(this.arrowHandle, zero, this.handle);
            if (OS.Point_X(mousePos) > OS.Point_X(arrowPos)) {
                event.detail = 4;
                int location = OS.UIElement_TranslatePoint(this.handle, zero, this.parent.handle);
                event.x = (int)OS.Point_X(location);
                event.y = (int)OS.Point_Y(location);
                OS.GCHandle_Free(location);
            }
            OS.GCHandle_Free(arrowPos);
            OS.GCHandle_Free(zero);
            OS.GCHandle_Free(mousePos);
        }
        this.postEvent(13, event);
    }

    void HandleUnchecked(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        this.postEvent(13);
    }

    void HandleMouseEnter(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    void HandleMouseLeave(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    void hookEvents() {
        int handler;
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x30) != 0) {
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleChecked");
            if (handler == 0) {
                this.error(2);
            }
            OS.ToggleButton_Checked(this.handle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleUnchecked");
            if (handler == 0) {
                this.error(2);
            }
            OS.ToggleButton_Unchecked(this.handle, handler);
            OS.GCHandle_Free(handler);
        } else {
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleClick");
            if (handler == 0) {
                this.error(2);
            }
            OS.ButtonBase_Click(this.handle, handler);
            OS.GCHandle_Free(handler);
        }
        handler = OS.gcnew_MouseEventHandler(this.jniRef, "HandleMouseEnter");
        if (handler == 0) {
            this.error(2);
        }
        OS.UIElement_MouseEnter(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseEventHandler(this.jniRef, "HandleMouseLeave");
        if (handler == 0) {
            this.error(2);
        }
        OS.UIElement_MouseLeave(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        if (this.imageHandle != 0) {
            OS.GCHandle_Free(this.imageHandle);
            this.imageHandle = 0;
        }
        if (this.textHandle != 0) {
            OS.GCHandle_Free(this.textHandle);
            this.textHandle = 0;
        }
        if (this.arrowHandle != 0) {
            OS.GCHandle_Free(this.arrowHandle);
            this.arrowHandle = 0;
        }
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (control == null) {
            int property = OS.Control_BackgroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            Control oldControl = this.control;
            if (oldControl != null && !oldControl.isDisposed()) {
                OS.Panel_SetZIndex(oldControl.handle, 0);
            }
        } else {
            int brush = OS.Brushes_Transparent();
            OS.Control_Background(this.handle, brush);
            OS.GCHandle_Free(brush);
            int pt = OS.gcnew_Point(0.0, 0.0);
            if (pt == 0) {
                this.error(2);
            }
            int loc = OS.UIElement_TranslatePoint(this.handle, pt, this.parent.parentingHandle);
            OS.GCHandle_Free(pt);
            OS.Canvas_SetLeft(control.handle, OS.Point_X(loc));
            OS.Canvas_SetTop(control.handle, OS.Point_Y(loc));
            OS.Panel_SetZIndex(control.handle, this.parent.childCount);
            OS.GCHandle_Free(loc);
        }
        this.control = control;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        OS.UIElement_IsEnabled(this.handle, enabled);
        this.updateImages(enabled && this.parent.getEnabled());
        if (this.arrowHandle != 0) {
            OS.UIElement_Opacity(this.arrowHandle, enabled ? 1.0 : 0.4);
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.disabledImage = image;
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.hotImage = image;
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.ignoreSelection = true;
        OS.ToggleButton_IsChecked(this.handle, selected);
        this.ignoreSelection = false;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        int strPtr = this.createDotNetString(string, true);
        if (strPtr == 0) {
            this.error(2);
        }
        OS.AccessText_Text(this.textHandle, strPtr);
        OS.GCHandle_Free(strPtr);
        OS.UIElement_Visibility(this.textHandle, (byte)(string.length() == 0 && this.image != null ? 2 : 0));
        int spacing = this.image != null && this.text.length() != 0 ? 3 : 0;
        int margin = (this.parent.style & 0x20000) != 0 ? OS.gcnew_Thickness(0.0, 0.0, spacing, 0.0) : OS.gcnew_Thickness(0.0, 0.0, 0.0, spacing);
        OS.FrameworkElement_Margin(this.imageHandle, margin);
        OS.GCHandle_Free(margin);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        if (string != null && string.length() == 0) {
            string = null;
        }
        int strPtr = this.createDotNetString(string, false);
        OS.FrameworkElement_ToolTip(this.handle, strPtr);
        if (strPtr != 0) {
            OS.GCHandle_Free(strPtr);
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        int controlHandle = this.control != null ? this.control.handle : this.handle;
        OS.FrameworkElement_Width(controlHandle, width);
    }

    void updateImages(boolean enabled) {
        int margin;
        if ((this.style & 2) != 0) {
            return;
        }
        Image next = this.image;
        if (this.image != null && !enabled && this.disabledImage != null) {
            next = this.disabledImage;
        }
        if (this.image != null && enabled && this.hotImage != null && OS.UIElement_IsMouseOver(this.handle)) {
            next = this.hotImage;
        }
        OS.Image_Source(this.imageHandle, next != null ? next.handle : 0);
        OS.UIElement_Visibility(this.imageHandle, next != null ? (byte)0 : 2);
        OS.UIElement_Visibility(this.textHandle, (byte)(next != null && this.text.length() == 0 ? 2 : 0));
        int spacing = next != null && this.text.length() != 0 ? 3 : 0;
        int n = margin = (this.parent.style & 0x20000) != 0 ? OS.gcnew_Thickness(0.0, 0.0, spacing, 0.0) : OS.gcnew_Thickness(0.0, 0.0, 0.0, spacing);
        if (margin == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(this.imageHandle, margin);
        OS.GCHandle_Free(margin);
    }
}

