/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.TreePath;

public class ChildrenUpdate
extends ViewerUpdateMonitor
implements IChildrenUpdate {
    private Object[] fElements;
    private int fIndex;
    private int fLength;

    public ChildrenUpdate(ModelContentProvider provider, Object viewerInput, TreePath elementPath, Object element, int index, IElementContentProvider elementContentProvider, IPresentationContext context) {
        super(provider, viewerInput, elementPath, element, elementContentProvider, context);
        this.fIndex = index;
        this.fLength = 1;
    }

    protected void performUpdate() {
        TreeModelContentProvider provider = (TreeModelContentProvider)this.getContentProvider();
        TreePath elementPath = this.getElementPath();
        if (this.fElements != null) {
            InternalTreeModelViewer viewer = (InternalTreeModelViewer)provider.getViewer();
            int i = 0;
            while (i < this.fElements.length) {
                int modelIndex = this.fIndex + i;
                Object element = this.fElements[i];
                if (element != null) {
                    int viewIndex = provider.modelToViewIndex(elementPath, modelIndex);
                    if (provider.shouldFilter(elementPath, element)) {
                        if (provider.addFilteredIndex(elementPath, modelIndex, element)) {
                            if (ModelContentProvider.DEBUG_CONTENT_PROVIDER) {
                                System.out.println("REMOVE(" + this.getElement() + ", modelIndex: " + modelIndex + " viewIndex: " + viewIndex + ", " + element + ")");
                            }
                            viewer.remove(elementPath, viewIndex);
                        }
                    } else {
                        if (provider.isFiltered(elementPath, modelIndex)) {
                            provider.clearFilteredChild(elementPath, modelIndex);
                            int insertIndex = provider.modelToViewIndex(elementPath, modelIndex);
                            if (ModelContentProvider.DEBUG_CONTENT_PROVIDER) {
                                System.out.println("insert(" + this.getElement() + ", modelIndex: " + modelIndex + " insertIndex: " + insertIndex + ", " + element + ")");
                            }
                            viewer.insert(elementPath, element, insertIndex);
                        } else {
                            if (ModelContentProvider.DEBUG_CONTENT_PROVIDER) {
                                System.out.println("replace(" + this.getElement() + ", modelIndex: " + modelIndex + " viewIndex: " + viewIndex + ", " + element + ")");
                            }
                            viewer.replace(elementPath, viewIndex, element);
                        }
                        TreePath childPath = elementPath.createChildPath(element);
                        provider.updateHasChildren(childPath);
                        provider.doRestore(childPath, modelIndex, false, false);
                    }
                }
                ++i;
            }
        } else {
            provider.updateHasChildren(elementPath);
        }
    }

    public void setChild(Object child, int index) {
        if (this.fElements == null) {
            this.fElements = new Object[this.fLength];
        }
        this.fElements[index - this.fIndex] = child;
    }

    public synchronized boolean coalesce(ViewerUpdateMonitor request) {
        if (request instanceof ChildrenUpdate) {
            ChildrenUpdate cu = (ChildrenUpdate)request;
            if (this.getElement().equals(cu.getElement()) && this.getElementPath().equals((Object)cu.getElementPath())) {
                int end = this.fIndex + this.fLength;
                int otherStart = cu.getOffset();
                int otherEnd = otherStart + cu.getLength();
                if (otherStart >= this.fIndex && otherStart <= end || otherEnd >= this.fIndex && otherEnd <= end) {
                    this.fIndex = Math.min(this.fIndex, otherStart);
                    end = Math.max(end, otherEnd);
                    this.fLength = end - this.fIndex;
                    if (ModelContentProvider.DEBUG_CONTENT_PROVIDER) {
                        System.out.println("coalesced: " + this.toString());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fIndex;
    }

    void startRequest() {
        this.getElementContentProvider().update(new IChildrenUpdate[]{this});
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IChildrenUpdate: ");
        buf.append(this.getElement());
        buf.append(" {");
        buf.append(this.getOffset());
        buf.append(',');
        buf.append(this.getLength());
        buf.append("}");
        return buf.toString();
    }

    int getPriority() {
        return 3;
    }

    TreePath getSchedulingPath() {
        return this.getElementPath();
    }

    void setOffset(int offset) {
        this.fIndex = offset;
    }
}

