/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.ApiAnnotations;
import org.eclipse.pde.api.tools.internal.descriptors.ElementDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApiDescription
implements IApiDescription {
    protected static final int VISIBILITY_INHERITED = 0;
    protected static final boolean DEBUG = Util.DEBUG;
    protected String fOwningComponentId = null;
    private boolean fModified = false;
    protected HashMap fPackageMap = new HashMap();

    public ApiDescription(String owningComponentId) {
        this.fOwningComponentId = owningComponentId;
    }

    public void accept(ApiDescriptionVisitor visitor) {
        this.visitChildren(visitor, this.fPackageMap);
    }

    protected void visitChildren(ApiDescriptionVisitor visitor, Map childrenMap) {
        ArrayList elements = new ArrayList(childrenMap.keySet());
        Collections.sort(elements);
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            IElementDescriptor element = (IElementDescriptor)iterator.next();
            ManifestNode node = (ManifestNode)childrenMap.get(element);
            this.visitNode(visitor, node);
        }
    }

    private void visitNode(ApiDescriptionVisitor visitor, ManifestNode node) {
        int vis = node.visibility;
        ManifestNode tmp = node;
        while (tmp != null) {
            vis = tmp.visibility;
            tmp = tmp.visibility == 0 ? tmp.parent : null;
        }
        ApiAnnotations desc = new ApiAnnotations(vis, node.restrictions);
        boolean visitChildren = visitor.visitElement(node.element, desc);
        if (visitChildren && !node.children.isEmpty()) {
            this.visitChildren(visitor, node.children);
        }
        visitor.endVisitElement(node.element, desc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ManifestNode findNode(IElementDescriptor element, boolean write) {
        IElementDescriptor[] path = element.getPath();
        HashMap map = this.fPackageMap;
        ManifestNode parentNode = null;
        ManifestNode node = null;
        int i = 0;
        while (i < path.length) {
            IElementDescriptor current = path[i];
            parentNode = node;
            node = (ManifestNode)map.get(current);
            if (node == null) {
                if (!write && !this.isInsertOnResolve(current)) return parentNode;
                node = this.createNode(parentNode, current);
                if (node == null) return null;
                map.put(current, node);
            }
            if ((node = node.refresh()) != null) {
                map = node.children;
            }
            ++i;
        }
        return node;
    }

    public IApiAnnotations resolveAnnotations(IElementDescriptor element) {
        ManifestNode node = this.findNode(element, false);
        if (node != null) {
            return this.resolveAnnotations(node, element);
        }
        return null;
    }

    protected IApiAnnotations resolveAnnotations(ManifestNode node, IElementDescriptor element) {
        ManifestNode visNode = node;
        int vis = visNode.visibility;
        while (vis == 0) {
            visNode = visNode.parent;
            vis = visNode.visibility;
        }
        int res = 0;
        if (node.element.equals(element)) {
            res = node.restrictions;
        }
        return new ApiAnnotations(vis, res);
    }

    protected void clearPackages() {
        if (this.fPackageMap != null) {
            this.fPackageMap.clear();
        }
    }

    protected ManifestNode createNode(ManifestNode parentNode, IElementDescriptor element) {
        int vis = 0;
        if (element.getElementType() == 1) {
            vis = 1;
        }
        return new ManifestNode(parentNode, element, vis, 0);
    }

    public IStatus setRestrictions(IElementDescriptor element, int restrictions) {
        ManifestNode node = this.findNode(element, true);
        if (node != null) {
            this.modified();
            node.restrictions = restrictions;
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.pde.api.tools", 100, MessageFormat.format((String)"Failed to set API restriction: {0} not found in {1}", (Object[])new String[]{element.toString(), this.fOwningComponentId}), null);
    }

    public IStatus setVisibility(IElementDescriptor element, int visibility) {
        ManifestNode node = this.findNode(element, true);
        if (node != null) {
            this.modified();
            node.visibility = visibility;
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.pde.api.tools", 100, MessageFormat.format((String)"Failed to set API visibility: {0} not found in {1}", (Object[])new String[]{element.toString(), this.fOwningComponentId}), null);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Api description for component: ").append(this.fOwningComponentId);
        return buffer.toString();
    }

    protected boolean isInsertOnResolve(IElementDescriptor elementDescriptor) {
        return false;
    }

    protected synchronized void modified() {
        this.fModified = true;
    }

    protected synchronized boolean isModified() {
        return this.fModified;
    }

    class ManifestNode
    implements Comparable {
        protected IElementDescriptor element = null;
        protected int visibility;
        protected int restrictions;
        protected ManifestNode parent = null;
        protected HashMap children = new HashMap(1);

        public ManifestNode(ManifestNode parent, IElementDescriptor element, int visibility, int restrictions) {
            this.element = element;
            this.visibility = visibility;
            this.restrictions = restrictions;
            this.parent = parent;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ManifestNode) {
                return ((ManifestNode)obj).element.equals(this.element);
            }
            return false;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public String toString() {
            String type = null;
            String name = null;
            switch (this.element.getElementType()) {
                case 5: {
                    type = "Field";
                    name = ((IMemberDescriptor)this.element).getName();
                    break;
                }
                case 6: {
                    type = "Method";
                    name = ((IMemberDescriptor)this.element).getName();
                    break;
                }
                case 1: {
                    type = "Package";
                    name = ((IPackageDescriptor)this.element).getName();
                    break;
                }
                case 2: {
                    type = "Type";
                    name = ((IMemberDescriptor)this.element).getName();
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(type == null ? "Unknown" : type).append(" Node: ").append(name == null ? "Unknown Name" : name);
            buffer.append("\nVisibility: ").append(Util.getVisibilityKind(this.visibility));
            buffer.append("\nRestrictions: ").append(Util.getRestrictionKind(this.restrictions));
            if (this.parent != null) {
                String pname = this.parent.element.getElementType() == 1 ? ((IPackageDescriptor)this.parent.element).getName() : ((IMemberDescriptor)this.parent.element).getName();
                buffer.append("\nParent: ").append(this.parent == null ? null : pname);
            }
            return buffer.toString();
        }

        public int compareTo(Object o) {
            if (o instanceof ManifestNode) {
                ManifestNode node = (ManifestNode)o;
                return ((ElementDescriptorImpl)this.element).compareTo(node.element);
            }
            return -1;
        }

        protected ManifestNode refresh() {
            return this;
        }

        void persistXML(Document document, Element parent) {
            if (this.restrictions == 0) {
                return;
            }
            switch (this.element.getElementType()) {
                case 6: {
                    IMethodDescriptor md = (IMethodDescriptor)this.element;
                    Element method = document.createElement("method");
                    method.setAttribute("name", md.getName());
                    method.setAttribute("signature", md.getSignature());
                    this.persistAnnotations(method);
                    parent.appendChild(method);
                    break;
                }
                case 5: {
                    IFieldDescriptor fd = (IFieldDescriptor)this.element;
                    Element field = document.createElement("field");
                    field.setAttribute("name", fd.getName());
                    this.persistAnnotations(field);
                    parent.appendChild(field);
                }
            }
        }

        void persistAnnotations(Element element) {
            element.setAttribute("visibility", Integer.toString(this.visibility));
            element.setAttribute("restrictions", Integer.toString(this.restrictions));
        }
    }
}

