/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.api.tools.internal.IApiXmlConstants;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApiFilterStore
implements IApiFilterStore,
IResourceChangeListener {
    private static final String GLOBAL = "!global!";
    public static final int CURRENT_STORE_VERSION = 2;
    private static boolean DEBUG = Util.DEBUG;
    private HashMap fFilterMap = null;
    private IJavaProject fProject = null;
    private boolean fNeedsSaving = false;
    private boolean fTriggeredChange = false;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public ApiFilterStore(IJavaProject project) {
        Assert.isNotNull((Object)project);
        this.fProject = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void persistApiFilters() {
        if (!this.fNeedsSaving) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (DEBUG) {
                    System.out.println("persisting api filters for plugin project component [" + ApiFilterStore.this.fProject.getElementName() + "]");
                }
                try {
                    IProject project;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    if (!(project = ApiFilterStore.this.fProject.getProject()).isAccessible()) {
                        if (DEBUG) {
                            System.out.println("project [" + ApiFilterStore.this.fProject.getElementName() + "] is not accessible, saving termainated");
                        }
                        return Status.CANCEL_STATUS;
                    }
                    String xml = ApiFilterStore.this.getStoreAsXml();
                    IFile file = project.getFile(new Path(".settings").append(".api_filters"));
                    if (xml == null) {
                        if (file.isAccessible()) {
                            IFolder folder = (IFolder)file.getParent();
                            file.delete(true, monitor);
                            if (folder.members().length == 0 && folder.isAccessible()) {
                                folder.delete(true, monitor);
                            }
                            ApiFilterStore.this.fTriggeredChange = true;
                        }
                        return Status.OK_STATUS;
                    }
                    InputStream xstream = Util.getInputStreamFromString(xml);
                    if (xstream == null) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        if (!file.exists()) {
                            IFolder folder = (IFolder)file.getParent();
                            if (!folder.exists()) {
                                folder.create(true, true, monitor);
                            }
                            file.create(xstream, true, monitor);
                        } else {
                            file.setContents(xstream, true, false, monitor);
                        }
                    }
                    finally {
                        xstream.close();
                    }
                    ApiFilterStore.this.fTriggeredChange = true;
                    ApiFilterStore.this.fNeedsSaving = false;
                }
                catch (CoreException ce) {
                    ApiPlugin.log(ce);
                }
                catch (IOException ioe) {
                    ApiPlugin.log(ioe);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public synchronized void addFilters(IApiProblemFilter[] filters) {
        if (filters == null) {
            if (DEBUG) {
                System.out.println("null filters array, not adding filters");
            }
            return;
        }
        this.initializeApiFilters();
        int i = 0;
        while (i < filters.length) {
            IResource resource;
            IApiProblem problem = filters[i].getUnderlyingProblem();
            String resourcePath = problem.getResourcePath();
            if (resourcePath != null && (resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath))) != null) {
                HashMap pTypeNames = (HashMap)this.fFilterMap.get(resource);
                String typeName = problem.getTypeName();
                if (typeName == null) {
                    typeName = GLOBAL;
                }
                HashSet<IApiProblemFilter> pfilters = null;
                if (pTypeNames == null) {
                    pTypeNames = new HashMap();
                    pfilters = new HashSet<IApiProblemFilter>();
                    pTypeNames.put(typeName, pfilters);
                    this.fFilterMap.put(resource, pTypeNames);
                } else {
                    pfilters = (HashSet<IApiProblemFilter>)pTypeNames.get(typeName);
                    if (pfilters == null) {
                        pfilters = new HashSet();
                        pTypeNames.put(typeName, pfilters);
                    }
                }
                this.fNeedsSaving |= pfilters.add(filters[i]);
            }
            ++i;
        }
        this.persistApiFilters();
    }

    public synchronized void addFilters(IApiProblem[] problems) {
        this.internalAddFilters(problems, true);
    }

    public synchronized IApiProblemFilter[] getFilters(IResource resource) {
        this.initializeApiFilters();
        Map pTypeNames = (Map)this.fFilterMap.get(resource);
        if (pTypeNames == null) {
            return new IApiProblemFilter[0];
        }
        ArrayList allFilters = new ArrayList();
        Iterator iterator = pTypeNames.values().iterator();
        while (iterator.hasNext()) {
            Set values = (Set)iterator.next();
            allFilters.addAll(values);
        }
        return allFilters.toArray(new IApiProblemFilter[allFilters.size()]);
    }

    public synchronized boolean isFiltered(IApiProblem problem) {
        this.initializeApiFilters();
        String resourcePath = problem.getResourcePath();
        if (resourcePath == null) {
            return false;
        }
        IResource resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath));
        if (resource == null) {
            return false;
        }
        IApiProblemFilter[] filters = this.getFilters(resource);
        if (filters == null) {
            if (DEBUG) {
                System.out.println("no filters defined for [" + resourcePath + "] return not filtered");
            }
            return false;
        }
        IApiProblemFilter filter = null;
        int i = 0;
        int max = filters.length;
        while (i < max) {
            filter = filters[i];
            IApiProblem underlyingProblem = filter.getUnderlyingProblem();
            if (underlyingProblem.equals(problem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        if (this.fFilterMap != null) {
            this.fFilterMap.clear();
            this.fFilterMap = null;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public synchronized IResource[] getResources() {
        this.initializeApiFilters();
        Set resources = this.fFilterMap.keySet();
        return resources.toArray(new IResource[resources.size()]);
    }

    public synchronized boolean removeFilters(IApiProblemFilter[] filters) {
        if (filters == null) {
            if (DEBUG) {
                System.out.println("null filters array, not removing");
            }
            return false;
        }
        if (this.fFilterMap == null) {
            if (DEBUG) {
                System.out.println("null filter map, not removing");
            }
            return false;
        }
        boolean success = true;
        int i = 0;
        while (i < filters.length) {
            Map pTypeNames;
            IResource resource;
            IApiProblem underlyingProblem = filters[i].getUnderlyingProblem();
            String resourcePath = underlyingProblem.getResourcePath();
            if (resourcePath != null && (resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath))) != null && (pTypeNames = (Map)this.fFilterMap.get(resource)) != null) {
                Set pfilters;
                String typeName = underlyingProblem.getTypeName();
                if (typeName == null) {
                    typeName = GLOBAL;
                }
                if ((pfilters = (Set)pTypeNames.get(typeName)) != null && pfilters.remove(filters[i])) {
                    if (DEBUG) {
                        System.out.println("removed filter: [" + filters[i] + "]");
                    }
                    this.fNeedsSaving |= true;
                    success &= true;
                    if (pfilters.isEmpty()) {
                        pTypeNames.remove(typeName);
                        if (pTypeNames.isEmpty()) {
                            success &= this.fFilterMap.remove(resource) != null;
                        }
                    }
                } else {
                    success &= false;
                }
            }
            ++i;
        }
        this.persistApiFilters();
        return success;
    }

    private String getStoreAsXml() throws CoreException {
        if (this.fFilterMap == null) {
            return null;
        }
        if (this.fFilterMap.isEmpty()) {
            return null;
        }
        Document document = Util.newDocument();
        Element root = document.createElement("component");
        document.appendChild(root);
        root.setAttribute("id", this.fProject.getElementName());
        root.setAttribute("version", IApiXmlConstants.API_FILTER_STORE_CURRENT_VERSION);
        Iterator iter = this.fFilterMap.keySet().iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            Map pTypeNames = (Map)this.fFilterMap.get(resource);
            if (pTypeNames == null) continue;
            Iterator iterator = pTypeNames.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String typeName = (String)entry.getKey();
                Set filters = (Set)entry.getValue();
                if (filters.isEmpty()) continue;
                Element relement = document.createElement("resource");
                relement.setAttribute("path", resource.getProjectRelativePath().toPortableString());
                boolean typeNameIsInitialized = false;
                if (typeName != GLOBAL) {
                    relement.setAttribute("type", typeName);
                    typeNameIsInitialized = true;
                }
                root.appendChild(relement);
                typeName = null;
                Iterator iterator2 = filters.iterator();
                while (iterator2.hasNext()) {
                    IApiProblem problem = ((IApiProblemFilter)iterator2.next()).getUnderlyingProblem();
                    typeName = problem.getTypeName();
                    Element filterElement = document.createElement("filter");
                    filterElement.setAttribute("id", Integer.toString(problem.getId()));
                    String[] messageArguments = problem.getMessageArguments();
                    int length = messageArguments.length;
                    if (length > 0) {
                        Element messageArgumentsElement = document.createElement("message_arguments");
                        int j = 0;
                        while (j < length) {
                            Element messageArgumentElement = document.createElement("message_argument");
                            messageArgumentElement.setAttribute("value", String.valueOf(messageArguments[j]));
                            messageArgumentsElement.appendChild(messageArgumentElement);
                            ++j;
                        }
                        filterElement.appendChild(messageArgumentsElement);
                    }
                    relement.appendChild(filterElement);
                }
                if (typeName == null || typeNameIsInitialized || typeName.length() == 0) continue;
                relement.setAttribute("type", typeName);
            }
        }
        return Util.serializeDocument(document);
    }

    /*
     * Unable to fully structure code
     */
    private void initializeApiFilters() {
        block37: {
            if (this.fFilterMap != null) {
                return;
            }
            if (ApiFilterStore.DEBUG) {
                System.out.println("null filter map, creating a new one");
            }
            this.fFilterMap = new HashMap<K, V>(5);
            filepath = this.getFilterFilePath();
            file = ResourcesPlugin.getWorkspace().getRoot().findMember(filepath);
            if (file == null) {
                return;
            }
            xml = null;
            contents = null;
            try {
                contents = ((IFile)file).getContents();
                xml = new String(Util.getInputStreamAsCharArray(contents, -1, "UTF-8"));
            }
            catch (CoreException v0) {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException v1) {}
                }
                break block37;
            }
            catch (IOException v2) {
                try {
                    ** if (contents == null) goto lbl-1000
                }
                catch (Throwable var5_5) {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException v4) {}
                    }
                    throw var5_5;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        contents.close();
                    }
                    catch (IOException v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block37;
                }
            }
            if (contents == null) break block37;
            try {
                contents.close();
            }
            catch (IOException v5) {}
        }
        if (xml == null) {
            return;
        }
        root = null;
        try {
            root = Util.parseDocument(xml);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
        if (!root.getNodeName().equals("component")) {
            return;
        }
        component = root.getAttribute("id");
        if (component.length() == 0) {
            return;
        }
        versionValue = root.getAttribute("version");
        currentVersion = Integer.parseInt(IApiXmlConstants.API_FILTER_STORE_CURRENT_VERSION);
        version = 0;
        if (versionValue.length() != 0) {
            try {
                version = Integer.parseInt(versionValue);
            }
            catch (NumberFormatException v6) {}
        }
        if (version != currentVersion) {
            this.fNeedsSaving = true;
            this.persistApiFilters();
            return;
        }
        resources = root.getElementsByTagName("resource");
        newfilters = new ArrayList<IApiProblem>();
        i = 0;
        while (i < resources.getLength()) {
            element = (Element)resources.item(i);
            path = element.getAttribute("path");
            if (path.length() != 0) {
                typeName = element.getAttribute("type");
                if (typeName.length() == 0) {
                    typeName = null;
                }
                if ((project = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(component)) != null && (resource = project.findMember((IPath)new Path(path))) != null) {
                    filters = element.getElementsByTagName("filter");
                    j = 0;
                    while (j < filters.getLength()) {
                        element = (Element)filters.item(j);
                        id = ApiFilterStore.loadIntegerAttribute(element, "id");
                        if (id > 0) {
                            messageargs = null;
                            elements = element.getElementsByTagName("message_arguments");
                            if (elements.getLength() == 1) {
                                messageArguments = (Element)elements.item(0);
                                arguments = messageArguments.getElementsByTagName("message_argument");
                                length = arguments.getLength();
                                messageargs = new String[length];
                                k = 0;
                                while (k < length) {
                                    messageArgument = (Element)arguments.item(k);
                                    messageargs[k] = messageArgument.getAttribute("value");
                                    ++k;
                                }
                                newfilters.add(ApiProblemFactory.newApiProblem(resource.getProjectRelativePath().toPortableString(), typeName, messageargs, null, null, -1, -1, -1, id));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.internalAddFilters(newfilters.toArray(new IApiProblem[newfilters.size()]), false);
        newfilters.clear();
    }

    private void internalAddFilters(IApiProblem[] problems, boolean persist) {
        if (problems == null) {
            if (DEBUG) {
                System.out.println("null problems array not addding filters");
            }
            return;
        }
        this.initializeApiFilters();
        Set<ApiProblemFilter> filters = null;
        int i = 0;
        while (i < problems.length) {
            IResource resource;
            IApiProblem problem = problems[i];
            ApiProblemFilter filter = new ApiProblemFilter(this.fProject.getElementName(), problem);
            String resourcePath = problem.getResourcePath();
            if (resourcePath != null && (resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath))) != null) {
                HashMap pTypeNames = (HashMap)this.fFilterMap.get(resource);
                String typeName = problem.getTypeName();
                if (typeName == null) {
                    typeName = GLOBAL;
                }
                if (pTypeNames == null) {
                    filters = new HashSet();
                    pTypeNames = new HashMap();
                    pTypeNames.put(typeName, filters);
                    this.fFilterMap.put(resource, pTypeNames);
                } else {
                    filters = (Set)pTypeNames.get(typeName);
                    if (filters == null) {
                        filters = new HashSet();
                        pTypeNames.put(typeName, filters);
                    }
                }
                this.fNeedsSaving |= filters.add(filter);
            }
            ++i;
        }
        if (persist) {
            this.persistApiFilters();
        }
    }

    private static int loadIntegerAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() == 0) {
            return -1;
        }
        try {
            int number = Integer.parseInt(value);
            return number;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private IPath getFilterFilePath() {
        IPath path = this.fProject.getPath();
        path = path.append(".settings").append(".api_filters");
        return path;
    }

    public String toString() {
        return "Api filter store for component: " + this.fProject.getElementName();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fTriggeredChange) {
            this.fTriggeredChange = false;
            return;
        }
        if (event.getType() == 1 && event.getType() == 1) {
            IFile file;
            IResource resource;
            IPath path = this.getFilterFilePath();
            IResourceDelta leafdelta = event.getDelta().findMember(path);
            if (leafdelta == null) {
                return;
            }
            boolean needsbuild = false;
            if (leafdelta.getKind() == 2) {
                if (this.fFilterMap != null) {
                    this.fFilterMap.clear();
                    needsbuild = true;
                }
            } else if ((leafdelta.getKind() == 1 || (leafdelta.getFlags() & 0x100) != 0 || (leafdelta.getFlags() & 0x40000) != 0) && (resource = leafdelta.getResource()) != null && resource.getType() == 1 && (file = (IFile)resource).isAccessible()) {
                try {
                    if (this.fFilterMap != null) {
                        this.fFilterMap.clear();
                        this.fFilterMap = null;
                    }
                    this.initializeApiFilters();
                }
                finally {
                    needsbuild = true;
                }
            }
            if (needsbuild) {
                Util.getBuildJob(new IProject[]{this.fProject.getProject()}).schedule();
            }
        }
    }
}

