/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiProfileManager;
import org.eclipse.pde.api.tools.internal.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.builder.ApiUseAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.SinceTagChecker;
import org.eclipse.pde.api.tools.internal.builder.TagValidator;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiAnalyzer;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.util.SinceTagVersion;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;

public class BaseApiAnalyzer
implements IApiAnalyzer {
    private static final String QUALIFIER = "qualifier";
    private static boolean DEBUG = Util.DEBUG;
    private ArrayList fProblems = new ArrayList(25);
    private List fPendingDeltaInfos = new ArrayList(3);
    private BuildState fBuildState = null;
    private IApiFilterStore fFilterStore = null;
    private IJavaProject fJavaProject = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public void analyzeComponent(BuildState state, IApiFilterStore filterStore, IApiProfile baseline, IApiComponent component, String[] typenames, String[] changedtypes, IProgressMonitor monitor) {
        try {
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_analyzing_api, (int)(6 + (changedtypes == null ? 0 : changedtypes.length)));
            this.fJavaProject = this.getJavaProject(component);
            if (baseline == null) {
                this.checkDefaultBaselineSet();
                this.updateMonitor((IProgressMonitor)localMonitor, 6);
                return;
            }
            IApiComponent reference = baseline.getApiComponent(component.getId());
            this.fBuildState = state;
            if (this.fBuildState == null) {
                this.fBuildState = this.getBuildState();
            }
            if (filterStore != null) {
                this.fFilterStore = filterStore;
            }
            if (reference != null) {
                localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_comparing_api_profiles, (Object)reference.getId()));
                if (changedtypes != null) {
                    int i = 0;
                    while (i < changedtypes.length) {
                        this.checkCompatibility(changedtypes[i], reference, component);
                        this.updateMonitor((IProgressMonitor)localMonitor);
                        ++i;
                    }
                } else {
                    this.checkCompatibility(reference, component);
                    this.updateMonitor((IProgressMonitor)localMonitor);
                }
            } else {
                localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_comparing_api_profiles, (Object)component.getId()));
                this.checkCompatibility(reference, component);
                this.updateMonitor((IProgressMonitor)localMonitor);
            }
            this.checkApiUsage(component, typenames, (IProgressMonitor)localMonitor.newChild(1));
            this.updateMonitor((IProgressMonitor)localMonitor);
            this.checkApiComponentVersion(reference, component);
            this.updateMonitor((IProgressMonitor)localMonitor);
            this.checkTagValidation(changedtypes, component, (IProgressMonitor)localMonitor.newChild(1));
            this.updateMonitor((IProgressMonitor)localMonitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private ReexportedBundleVersionInfo checkBundleVersionsOfReexportedBundles(IApiComponent reference, IApiComponent component) {
        IRequiredComponentDescription[] requiredComponents = component.getRequiredComponents();
        int length = requiredComponents.length;
        ReexportedBundleVersionInfo info = null;
        if (length != 0) {
            IApiProfile profile = component.getProfile();
            IApiProfile baseline = reference.getProfile();
            int i = 0;
            while (i < length) {
                IRequiredComponentDescription description = requiredComponents[i];
                if (description.isExported()) {
                    String id = description.getId();
                    IApiComponent baselineRequiredApiComponent = baseline.getApiComponent(id);
                    IApiComponent currentRequiredApiComponent = profile.getApiComponent(id);
                    if (baselineRequiredApiComponent != null && currentRequiredApiComponent != null) {
                        Version baselineRequiredVersion = new Version(baselineRequiredApiComponent.getVersion());
                        Version currentRequiredVersion = new Version(currentRequiredApiComponent.getVersion());
                        if (DEBUG) {
                            System.out.println("reexported component " + id);
                            System.out.println("\t- version in baseline profile : " + baselineRequiredVersion);
                            System.out.println("\t- version in current profile : " + currentRequiredVersion);
                        }
                        if (baselineRequiredVersion.getMajor() != currentRequiredVersion.getMajor()) {
                            return new ReexportedBundleVersionInfo(id, 5);
                        }
                        if (baselineRequiredVersion.getMinor() != currentRequiredVersion.getMinor() && info == null) {
                            info = new ReexportedBundleVersionInfo(id, 6);
                        }
                    }
                }
                ++i;
            }
        }
        return info;
    }

    private CompilationUnit createAST(ITypeRoot root, int offset) {
        if (this.fJavaProject == null) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setFocalPosition(offset);
        parser.setResolveBindings(false);
        parser.setSource(root);
        Map options = this.fJavaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    private BuildState getBuildState() {
        IProject project = null;
        if (this.fJavaProject != null) {
            project = this.fJavaProject.getProject();
        }
        if (project == null) {
            return new BuildState();
        }
        try {
            BuildState state = ApiAnalysisBuilder.getLastBuiltState(project);
            if (state != null) {
                return state;
            }
        }
        catch (CoreException coreException) {}
        return new BuildState();
    }

    private IApiSearchScope getSearchScope(IApiComponent component, String[] typenames) {
        if (typenames == null) {
            return Factory.newScope(new IApiComponent[]{component});
        }
        return Factory.newTypeScope(component, this.getScopedElements(typenames));
    }

    private IReferenceTypeDescriptor[] getScopedElements(String[] typenames) {
        ArrayList<IReferenceTypeDescriptor> types = new ArrayList<IReferenceTypeDescriptor>(typenames.length);
        int i = 0;
        while (i < typenames.length) {
            types.add(Util.getType(typenames[i]));
            ++i;
        }
        return types.toArray(new IReferenceTypeDescriptor[types.size()]);
    }

    public IApiProblem[] getProblems() {
        if (this.fProblems == null) {
            return new IApiProblem[0];
        }
        return this.fProblems.toArray(new IApiProblem[this.fProblems.size()]);
    }

    public void dispose() {
        if (this.fProblems != null) {
            this.fProblems.clear();
            this.fProblems = null;
        }
        if (this.fPendingDeltaInfos != null) {
            this.fPendingDeltaInfos.clear();
            this.fPendingDeltaInfos = null;
        }
        if (this.fBuildState != null) {
            this.fBuildState = null;
        }
    }

    private boolean ignoreApiUsageScan() {
        if (this.fJavaProject == null) {
            return false;
        }
        IProject project = this.fJavaProject.getProject();
        boolean ignore = true;
        ApiPlugin plugin = ApiPlugin.getDefault();
        ignore &= plugin.getSeverityLevel("ILLEGAL_EXTEND", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_IMPLEMENT", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_INSTANTIATE", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_REFERENCE", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_EXTEND", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_FIELD_DECL", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_IMPLEMENT", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_METHOD_PARAM", project) == 0;
        return ignore &= plugin.getSeverityLevel("LEAK_METHOD_RETURN_TYPE", project) == 0;
    }

    private boolean ignoreDefaultBaselineCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("missing_default_api_profile", this.fJavaProject.getProject().getProject()) == 0;
    }

    private boolean ignoreSinceTagCheck(String pref) {
        if (this.fJavaProject == null) {
            return true;
        }
        IProject project = this.fJavaProject.getProject();
        ApiPlugin plugin = ApiPlugin.getDefault();
        if (pref == null) {
            boolean ignore = plugin.getSeverityLevel("malformed_since_tag", project) == 0;
            ignore &= plugin.getSeverityLevel("invalid_since_tag_version", project) == 0;
            return ignore &= plugin.getSeverityLevel("missing_since_tag", project) == 0;
        }
        return plugin.getSeverityLevel(pref, project) == 0;
    }

    private boolean ignoreComponentVersionCheck() {
        if (this.fJavaProject == null) {
            return false;
        }
        return ApiPlugin.getDefault().getSeverityLevel("incompatible_api_component_version", this.fJavaProject.getProject().getProject()) == 0;
    }

    private boolean ignoreMinorVersionCheckWithoutApiChange() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getEnableState("incompatible_api_component_version_include_minor_without_api_change", this.fJavaProject.getProject().getProject()).equals("Disabled");
    }

    private boolean ignoreMajorVersionCheckWithoutBreakingChange() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getEnableState("incompatible_api_component_version_include_major_without_breaking_change", this.fJavaProject.getProject().getProject()).equals("Disabled");
    }

    private boolean ignoreInvalidTagCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("INVALID_JAVADOC_TAG", this.fJavaProject.getProject()) == 0;
    }

    private void checkTagValidation(String[] typenames, IApiComponent component, IProgressMonitor monitor) {
        if (this.ignoreInvalidTagCheck()) {
            return;
        }
        try {
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_validating_javadoc_tags, (int)(1 + (typenames == null ? component.getClassFileContainers().length : typenames.length)));
            if (typenames == null) {
                try {
                    IPackageFragmentRoot[] roots = this.fJavaProject.getPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        if (roots[i].getKind() == 1) {
                            localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_scanning_0, (Object)roots[i].getPath().toOSString()));
                            this.scanSource((IJavaElement)roots[i], (IProgressMonitor)localMonitor.newChild(1));
                            this.updateMonitor((IProgressMonitor)localMonitor);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException jme) {
                    ApiPlugin.log(jme);
                }
            } else {
                int i = 0;
                while (i < typenames.length) {
                    localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_scanning_0, (Object)typenames[i]));
                    this.processType(typenames[i]);
                    this.updateMonitor((IProgressMonitor)localMonitor);
                    ++i;
                }
            }
            this.updateMonitor((IProgressMonitor)localMonitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void scanSource(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        try {
            switch (element.getElementType()) {
                case 3: 
                case 4: {
                    IParent parent = (IParent)element;
                    IJavaElement[] children = parent.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.scanSource(children[i], monitor);
                        this.updateMonitor(monitor, 0);
                        ++i;
                    }
                    break;
                }
                case 5: {
                    ICompilationUnit unit = (ICompilationUnit)element;
                    this.processType(unit);
                    this.updateMonitor(monitor, 0);
                }
            }
        }
        finally {
            if (monitor != null) {
                this.updateMonitor(monitor);
                monitor.done();
            }
        }
    }

    private void processType(String typename) {
        try {
            ICompilationUnit cunit;
            IType type = this.fJavaProject.findType(typename);
            if (type != null && (cunit = type.getCompilationUnit()) != null) {
                this.processType(cunit);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void processType(ICompilationUnit cunit) {
        TagValidator tv = new TagValidator(cunit);
        CompilationUnit comp = this.createAST((ITypeRoot)cunit, 0);
        if (comp == null) {
            return;
        }
        comp.accept((ASTVisitor)tv);
        IApiProblem[] tagProblems = tv.getTagProblems();
        int i = 0;
        while (i < tagProblems.length) {
            this.addProblem(tagProblems[i]);
            ++i;
        }
    }

    private void checkApiUsage(IApiComponent component, String[] typenames, IProgressMonitor monitor) {
        if (this.ignoreApiUsageScan()) {
            if (DEBUG) {
                System.out.println("Ignoring API usage scan");
            }
            return;
        }
        IApiSearchScope scope = this.getSearchScope(component, typenames);
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)BuilderMessages.checking_api_usage, (Object[])new String[]{component.getId()}), (int)2);
        ApiUseAnalyzer analyzer = new ApiUseAnalyzer();
        try {
            try {
                long start = System.currentTimeMillis();
                IApiProblem[] illegal = analyzer.findIllegalApiUse(component, scope, monitor);
                this.updateMonitor((IProgressMonitor)localMonitor);
                long end = System.currentTimeMillis();
                if (DEBUG) {
                    System.out.println("API usage scan: " + (end - start) + " ms\t" + illegal.length + " problems");
                }
                int i = 0;
                while (i < illegal.length) {
                    this.addProblem(illegal[i]);
                    ++i;
                }
                this.updateMonitor((IProgressMonitor)localMonitor);
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void checkCompatibility(String typeName, IApiComponent reference, IApiComponent component) {
        IDelta delta;
        block18: {
            if (DEBUG) {
                System.out.println("comparing profiles [" + reference.getId() + "] and [" + component.getId() + "] for type [" + typeName + "]");
            }
            IClassFile classFile = null;
            try {
                classFile = component.findClassFile(typeName);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
            if (classFile == null) {
                if (DEBUG) {
                    System.err.println("Could not retrieve class file for " + typeName + " in " + component.getId());
                }
                return;
            }
            this.fBuildState.cleanup(typeName);
            delta = null;
            long time = System.currentTimeMillis();
            try {
                try {
                    delta = ApiComparator.compare(classFile, reference, component, reference.getProfile(), component.getProfile(), 1);
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    if (DEBUG) {
                        System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                    }
                    this.fPendingDeltaInfos.clear();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                }
                this.fPendingDeltaInfos.clear();
                throw throwable;
            }
            if (DEBUG) {
                System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
            }
            this.fPendingDeltaInfos.clear();
        }
        if (delta == null) {
            return;
        }
        if (delta != ApiComparator.NO_DELTA) {
            List allDeltas = Util.collectAllDeltas(delta);
            Iterator iterator = allDeltas.iterator();
            while (iterator.hasNext()) {
                this.processDelta((IDelta)iterator.next(), reference, component);
            }
            if (!this.fPendingDeltaInfos.isEmpty()) {
                iterator = this.fPendingDeltaInfos.iterator();
                while (iterator.hasNext()) {
                    this.checkSinceTags((Delta)iterator.next(), component);
                }
            }
        }
    }

    private void checkCompatibility(IApiComponent reference, IApiComponent component) {
        List allDeltas;
        IDelta delta;
        block15: {
            long time = System.currentTimeMillis();
            delta = null;
            if (reference == null) {
                delta = new Delta(null, 3, 1, 3, null, component.getId(), component.getId());
            } else {
                try {
                    try {
                        delta = ApiComparator.compare(reference, component, 1);
                    }
                    catch (Exception e) {
                        ApiPlugin.log(e);
                        if (DEBUG) {
                            System.out.println("Time spent for " + component.getId() + " : " + (System.currentTimeMillis() - time) + "ms");
                        }
                        this.fPendingDeltaInfos.clear();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (DEBUG) {
                        System.out.println("Time spent for " + component.getId() + " : " + (System.currentTimeMillis() - time) + "ms");
                    }
                    this.fPendingDeltaInfos.clear();
                    throw throwable;
                }
                if (DEBUG) {
                    System.out.println("Time spent for " + component.getId() + " : " + (System.currentTimeMillis() - time) + "ms");
                }
                this.fPendingDeltaInfos.clear();
            }
        }
        if (delta == null) {
            return;
        }
        if (delta != ApiComparator.NO_DELTA && (allDeltas = Util.collectAllDeltas(delta)).size() != 0) {
            Iterator iterator = allDeltas.iterator();
            while (iterator.hasNext()) {
                this.processDelta((IDelta)iterator.next(), reference, component);
            }
            if (!this.fPendingDeltaInfos.isEmpty()) {
                iterator = this.fPendingDeltaInfos.iterator();
                while (iterator.hasNext()) {
                    this.checkSinceTags((Delta)iterator.next(), component);
                }
            }
        }
    }

    private void checkSinceTags(Delta delta, IApiComponent component) {
        if (this.ignoreSinceTagCheck(null)) {
            return;
        }
        IMember member = Util.getIMember(delta, this.fJavaProject);
        if (member == null || member.isBinary()) {
            return;
        }
        ICompilationUnit cunit = member.getCompilationUnit();
        if (cunit == null) {
            return;
        }
        try {
            if (!cunit.isConsistent()) {
                cunit.makeConsistent(null);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        IApiProblem problem = null;
        ISourceRange nameRange = null;
        try {
            nameRange = member.getNameRange();
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
            return;
        }
        if (nameRange == null) {
            return;
        }
        try {
            int offset = nameRange.getOffset();
            CompilationUnit comp = this.createAST((ITypeRoot)cunit, offset);
            if (comp == null) {
                return;
            }
            SinceTagChecker visitor = new SinceTagChecker(offset);
            comp.accept((ASTVisitor)visitor);
            String componentVersionString = component.getVersion();
            try {
                String sinceVersion;
                if (visitor.hasNoComment() || visitor.isMissing()) {
                    if (this.ignoreSinceTagCheck("missing_since_tag")) {
                        if (DEBUG) {
                            System.out.println("Ignoring missing since tag problem");
                        }
                        return;
                    }
                    StringBuffer buffer = new StringBuffer();
                    Version componentVersion = new Version(componentVersionString);
                    buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                    problem = this.createSinceTagProblem(3, new String[]{Util.getDeltaArgumentString(delta)}, delta, member, String.valueOf(buffer));
                } else if (visitor.hasJavadocComment() && (sinceVersion = visitor.getSinceVersion()) != null) {
                    SinceTagVersion tagVersion = new SinceTagVersion(sinceVersion);
                    String postfixString = tagVersion.postfixString();
                    if (tagVersion.getVersion() == null || Util.getFragmentNumber(tagVersion.getVersionString()) > 2) {
                        if (this.ignoreSinceTagCheck("malformed_since_tag")) {
                            if (DEBUG) {
                                System.out.println("Ignoring malformed since tag problem");
                            }
                            return;
                        }
                        StringBuffer buffer = new StringBuffer();
                        if (tagVersion.prefixString() != null) {
                            buffer.append(tagVersion.prefixString());
                        }
                        Version componentVersion = new Version(componentVersionString);
                        buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                        if (postfixString != null) {
                            if (!Character.isWhitespace(postfixString.charAt(0))) {
                                buffer.append(' ');
                            }
                            buffer.append(postfixString);
                        }
                        problem = this.createSinceTagProblem(2, new String[]{sinceVersion, Util.getDeltaArgumentString(delta)}, delta, member, String.valueOf(buffer));
                    } else {
                        if (this.ignoreSinceTagCheck("invalid_since_tag_version")) {
                            if (DEBUG) {
                                System.out.println("Ignoring invalid tag version problem");
                            }
                            return;
                        }
                        StringBuffer accurateVersionBuffer = new StringBuffer();
                        Version componentVersion = new Version(componentVersionString);
                        accurateVersionBuffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                        String accurateVersion = String.valueOf(accurateVersionBuffer);
                        if (Util.isDifferentVersion(sinceVersion, accurateVersion)) {
                            StringBuffer buffer = new StringBuffer();
                            if (tagVersion.prefixString() != null) {
                                buffer.append(tagVersion.prefixString());
                            }
                            Version version = new Version(accurateVersion);
                            buffer.append(version.getMajor()).append('.').append(version.getMinor());
                            if (postfixString != null) {
                                if (!Character.isWhitespace(postfixString.charAt(0))) {
                                    buffer.append(' ');
                                }
                                buffer.append(postfixString);
                            }
                            String accurateSinceTagValue = String.valueOf(buffer);
                            problem = this.createSinceTagProblem(1, new String[]{sinceVersion, accurateSinceTagValue, Util.getDeltaArgumentString(delta)}, delta, member, accurateSinceTagValue);
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ApiPlugin.log(e);
            }
        }
        catch (RuntimeException e) {
            ApiPlugin.log(e);
        }
        if (problem != null) {
            this.addProblem(problem);
        }
    }

    private IApiProblem createSinceTagProblem(int kind, String[] messageargs, Delta info, IMember member, String version) {
        ICompilationUnit unit;
        IResource resource;
        block8: {
            try {
                resource = null;
                unit = null;
                try {
                    unit = member.getCompilationUnit();
                    if (unit != null) {
                        resource = unit.getCorrespondingResource();
                    }
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                if (resource != null) break block8;
                return null;
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                return null;
            }
        }
        int lineNumber = 1;
        int charStart = 0;
        int charEnd = 1;
        ISourceRange range = member.getNameRange();
        charStart = range.getOffset();
        charEnd = charStart + range.getLength();
        try {
            IDocument document = Util.getDocument(unit);
            lineNumber = document.getLineOfOffset(charStart);
        }
        catch (BadLocationException e) {
            ApiPlugin.log(e);
        }
        String qtn = null;
        qtn = member instanceof IType ? ((IType)member).getFullyQualifiedName() : member.getDeclaringType().getFullyQualifiedName();
        return ApiProblemFactory.newApiSinceTagProblem(resource.getProjectRelativePath().toPortableString(), qtn, messageargs, new String[]{"version", "apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{version, new Integer(5), member.getHandleIdentifier()}, lineNumber, charStart, charEnd, info.getElementType(), kind);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IApiProblem createCompatibilityProblem(IDelta delta, IApiComponent reference, IApiComponent component) {
        try {
            Version referenceVersion = new Version(reference.getVersion());
            Version componentVersion = new Version(component.getVersion());
            if (referenceVersion.getMajor() < componentVersion.getMajor()) {
                this.fBuildState.addBreakingChange(delta);
                return null;
            }
            IResource resource = null;
            IType type = null;
            int lineNumber = 1;
            int charStart = -1;
            int charEnd = 1;
            IMember member = null;
            if (this.fJavaProject != null) {
                try {
                    type = this.fJavaProject.findType(delta.getTypeName().replace('$', '.'));
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                if (type == null) {
                    IResource manifestFile = Util.getManifestFile(this.fJavaProject.getProject());
                    if (manifestFile == null) {
                        return null;
                    }
                    resource = manifestFile;
                } else {
                    ICompilationUnit unit = type.getCompilationUnit();
                    if (unit != null) {
                        resource = unit.getCorrespondingResource();
                        if (resource == null) {
                            return null;
                        }
                    } else {
                        IResource manifestFile = Util.getManifestFile(this.fJavaProject.getProject());
                        if (manifestFile == null) {
                            return null;
                        }
                        resource = manifestFile;
                    }
                }
                member = Util.getIMember(delta, this.fJavaProject);
                if (member != null && !member.isBinary()) {
                    ISourceRange range = member.getNameRange();
                    charStart = range.getOffset();
                    charEnd = charStart + range.getLength();
                    try {
                        IDocument document = Util.getDocument(member.getCompilationUnit());
                        lineNumber = document.getLineOfOffset(charStart);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            String path = null;
            if (resource != null) {
                path = resource.getProjectRelativePath().toPortableString();
            }
            return ApiProblemFactory.newApiProblem(path, delta.getTypeName(), delta.getArguments(), new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, new Object[]{member == null ? null : member.getHandleIdentifier(), new Integer(2)}, lineNumber, charStart, charEnd, 0x10000000, delta.getElementType(), delta.getKind(), delta.getFlags());
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    private void processDelta(IDelta delta, IApiComponent reference, IApiComponent component) {
        block22: {
            int kind;
            int flags;
            block21: {
                int modifiers;
                flags = delta.getFlags();
                kind = delta.getKind();
                if (!DeltaProcessor.isCompatible(delta)) break block21;
                if (this.isNewAPI(delta)) {
                    this.fBuildState.addCompatibleChange(delta);
                }
                if (!Util.isPublic(modifiers = delta.getModifiers()) && (!Util.isProtected(modifiers) || RestrictionModifiers.isExtendRestriction(delta.getRestrictions()))) break block22;
                switch (kind) {
                    case 1: {
                        switch (flags) {
                            case 8: 
                            case 12: 
                            case 16: 
                            case 25: 
                            case 27: 
                            case 28: 
                            case 46: 
                            case 48: {
                                if (DEBUG) {
                                    String deltaDetails = "Delta : " + Util.getDetail(delta);
                                    System.out.println(String.valueOf(deltaDetails) + " is compatible");
                                }
                                this.fPendingDeltaInfos.add(delta);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (flags != 22) break block22;
                        if (DEBUG) {
                            String deltaDetails = "Delta : " + Util.getDetail(delta);
                            System.out.println(String.valueOf(deltaDetails) + " is compatible");
                        }
                        this.fPendingDeltaInfos.add(delta);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block22;
            }
            switch (kind) {
                case 1: {
                    switch (flags) {
                        case 8: 
                        case 12: 
                        case 16: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 48: {
                            if (!Util.isVisible(delta)) break;
                            if (DEBUG) {
                                String deltaDetails = "Delta : " + Util.getDetail(delta);
                                System.err.println(String.valueOf(deltaDetails) + " is not compatible");
                            }
                            this.fPendingDeltaInfos.add(delta);
                        }
                    }
                    break;
                }
                case 2: {
                    if (flags != 37) break;
                    return;
                }
            }
            IApiProblem problem = this.createCompatibilityProblem(delta, reference, component);
            if (this.addProblem(problem)) {
                this.fBuildState.addBreakingChange(delta);
            }
        }
    }

    private boolean isNewAPI(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 7: 
                    case 13: 
                    case 36: {
                        return false;
                    }
                    case 5: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 39: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 51: 
                    case 53: {
                        return Util.isVisible(delta);
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 29: 
                    case 32: 
                    case 34: 
                    case 35: 
                    case 40: 
                    case 45: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: {
                        return false;
                    }
                }
                switch (delta.getElementType()) {
                    case 5: 
                    case 7: 
                    case 10: {
                        return Util.isVisible(delta);
                    }
                }
                switch (delta.getFlags()) {
                    case 14: 
                    case 15: 
                    case 22: {
                        return Util.isVisible(delta);
                    }
                }
                return false;
            }
            default: {
                switch (delta.getFlags()) {
                    case 7: 
                    case 13: {
                        return false;
                    }
                    case 5: 
                    case 17: 
                    case 26: 
                    case 53: {
                        return Util.isVisible(delta);
                    }
                }
            }
        }
        return false;
    }

    private void checkApiComponentVersion(IApiComponent reference, IApiComponent component) {
        IApiProblem problem;
        block42: {
            ReexportedBundleVersionInfo info;
            Version newversion;
            Version compversion;
            Version refversion;
            String compversionval;
            block43: {
                String refversionval;
                block41: {
                    IDelta[] breakingChanges;
                    if (this.ignoreComponentVersionCheck() || reference == null || component == null) {
                        if (DEBUG) {
                            System.out.println("Ignoring component version check");
                        }
                        return;
                    }
                    problem = null;
                    refversionval = reference.getVersion();
                    compversionval = component.getVersion();
                    refversion = new Version(refversionval);
                    compversion = new Version(compversionval);
                    newversion = null;
                    if (DEBUG) {
                        System.out.println("reference version of " + reference.getId() + " : " + refversion);
                        System.out.println("component version of " + component.getId() + " : " + compversion);
                    }
                    if ((breakingChanges = this.fBuildState.getBreakingChanges()).length == 0) break block41;
                    if (compversion.getMajor() <= refversion.getMajor()) {
                        newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(1, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(breakingChanges));
                    }
                    break block42;
                }
                IDelta[] compatibleChanges = this.fBuildState.getCompatibleChanges();
                if (compatibleChanges.length != 0) {
                    if (compversion.getMajor() != refversion.getMajor()) {
                        if (!this.ignoreMajorVersionCheckWithoutBreakingChange()) {
                            newversion = new Version(refversion.getMajor(), refversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                            problem = this.createVersionProblem(3, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(compatibleChanges));
                        }
                    } else if (compversion.getMinor() <= refversion.getMinor()) {
                        newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(2, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(compatibleChanges));
                    }
                } else if (compversion.getMajor() != refversion.getMajor()) {
                    if (!this.ignoreMajorVersionCheckWithoutBreakingChange()) {
                        newversion = new Version(refversion.getMajor(), refversion.getMinor(), refversion.getMicro(), refversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(3, new String[]{compversionval, refversionval}, String.valueOf(newversion), "");
                    }
                } else if (compversion.getMinor() > refversion.getMinor() && !this.ignoreMinorVersionCheckWithoutApiChange()) {
                    newversion = new Version(refversion.getMajor(), refversion.getMinor(), refversion.getMicro(), refversion.getQualifier() != null ? QUALIFIER : null);
                    problem = this.createVersionProblem(4, new String[]{compversionval, refversionval}, String.valueOf(newversion), "");
                }
                info = null;
                if (problem == null) break block43;
                block0 : switch (problem.getKind()) {
                    case 3: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info != null) {
                            switch (info.kind) {
                                case 5: {
                                    problem = null;
                                    break block0;
                                }
                                case 6: {
                                    newversion = new Version(refversion.getMajor(), refversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                                    problem = this.createVersionProblem(5, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                                }
                            }
                            break;
                        }
                        break block42;
                    }
                    case 2: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info != null) {
                            switch (info.kind) {
                                case 5: {
                                    newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                                    problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                                }
                            }
                            break;
                        }
                        break block42;
                    }
                    case 4: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info == null) break block42;
                        switch (info.kind) {
                            case 5: {
                                newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                                problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                                break block0;
                            }
                            case 6: {
                                problem = null;
                            }
                        }
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block42;
            }
            info = this.checkBundleVersionsOfReexportedBundles(reference, component);
            if (info != null) {
                switch (info.kind) {
                    case 5: {
                        if (compversion.getMajor() > refversion.getMajor()) break;
                        newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                        break;
                    }
                    case 6: {
                        if (compversion.getMinor() > refversion.getMinor()) break;
                        newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier());
                        problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                    }
                }
            }
        }
        if (problem != null) {
            this.addProblem(problem);
        }
    }

    private String collectDetails(IDelta[] deltas) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        int i = 0;
        int max = deltas.length;
        while (i < max) {
            printWriter.print("- ");
            printWriter.println(deltas[i].getMessage());
            ++i;
        }
        printWriter.flush();
        printWriter.close();
        return String.valueOf(writer.getBuffer());
    }

    private IApiProblem createVersionProblem(int kind, String[] messageargs, String version, String description) {
        int charEnd;
        int charStart;
        int lineNumber;
        String path;
        block35: {
            char[] contents;
            block34: {
                IResource manifestFile = null;
                path = "META-INF/MANIFEST.MF";
                if (this.fJavaProject != null) {
                    manifestFile = Util.getManifestFile(this.fJavaProject.getProject());
                }
                lineNumber = -1;
                charStart = 0;
                charEnd = 1;
                contents = null;
                if (manifestFile != null && manifestFile.getType() == 1) {
                    path = manifestFile.getProjectRelativePath().toPortableString();
                    IFile file = (IFile)manifestFile;
                    InputStream inputStream = null;
                    BufferedReader reader = null;
                    try {
                        inputStream = file.getContents(true);
                        contents = Util.getInputStreamAsCharArray(inputStream, -1, "UTF-8");
                        reader = new LineNumberReader(new BufferedReader(new StringReader(new String(contents))));
                        int lineCounter = 0;
                        String line = null;
                        while ((line = ((LineNumberReader)reader).readLine()) != null) {
                            ++lineCounter;
                            if (!line.startsWith("Bundle-Version")) continue;
                            lineNumber = lineCounter;
                            break;
                        }
                    }
                    catch (CoreException coreException) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                            break block34;
                        }
                        catch (IOException iOException) {}
                        break block34;
                    }
                    catch (IOException iOException) {
                        try {}
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                            catch (IOException iOException2) {}
                            throw throwable;
                        }
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                            break block34;
                        }
                        catch (IOException iOException3) {}
                        break block34;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (lineNumber != -1 && contents != null) {
                int index = CharOperation.indexOf((char[])"Bundle-Version".toCharArray(), (char[])contents, (boolean)true);
                int i = index + "Bundle-Version".length() + 1;
                int max = contents.length;
                while (i < max) {
                    char currentCharacter = contents[i];
                    if (!CharOperation.isWhitespace((char)currentCharacter)) {
                        charStart = i;
                        break;
                    }
                    ++i;
                }
                i = charStart + 1;
                max = contents.length;
                while (i < max) {
                    switch (contents[i]) {
                        case '\n': 
                        case '\r': {
                            charEnd = i;
                            break block35;
                        }
                        default: {
                            ++i;
                        }
                    }
                }
            } else {
                lineNumber = 1;
            }
        }
        return ApiProblemFactory.newApiVersionNumberProblem(path, null, messageargs, new String[]{"version", "apiMarkerID", "description"}, new Object[]{version, new Integer(4), description}, lineNumber, charStart, charEnd, 7, kind);
    }

    private void checkDefaultBaselineSet() {
        if (this.ignoreDefaultBaselineCheck()) {
            if (DEBUG) {
                System.out.println("Ignoring check for default API baseline");
            }
            return;
        }
        if (DEBUG) {
            System.out.println("Checking if the default api baseline is set");
        }
        IApiProblem problem = ApiProblemFactory.newApiProfileProblem(Path.EMPTY.toPortableString(), null, null, new String[]{"apiMarkerID"}, new Object[]{new Integer(1)}, -1, -1, -1, 7, 1);
        this.addProblem(problem);
    }

    private void updateMonitor(IProgressMonitor monitor) throws OperationCanceledException {
        this.updateMonitor(monitor, 1);
    }

    private void updateMonitor(IProgressMonitor monitor, int work) throws OperationCanceledException {
        if (monitor != null) {
            monitor.worked(work);
            monitor.setTaskName("");
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    private IJavaProject getJavaProject(IApiComponent component) {
        if (component instanceof PluginProjectApiComponent) {
            PluginProjectApiComponent pp = (PluginProjectApiComponent)component;
            return pp.getJavaProject();
        }
        return null;
    }

    private boolean addProblem(IApiProblem problem) {
        if (problem == null || this.isProblemFiltered(problem)) {
            return false;
        }
        return this.fProblems.add(problem);
    }

    private boolean isProblemFiltered(IApiProblem problem) {
        if (this.fJavaProject == null) {
            if (this.fFilterStore != null) {
                return this.fFilterStore.isFiltered(problem);
            }
            return false;
        }
        IProject project = this.fJavaProject.getProject();
        if (ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(problem), project) == 0) {
            return true;
        }
        ApiProfileManager manager = ApiProfileManager.getManager();
        IApiProfile profile = manager.getWorkspaceProfile();
        if (profile == null) {
            return false;
        }
        IApiComponent component = profile.getApiComponent(project.getName());
        if (component != null) {
            try {
                IApiFilterStore filterStore = component.getFilterStore();
                if (filterStore != null) {
                    return filterStore.isFiltered(problem);
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private static class ReexportedBundleVersionInfo {
        String componentID;
        int kind;

        ReexportedBundleVersionInfo(String componentID, int kind) {
            this.componentID = componentID;
            this.kind = kind;
        }
    }
}

