/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.pde.api.tools.internal.comparator.FieldDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.MethodDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.TypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.TraceAnnotationVisitor;

class ClassFileDescriptorBuilder
extends ClassAdapter {
    TypeDescriptor descriptor;

    ClassFileDescriptorBuilder(ClassVisitor cv, TypeDescriptor descriptor) {
        super(cv);
        this.descriptor = descriptor;
    }

    private void addDescriptor(Map map, String name, Object descriptor) {
        Object object = map.get(name);
        if (object != null) {
            if (object instanceof List) {
                ((List)object).add(descriptor);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(object);
                list.add(descriptor);
                map.put(name, list);
            }
        } else {
            map.put(name, descriptor);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.descriptor.initialize(version, access, name, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String currentOuterName;
        super.visitInnerClass(name, outerName, innerName, access);
        String currentName = name.replace('/', '.');
        if (currentName.equals(this.descriptor.name)) {
            this.descriptor.access = access;
            if (outerName == null) {
                if (innerName == null) {
                    this.descriptor.setAnonymous();
                } else {
                    this.descriptor.setLocal();
                }
            } else {
                this.descriptor.setMember();
            }
        } else if (outerName != null && innerName != null && (currentOuterName = outerName.replace('/', '.')).equals(this.descriptor.name)) {
            this.descriptor.addTypeMember(currentName, access);
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldDescriptor fieldDescriptor = new FieldDescriptor(access, name, desc, signature, value);
        fieldDescriptor.handle = Factory.fieldDescriptor(this.descriptor.name, name);
        this.addDescriptor(this.descriptor.fields, name, fieldDescriptor);
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final MethodDescriptor methodDescriptor = new MethodDescriptor(access, name, desc, signature, exceptions);
        methodDescriptor.handle = Factory.methodDescriptor(this.descriptor.name, name, Util.dequalifySignature(desc));
        this.addDescriptor(this.descriptor.methods, name, methodDescriptor);
        return new MethodAdapter(super.visitMethod(access, name, desc, signature, exceptions)){

            public AnnotationVisitor visitAnnotationDefault() {
                return new TraceAnnotationVisitor(this, methodDescriptor){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ MethodDescriptor val$methodDescriptor;
                    {
                        this.this$1 = var1_1;
                        this.val$methodDescriptor = methodDescriptor;
                    }

                    public void visitEnd() {
                        super.visitEnd();
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter writer = new PrintWriter(stringWriter);
                        this.print(writer);
                        writer.flush();
                        writer.close();
                        this.val$methodDescriptor.defaultValue = String.valueOf(stringWriter.getBuffer());
                    }
                };
            }
        };
    }
}

