/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.comparator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.comparator.ClassFileComparator;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.comparator.TypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;

public class ApiComparator {
    public static final IDelta NO_DELTA = new Delta();
    private static boolean DEBUG = Util.DEBUG;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public static IDelta compare(IClassFile classFile2, IApiComponent component, IApiComponent component2, IApiProfile referenceProfile, IApiProfile profile, int visibilityModifiers) {
        if (classFile2 == null) {
            throw new IllegalArgumentException("The given class file is null");
        }
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("One of the given components is null");
        }
        if (referenceProfile == null || profile == null) {
            throw new IllegalArgumentException("One of the given profiles is null");
        }
        try {
            TypeDescriptor typeDescriptor2 = new TypeDescriptor(classFile2);
            if (typeDescriptor2.isNestedType()) {
                return NO_DELTA;
            }
            String typeName = classFile2.getTypeName();
            IClassFile classFile = component.findClassFile(typeName);
            IApiDescription apiDescription2 = component2.getApiDescription();
            IApiAnnotations elementDescription2 = apiDescription2.resolveAnnotations(Factory.typeDescriptor(typeName));
            int visibility = 0;
            if (elementDescription2 != null) {
                visibility = elementDescription2.getVisibility();
            }
            IApiDescription referenceApiDescription = component.getApiDescription();
            IApiAnnotations refElementDescription = referenceApiDescription.resolveAnnotations(Factory.typeDescriptor(typeName));
            int refVisibility = 0;
            if (refElementDescription != null) {
                refVisibility = refElementDescription.getVisibility();
            }
            String deltaComponentID = Util.getDeltaComponentID(component2);
            if (classFile == null) {
                if (ApiComparator.isAPI(visibility, typeDescriptor2)) {
                    return new Delta(deltaComponentID, 2, 1, 46, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, typeDescriptor2.access, typeName, typeName, new String[]{typeName, deltaComponentID});
                }
                return NO_DELTA;
            }
            TypeDescriptor typeDescriptor = new TypeDescriptor(classFile);
            if ((visibility & visibilityModifiers) == 0) {
                if ((refVisibility & visibilityModifiers) == 0) {
                    return NO_DELTA;
                }
                if (ApiComparator.isAPI(refVisibility, typeDescriptor)) {
                    return new Delta(deltaComponentID, 2, 3, 56, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, typeDescriptor2.access, typeName, typeName, new String[]{typeName, deltaComponentID});
                }
            } else if (!ApiComparator.isAPI(refVisibility, typeDescriptor) && ApiComparator.isAPI(visibility, typeDescriptor2)) {
                return new Delta(deltaComponentID, 2, 1, 46, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, typeDescriptor2.access, typeName, typeName, new String[]{typeName, deltaComponentID});
            }
            if (visibilityModifiers == 1 && (Util.isDefault(typeDescriptor2.access) || Util.isPrivate(typeDescriptor2.access))) {
                return NO_DELTA;
            }
            ClassFileComparator comparator = new ClassFileComparator(typeDescriptor, classFile2, component, component2, referenceProfile, profile, visibilityModifiers);
            return comparator.getDelta();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static boolean isAPI(int visibility, TypeDescriptor typeDescriptor) {
        int access = typeDescriptor.access;
        return (visibility & 1) != 0 && (Util.isPublic(access) || Util.isProtected(access));
    }

    public static IDelta compare(IClassFile classFile, IClassFile classFile2, IApiComponent component, IApiComponent component2, IApiProfile referenceProfile, IApiProfile profile, int visibilityModifiers) {
        if (classFile == null || classFile2 == null) {
            throw new IllegalArgumentException("One of the given class files is null");
        }
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("One of the given components is null");
        }
        if (referenceProfile == null || profile == null) {
            throw new IllegalArgumentException("One of the given profiles is null");
        }
        ClassFileComparator comparator = new ClassFileComparator(classFile, classFile2, component, component2, referenceProfile, profile, visibilityModifiers);
        return comparator.getDelta();
    }

    public static IDelta compare(IApiProfile referenceProfile, IApiProfile profile, boolean force) {
        return ApiComparator.compare(referenceProfile, profile, 65535, force);
    }

    public static IDelta compare(IApiProfile referenceProfile, IApiProfile profile) {
        return ApiComparator.compare(referenceProfile, profile, 65535, false);
    }

    public static IDelta compare(IApiProfile referenceProfile, IApiProfile profile, int visibilityModifiers) {
        return ApiComparator.compare(referenceProfile, profile, visibilityModifiers, false);
    }

    public static IDelta compare(IApiProfile referenceProfile, IApiProfile profile, int visibilityModifiers, boolean force) {
        String id;
        IApiComponent apiComponent;
        if (referenceProfile == null || profile == null) {
            throw new IllegalArgumentException("None of the profiles must be null");
        }
        IApiComponent[] apiComponents = referenceProfile.getApiComponents();
        IApiComponent[] apiComponents2 = profile.getApiComponents();
        HashSet<String> apiComponentsIds = new HashSet<String>();
        Delta globalDelta = new Delta();
        int i = 0;
        int max = apiComponents.length;
        while (i < max) {
            apiComponent = apiComponents[i];
            if (!apiComponent.isSystemComponent()) {
                id = apiComponent.getId();
                IApiComponent apiComponent2 = profile.getApiComponent(id);
                IDelta delta = null;
                if (apiComponent2 == null) {
                    delta = new Delta(null, 3, 3, 3, null, id, id);
                } else {
                    apiComponentsIds.add(id);
                    String versionString = apiComponent.getVersion();
                    String versionString2 = apiComponent2.getVersion();
                    ApiComparator.checkBundleVersionChanges(apiComponent2, id, versionString, versionString2, globalDelta);
                    if (!versionString.equals(versionString2) || force) {
                        long time = System.currentTimeMillis();
                        try {
                            delta = ApiComparator.compare(apiComponent, apiComponent2, referenceProfile, profile, visibilityModifiers);
                        }
                        finally {
                            if (DEBUG) {
                                System.out.println("Time spent for " + id + " " + versionString + " : " + (System.currentTimeMillis() - time) + "ms");
                            }
                        }
                    }
                }
                if (delta != null && delta != NO_DELTA) {
                    globalDelta.add(delta);
                }
            }
            ++i;
        }
        i = 0;
        max = apiComponents2.length;
        while (i < max) {
            apiComponent = apiComponents2[i];
            if (!apiComponent.isSystemComponent() && !apiComponentsIds.contains(id = apiComponent.getId())) {
                globalDelta.add(new Delta(null, 3, 1, 3, null, id, id));
            }
            ++i;
        }
        return globalDelta.isEmpty() ? NO_DELTA : globalDelta;
    }

    private static void checkBundleVersionChanges(IApiComponent apiComponent2, String id, String apiComponentVersion, String apiComponentVersion2, Delta globalDelta) {
        Version version = null;
        try {
            version = new Version(apiComponentVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Version version2 = null;
        try {
            version2 = new Version(apiComponentVersion2);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (version != null && version2 != null) {
            if (version.getMajor() != version2.getMajor()) {
                globalDelta.add(new Delta(Util.getDeltaComponentID(apiComponent2), 2, 2, 59, 0, 0, null, id, new String[]{id, apiComponentVersion, apiComponentVersion2}));
            } else if (version.getMinor() != version2.getMinor()) {
                globalDelta.add(new Delta(Util.getDeltaComponentID(apiComponent2), 2, 2, 60, 0, 0, null, id, new String[]{id, apiComponentVersion, apiComponentVersion2}));
            }
        }
    }

    public static IDelta compare(IApiComponent component, IApiProfile referenceProfile, int visibilityModifiers, boolean force) {
        if (component == null) {
            throw new IllegalArgumentException("The composent cannot be null");
        }
        if (referenceProfile == null) {
            throw new IllegalArgumentException("The reference profile cannot be null");
        }
        IDelta delta = null;
        if (!component.isSystemComponent()) {
            String id = component.getId();
            IApiComponent apiComponent2 = referenceProfile.getApiComponent(id);
            if (apiComponent2 == null) {
                delta = new Delta(null, 3, 1, 3, null, id, id);
            } else if (!component.getVersion().equals(apiComponent2.getVersion()) || force) {
                long time = System.currentTimeMillis();
                try {
                    delta = ApiComparator.compare(apiComponent2, component, visibilityModifiers);
                }
                finally {
                    if (DEBUG) {
                        System.out.println("Time spent for " + id + " " + component.getVersion() + " : " + (System.currentTimeMillis() - time) + "ms");
                    }
                }
            }
            if (delta != null && delta != NO_DELTA) {
                return delta;
            }
        }
        return NO_DELTA;
    }

    public static IDelta compare(IApiComponent referenceComponent, IApiComponent component, int visibilityModifiers) {
        if (referenceComponent == null || component == null) {
            throw new IllegalArgumentException("One of the given components is null");
        }
        return ApiComparator.compare(referenceComponent, component, referenceComponent.getProfile(), component.getProfile(), visibilityModifiers);
    }

    public static IDelta compare(IApiComponent referenceComponent, IApiComponent component2, IApiProfile referenceProfile, IApiProfile profile) {
        return ApiComparator.compare(referenceComponent, component2, referenceProfile, profile, 65535);
    }

    public static IDelta compare(IApiComponent referenceComponent, IApiComponent component2, IApiProfile referenceProfile, IApiProfile profile, int visibilityModifiers) {
        String currentEE;
        if (referenceProfile == null || profile == null) {
            throw new IllegalArgumentException("The profiles cannot be null");
        }
        if (referenceComponent == null) {
            if (component2 == null) {
                throw new IllegalArgumentException("Both components cannot be null");
            }
            return new Delta(null, 3, 1, 3, null, component2.getId(), Util.getDeltaComponentID(component2));
        }
        if (component2 == null) {
            String referenceComponentId = referenceComponent.getId();
            return new Delta(null, 3, 3, 3, null, referenceComponentId, Util.getDeltaComponentID(referenceComponent));
        }
        String referenceComponentId = referenceComponent.getId();
        Delta globalDelta = new Delta();
        Set referenceEEs = Util.convertAsSet(referenceComponent.getExecutionEnvironments());
        Set componentsEEs = Util.convertAsSet(component2.getExecutionEnvironments());
        Iterator iterator = referenceEEs.iterator();
        while (iterator.hasNext()) {
            currentEE = (String)iterator.next();
            if (componentsEEs.remove(currentEE)) continue;
            globalDelta.add(new Delta(Util.getDeltaComponentID(referenceComponent), 2, 3, 13, 0, 0, null, referenceComponentId, new String[]{currentEE, Util.getDeltaComponentID(referenceComponent)}));
        }
        iterator = componentsEEs.iterator();
        while (iterator.hasNext()) {
            currentEE = (String)iterator.next();
            globalDelta.add(new Delta(Util.getDeltaComponentID(referenceComponent), 2, 1, 13, 0, 0, null, referenceComponentId, new String[]{currentEE, Util.getDeltaComponentID(referenceComponent)}));
        }
        try {
            return ApiComparator.internalCompare(referenceComponent, component2, referenceProfile, profile, visibilityModifiers, globalDelta);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static IDelta internalCompare(final IApiComponent component, final IApiComponent component2, final IApiProfile referenceProfile, final IApiProfile profile, final int visibilityModifiers, final Delta globalDelta) throws CoreException {
        IClassFileContainer container;
        int max;
        int i;
        final HashSet classFileBaseLineNames = new HashSet();
        final String id = component.getId();
        IClassFileContainer[] classFileContainers = null;
        IClassFileContainer[] classFileContainers2 = null;
        final boolean isSWT = "org.eclipse.swt".equals(id);
        if (isSWT) {
            classFileContainers = component.getClassFileContainers();
            classFileContainers2 = component2.getClassFileContainers();
        } else {
            classFileContainers = component.getClassFileContainers(id);
            classFileContainers2 = component2.getClassFileContainers(id);
        }
        final IApiDescription apiDescription = component.getApiDescription();
        final IApiDescription apiDescription2 = component2.getApiDescription();
        if (classFileContainers != null) {
            i = 0;
            max = classFileContainers.length;
            while (i < max) {
                container = classFileContainers[i];
                try {
                    container.accept(new ClassFileContainerVisitor(){

                        public void visit(String packageName, IClassFile classFile) {
                            String typeName = classFile.getTypeName();
                            IApiAnnotations elementDescription = apiDescription.resolveAnnotations(Factory.typeDescriptor(typeName));
                            try {
                                TypeDescriptor typeDescriptor = new TypeDescriptor(classFile);
                                if (typeDescriptor.isNestedType()) {
                                    return;
                                }
                                int visibility = 0;
                                if (elementDescription != null) {
                                    visibility = elementDescription.getVisibility();
                                }
                                IClassFile classFile2 = null;
                                classFile2 = isSWT ? component2.findClassFile(typeName) : component2.findClassFile(typeName, id);
                                String deltaComponentID = Util.getDeltaComponentID(component2);
                                if (classFile2 == null) {
                                    if ((visibility & visibilityModifiers) == 0) {
                                        return;
                                    }
                                    if (visibilityModifiers == 1 && (Util.isDefault(typeDescriptor.access) || Util.isPrivate(typeDescriptor.access))) {
                                        return;
                                    }
                                    globalDelta.add(new Delta(deltaComponentID, 2, 3, 46, 0, 0, typeName, typeName, new String[]{typeName, deltaComponentID}));
                                } else {
                                    if ((visibility & visibilityModifiers) == 0) {
                                        return;
                                    }
                                    TypeDescriptor typeDescriptor2 = new TypeDescriptor(classFile2);
                                    IApiAnnotations elementDescription2 = apiDescription2.resolveAnnotations(Factory.typeDescriptor(typeName));
                                    int visibility2 = 0;
                                    if (elementDescription2 != null) {
                                        visibility2 = elementDescription2.getVisibility();
                                    }
                                    if (visibilityModifiers == 1 && (Util.isDefault(typeDescriptor.access) || Util.isPrivate(typeDescriptor.access))) {
                                        return;
                                    }
                                    if (ApiComparator.isAPI(visibility, typeDescriptor) && !ApiComparator.isAPI(visibility2, typeDescriptor2)) {
                                        globalDelta.add(new Delta(deltaComponentID, 2, 3, 56, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, typeDescriptor2.access, typeName, typeName, new String[]{typeName, deltaComponentID}));
                                        return;
                                    }
                                    if ((visibility2 & visibilityModifiers) == 0) {
                                        globalDelta.add(new Delta(deltaComponentID, 2, 2, 52, elementDescription2 != null ? elementDescription2.getRestrictions() : 0, typeDescriptor2.access, typeName, typeName, new String[]{typeName, deltaComponentID}));
                                    }
                                    classFileBaseLineNames.add(typeName);
                                    ClassFileComparator comparator = new ClassFileComparator(typeDescriptor, classFile2, component, component2, referenceProfile, profile, visibilityModifiers);
                                    IDelta delta = comparator.getDelta();
                                    if (delta != null && delta != NO_DELTA) {
                                        globalDelta.add(delta);
                                    }
                                }
                            }
                            catch (CoreException e) {
                                ApiPlugin.log(e);
                            }
                        }
                    });
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
                ++i;
            }
        }
        if (classFileContainers2 != null) {
            i = 0;
            max = classFileContainers2.length;
            while (i < max) {
                container = classFileContainers2[i];
                try {
                    container.accept(new ClassFileContainerVisitor(){

                        public void visit(String packageName, IClassFile classFile) {
                            String typeName = classFile.getTypeName();
                            IApiAnnotations elementDescription = apiDescription2.resolveAnnotations(Factory.typeDescriptor(typeName));
                            try {
                                TypeDescriptor typeDescriptor = new TypeDescriptor(classFile);
                                if (typeDescriptor.isNestedType()) {
                                    return;
                                }
                                if (ApiComparator.filterType(visibilityModifiers, elementDescription, typeDescriptor)) {
                                    return;
                                }
                                if (classFileBaseLineNames.contains(typeName)) {
                                    return;
                                }
                                classFileBaseLineNames.add(typeName);
                                String deltaComponentID = Util.getDeltaComponentID(component2);
                                globalDelta.add(new Delta(deltaComponentID, 2, 1, 46, elementDescription != null ? elementDescription.getRestrictions() : 0, typeDescriptor.access, typeName, typeName, new String[]{typeName, deltaComponentID}));
                            }
                            catch (CoreException e) {
                                ApiPlugin.log(e);
                            }
                        }
                    });
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
                ++i;
            }
        }
        return globalDelta.isEmpty() ? NO_DELTA : globalDelta;
    }

    static boolean filterType(int visibilityModifiers, IApiAnnotations elementDescription, TypeDescriptor typeDescriptor) {
        if (elementDescription != null && (elementDescription.getVisibility() & visibilityModifiers) == 0) {
            return true;
        }
        return visibilityModifiers == 1 && (Util.isDefault(typeDescriptor.access) || Util.isPrivate(typeDescriptor.access));
    }
}

