/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.provisional.search.IReference;
import org.eclipse.pde.api.tools.internal.search.Location;
import org.eclipse.pde.api.tools.internal.search.MethodExtractor;
import org.eclipse.pde.api.tools.internal.search.SearchEngine;
import org.eclipse.pde.api.tools.internal.util.Util;

public class Reference
implements IReference {
    private ILocation target = null;
    private ILocation source = null;
    private ILocation resolved = null;
    private int kind;
    private IApiAnnotations description = null;
    private static final int METHODS_TO_RESOLVE = 269484928;

    public Reference(ILocation source, ILocation target, int kind) {
        this.source = source;
        this.target = target;
        this.kind = kind;
    }

    public int getReferenceKind() {
        return this.kind;
    }

    public ILocation getSourceLocation() {
        return this.source;
    }

    public IApiAnnotations getResolvedAnnotations() {
        return this.description;
    }

    public ILocation getReferencedLocation() {
        return this.target;
    }

    void resolve(SearchEngine engine) throws CoreException {
        IApiComponent sourceComponent;
        if (this.resolved == null && (sourceComponent = this.source.getApiComponent()) != null) {
            if ((this.getReferenceKind() & 0x10100380) > 0) {
                IMethodDescriptor method = (IMethodDescriptor)this.target.getMember();
                this.resolveVirtualMethod(sourceComponent, method, engine);
            } else {
                IApiComponent cpackage = Util.getComponent(sourceComponent.getProfile().resolvePackage(sourceComponent, this.target.getType().getPackage().getName()), this.target.getType().getQualifiedName());
                if (cpackage != null) {
                    Location res = new Location(cpackage, this.target.getMember());
                    res.setLineNumber(this.target.getLineNumber());
                    IApiAnnotations ann = cpackage.getApiDescription().resolveAnnotations(res.getMember());
                    this.setResolution(ann, res);
                }
            }
        }
    }

    private boolean resolveVirtualMethod(IApiComponent callSiteComponent, IMethodDescriptor method, SearchEngine engine) throws CoreException {
        IClassFile classFile;
        String receivingTypeName;
        IApiComponent[] implComponents = callSiteComponent.getProfile().resolvePackage(callSiteComponent, method.getPackage().getName());
        IApiComponent implComponent = Util.getComponent(implComponents, receivingTypeName = method.getEnclosingType().getQualifiedName());
        if (implComponent != null && (classFile = implComponent.findClassFile(receivingTypeName)) != null) {
            MethodExtractor extractor = engine.getExtraction(classFile);
            IMethodDescriptor[] methods = extractor.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethodDescriptor methodInfo = methods[i];
                if (methodInfo.equals(method)) {
                    if (methodInfo.isSynthetic()) {
                        return false;
                    }
                    Location res = new Location(implComponent, method);
                    IApiAnnotations ann = implComponent.getApiDescription().resolveAnnotations(res.getMember());
                    this.setResolution(ann, res);
                    return true;
                }
                ++i;
            }
            if (this.kind == 512) {
                String[] interaces = extractor.getInteraces();
                if (interaces != null) {
                    int i2 = 0;
                    while (i2 < interaces.length) {
                        IReferenceTypeDescriptor supertype = Util.getType(interaces[i2]);
                        if (this.resolveVirtualMethod(implComponent, supertype.getMethod(method.getName(), method.getSignature()), engine)) {
                            return true;
                        }
                        ++i2;
                    }
                }
            } else {
                String superName = extractor.getSuperclassName();
                if (superName != null) {
                    IReferenceTypeDescriptor supertype = Util.getType(superName);
                    return this.resolveVirtualMethod(implComponent, supertype.getMethod(method.getName(), method.getSignature()), engine);
                }
            }
        }
        return false;
    }

    public String toString() {
        String kindstr = Util.getReferenceKind(this.kind);
        if (kindstr == null) {
            kindstr = "UNKNOWN_KIND";
        }
        StringBuffer ms = new StringBuffer();
        ms.append(this.source.getMember().toString());
        ms.append(" references ");
        ms.append(this.target.getMember().toString());
        ms.append(" via ");
        ms.append(kindstr);
        int lineNumber = this.getSourceLocation().getLineNumber();
        if (lineNumber != -1) {
            ms.append(" [line: ");
            ms.append(lineNumber);
            ms.append("]");
        }
        return ms.toString();
    }

    void setResolution(IApiAnnotations resolution, ILocation targetLocation) {
        this.description = resolution;
        this.resolved = targetLocation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            return this.getReferenceKind() == ref.getReferenceKind() && this.equalOrNull(this.getResolvedLocation(), ref.getResolvedLocation()) && this.getSourceLocation().equals(ref.getSourceLocation()) && this.getReferencedLocation().equals(ref.getReferencedLocation()) && Util.equalsOrNull(this.getResolvedAnnotations(), ref.getResolvedAnnotations());
        }
        return false;
    }

    private boolean equalOrNull(ILocation l1, ILocation l2) {
        if (l1 == null) {
            return l2 == null;
        }
        return l1.equals(l2);
    }

    public int hashCode() {
        return this.kind + this.source.hashCode() + this.target.hashCode();
    }

    public ILocation getResolvedLocation() {
        return this.resolved;
    }
}

