/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ScopedClassFileContainer
implements IClassFileContainer {
    private IApiComponent fComponent;
    private Map fTypesPerPackage = new HashMap();
    private Set fPackageNames;

    public ScopedClassFileContainer(IApiComponent component, IElementDescriptor[] elements) {
        this.fComponent = component;
        this.init(elements);
    }

    private void init(IElementDescriptor[] elements) {
        int i = 0;
        while (i < elements.length) {
            IElementDescriptor element = elements[i];
            IPackageDescriptor pkg = null;
            IReferenceTypeDescriptor type = null;
            if (element instanceof IPackageDescriptor) {
                pkg = (IPackageDescriptor)element;
            } else if (element instanceof IMemberDescriptor) {
                IMemberDescriptor member = (IMemberDescriptor)element;
                pkg = member.getPackage();
                type = element instanceof IReferenceTypeDescriptor ? (IReferenceTypeDescriptor)element : member.getEnclosingType();
            }
            String pkgname = pkg.getName();
            HashSet<String> types = (HashSet<String>)this.fTypesPerPackage.get(pkgname);
            if (types == null) {
                types = new HashSet<String>();
                this.fTypesPerPackage.put(pkgname, types);
            }
            if (type != null) {
                types.add(type.getQualifiedName());
            }
            ++i;
        }
        this.fPackageNames = this.fTypesPerPackage.keySet();
    }

    public void accept(ClassFileContainerVisitor visitor) throws CoreException {
        ProxyVisitor proxyVisitor = new ProxyVisitor(visitor);
        this.fComponent.accept(proxyVisitor);
    }

    public void close() throws CoreException {
        this.fComponent.close();
    }

    public IClassFile findClassFile(String qualifiedName) throws CoreException {
        String packageName = Util.getPackageName(qualifiedName);
        Set types = (Set)this.fTypesPerPackage.get(packageName);
        if (types != null) {
            if (types.isEmpty()) {
                return this.fComponent.findClassFile(qualifiedName);
            }
            if (types.contains(qualifiedName)) {
                return this.fComponent.findClassFile(qualifiedName);
            }
        }
        return null;
    }

    public IClassFile findClassFile(String qualifiedName, String id) throws CoreException {
        String packageName = Util.getPackageName(qualifiedName);
        Set types = (Set)this.fTypesPerPackage.get(packageName);
        if (types != null) {
            if (types.isEmpty()) {
                return this.fComponent.findClassFile(qualifiedName, id);
            }
            if (types.contains(qualifiedName)) {
                return this.fComponent.findClassFile(qualifiedName, id);
            }
        }
        return null;
    }

    public String[] getPackageNames() throws CoreException {
        return this.fPackageNames.toArray(new String[this.fPackageNames.size()]);
    }

    public String getOrigin() {
        return this.fComponent.getId();
    }

    class ProxyVisitor
    extends ClassFileContainerVisitor {
        private ClassFileContainerVisitor fVisitor;

        ProxyVisitor(ClassFileContainerVisitor visitor) {
            this.fVisitor = visitor;
        }

        public void end(IApiComponent component) {
            if (ScopedClassFileContainer.this.fComponent.equals(component)) {
                this.fVisitor.end(component);
            }
        }

        public boolean visit(IApiComponent component) {
            if (ScopedClassFileContainer.this.fComponent.equals(component)) {
                return this.fVisitor.visit(component);
            }
            return false;
        }

        public void end(String packageName, IClassFile classFile) {
            Set types = (Set)ScopedClassFileContainer.this.fTypesPerPackage.get(packageName);
            if (types != null && types.contains(classFile.getTypeName())) {
                this.fVisitor.end(packageName, classFile);
            }
        }

        public void endVisitPackage(String packageName) {
            if (ScopedClassFileContainer.this.fPackageNames.contains(packageName)) {
                this.fVisitor.endVisitPackage(packageName);
            }
        }

        public void visit(String packageName, IClassFile classFile) {
            Set types = (Set)ScopedClassFileContainer.this.fTypesPerPackage.get(packageName);
            if (types != null) {
                String typeName = classFile.getTypeName();
                int index = typeName.indexOf(36);
                if (index >= 0) {
                    typeName = typeName.substring(0, index);
                }
                if (types.isEmpty() || types.contains(typeName)) {
                    this.fVisitor.visit(packageName, classFile);
                }
            }
        }

        public boolean visitPackage(String packageName) {
            if (ScopedClassFileContainer.this.fPackageNames.contains(packageName)) {
                return this.fVisitor.visitPackage(packageName);
            }
            return false;
        }
    }
}

