/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchCriteria;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.provisional.search.IReference;
import org.eclipse.pde.api.tools.internal.util.Util;

public class SearchCriteria
implements IApiSearchCriteria {
    protected Map fComponentIds = new HashMap();
    protected int fReferenceKinds = Integer.MAX_VALUE;
    protected int fVisibilityKinds = 65535;
    protected int fRestrictionKinds = 0;
    protected int fSourceModifiers = -1;
    protected int fSourceVisibility = 65535;
    protected int fSourceRestriction = 65535;
    private String[] fSourceFilter = null;
    private Object fUserData;
    private List fPatterns = null;
    private List fPotentialElements = null;

    private Set getParents(IElementDescriptor element) {
        HashSet<IElementDescriptor> parents = new HashSet<IElementDescriptor>();
        IElementDescriptor parent = element.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        return parents;
    }

    private boolean encloses(String componentId, IElementDescriptor element) {
        Set leaves = (Set)this.fComponentIds.get(componentId);
        if (leaves != null) {
            if (leaves.isEmpty()) {
                return true;
            }
            Iterator iterator = leaves.iterator();
            Set parents = this.getParents(element);
            while (iterator.hasNext()) {
                IElementDescriptor leaf = (IElementDescriptor)iterator.next();
                if (!leaf.equals(element) && !parents.contains(leaf)) continue;
                return true;
            }
        }
        return false;
    }

    public void addReferencedComponentRestriction(String componentId) {
        HashSet components = (HashSet)this.fComponentIds.get(componentId);
        if (components == null) {
            components = new HashSet();
            this.fComponentIds.put(componentId, components);
        }
    }

    public void addReferencedElementRestriction(String componentId, IElementDescriptor[] elements) {
        if (this.fPotentialElements == null) {
            this.fPotentialElements = new ArrayList(elements.length);
        }
        int i = 0;
        while (i < elements.length) {
            IElementDescriptor element = elements[i];
            this.fPotentialElements.add(new PotentialElementMatch(element));
            Set parents = this.getParents(element);
            Set leaves = (Set)this.fComponentIds.get(componentId);
            if (leaves == null) {
                this.addReferencedComponentRestriction(componentId);
                leaves = (Set)this.fComponentIds.get(componentId);
            }
            Iterator iterator = parents.iterator();
            while (iterator.hasNext()) {
                IElementDescriptor el = (IElementDescriptor)iterator.next();
                if (!leaves.contains(el)) continue;
                return;
            }
            iterator = leaves.iterator();
            while (iterator.hasNext()) {
                IElementDescriptor leaf = (IElementDescriptor)iterator.next();
                parents = this.getParents(leaf);
                if (!parents.contains(element)) continue;
                iterator.remove();
            }
            leaves.add(element);
            ++i;
        }
    }

    public void addReferencedPatternRestriction(String regEx, int elementType) {
        if (this.fPatterns == null) {
            this.fPatterns = new ArrayList();
        }
        this.fPatterns.add(new PatternMatch(regEx, elementType));
    }

    public int getReferenceKinds() {
        return this.fReferenceKinds;
    }

    public boolean isMatch(IReference reference) {
        IApiAnnotations annotations;
        ILocation location = reference.getResolvedLocation();
        if (location != null && (annotations = reference.getResolvedAnnotations()) != null) {
            return this.matchesElementRestrictions(location) && this.matchesApiRestrictions(annotations);
        }
        return false;
    }

    private boolean matchesPatternRestrictions(ILocation location) {
        if (this.fPatterns == null) {
            return true;
        }
        IMemberDescriptor element = location.getMember();
        Iterator iterator = this.fPatterns.iterator();
        while (iterator.hasNext()) {
            PatternMatch pattern = (PatternMatch)iterator.next();
            if (!pattern.matches(element)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesApiRestrictions(IApiAnnotations annotations) {
        int vis = annotations.getVisibility();
        int res = annotations.getRestrictions();
        return (vis & this.fVisibilityKinds) > 0 && (this.fRestrictionKinds == 65535 || (res & this.fRestrictionKinds) > 0);
    }

    private boolean matchesElementRestrictions(ILocation location) {
        if (this.fComponentIds.isEmpty()) {
            return true;
        }
        return this.encloses(location.getApiComponent().getId(), location.getMember());
    }

    public void setReferencedRestrictions(int visibilityMask, int restrictionMask) {
        this.fVisibilityKinds = visibilityMask;
        this.fRestrictionKinds = restrictionMask;
    }

    public void setReferenceKinds(int referenceMask) {
        this.fReferenceKinds = referenceMask;
    }

    public boolean isPotentialMatch(IReference reference) {
        return (reference.getReferenceKind() & this.fReferenceKinds) > 0 && !this.isFilteredSourceLocation(reference.getSourceLocation()) && this.matchesSourceModifiers(reference.getSourceLocation()) && this.matchesSourceApiRestrictions(reference.getSourceLocation()) && this.matchesPatternRestrictions(reference.getReferencedLocation()) && this.isPotentialElementMatch(reference.getReferencedLocation());
    }

    private boolean isFilteredSourceLocation(ILocation location) {
        if (this.fSourceFilter == null) {
            return false;
        }
        int i = 0;
        while (i < this.fSourceFilter.length) {
            if (location.getApiComponent().getId().equals(this.fSourceFilter[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchesSourceApiRestrictions(ILocation location) {
        block6: {
            block5: {
                IApiAnnotations annotations;
                block7: {
                    if (this.fSourceVisibility == 65535 && this.fSourceRestriction == 65535) {
                        return true;
                    }
                    IApiComponent apiComponent = location.getApiComponent();
                    annotations = apiComponent.getApiDescription().resolveAnnotations(location.getMember());
                    if (annotations == null) break block5;
                    if ((annotations.getVisibility() & this.fSourceVisibility) <= 0) break block6;
                    if (this.fSourceRestriction != 65535) break block7;
                    return true;
                }
                try {
                    int ares = annotations.getRestrictions();
                    if (ares != 0) {
                        return (ares & this.fSourceRestriction) > 0;
                    }
                    return this.fSourceRestriction != 0;
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean matchesSourceModifiers(ILocation location) {
        if (this.fSourceModifiers == -1) {
            return true;
        }
        for (IMemberDescriptor member = location.getMember(); member != null; member = member.getEnclosingType()) {
            int modifiers = member.getModifiers();
            if ((this.fSourceModifiers & modifiers) > 0 || this.fSourceModifiers == modifiers) {
                continue;
            }
            return false;
        }
        return true;
    }

    protected boolean isPotentialElementMatch(ILocation location) {
        if (this.fPotentialElements == null) {
            return true;
        }
        IMemberDescriptor element = location.getMember();
        Iterator iterator = this.fPotentialElements.iterator();
        while (iterator.hasNext()) {
            PotentialElementMatch match = (PotentialElementMatch)iterator.next();
            if (!match.matches(element)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("*** Search Criteria ***\n");
        buffer.append("Reference Kinds: ").append(Util.getReferenceKind(this.fReferenceKinds)).append("\n");
        buffer.append("Reference Restriction Kinds: ").append(Util.getRestrictionKind(this.fRestrictionKinds)).append("\n");
        buffer.append("Reference Visibility Kinds: ").append(Util.getVisibilityKind(this.fVisibilityKinds)).append("\n");
        buffer.append("Source Restriction Kinds: ").append(Util.getRestrictionKind(this.fSourceRestriction)).append("\n");
        buffer.append("Source Visibility Kinds: ").append(Util.getVisibilityKind(this.fSourceVisibility)).append("\n");
        if (this.fUserData != null) {
            buffer.append("User Data: ").append(this.fUserData.toString());
        }
        if (this.fPatterns != null) {
            buffer.append("Patterns: ").append(this.fPatterns.toString()).append("\n");
        }
        if (this.fPotentialElements != null) {
            buffer.append("Potential Matches: ").append(this.fPotentialElements.toString()).append("\n");
        }
        return buffer.toString();
    }

    public void setSourceModifiers(int modifiers) {
        this.fSourceModifiers = modifiers;
    }

    public void setSourceRestrictions(int visibilityMask, int restrictionMask) {
        this.fSourceVisibility = visibilityMask;
        this.fSourceRestriction = restrictionMask;
    }

    public void addSourceFilter(String componentId) {
        if (this.fSourceFilter == null) {
            this.fSourceFilter = new String[]{componentId};
        } else {
            String[] temp = new String[this.fSourceFilter.length + 1];
            System.arraycopy(this.fSourceFilter, 0, temp, 0, this.fSourceFilter.length);
            temp[this.fSourceFilter.length] = componentId;
            this.fSourceFilter = temp;
        }
    }

    public Object getUserData() {
        return this.fUserData;
    }

    public void setUserData(Object object) {
        this.fUserData = object;
    }

    class PatternMatch {
        private int fElementType;
        private Pattern fPattern = null;

        PatternMatch(String pattern, int elementType) {
            this.fElementType = elementType;
            this.fPattern = Pattern.compile(pattern);
        }

        public boolean matches(IElementDescriptor element) {
            String name = null;
            IReferenceTypeDescriptor potentialInner = null;
            switch (this.fElementType) {
                case 1: {
                    switch (element.getElementType()) {
                        case 1: {
                            name = ((IPackageDescriptor)element).getName();
                            break;
                        }
                        case 2: 
                        case 5: 
                        case 6: {
                            name = ((IMemberDescriptor)element).getPackage().getName();
                        }
                    }
                    break;
                }
                case 2: {
                    switch (element.getElementType()) {
                        case 2: {
                            potentialInner = (IReferenceTypeDescriptor)element;
                            name = potentialInner.getQualifiedName();
                            break;
                        }
                        case 5: 
                        case 6: {
                            potentialInner = ((IMemberDescriptor)element).getEnclosingType();
                            name = potentialInner.getQualifiedName();
                        }
                    }
                    break;
                }
                case 6: {
                    switch (element.getElementType()) {
                        case 6: {
                            name = ((IMethodDescriptor)element).getName();
                        }
                    }
                    break;
                }
                case 5: {
                    switch (element.getElementType()) {
                        case 5: {
                            name = ((IFieldDescriptor)element).getName();
                        }
                    }
                }
            }
            if (name != null) {
                IReferenceTypeDescriptor type;
                Matcher matcher = this.fPattern.matcher(name);
                if (matcher.matches()) {
                    return true;
                }
                if (potentialInner != null && (type = potentialInner.getEnclosingType()) != null) {
                    return this.matches(type);
                }
            }
            return false;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Element: ").append(Util.getDescriptorKind(this.fElementType));
            if (this.fPattern != null) {
                buffer.append(" with pattern :").append(((Object)this.fPattern).toString());
            }
            return buffer.toString();
        }
    }

    class PotentialElementMatch {
        private IElementDescriptor fElement;

        PotentialElementMatch(IElementDescriptor element) {
            this.fElement = element;
        }

        public boolean matches(IElementDescriptor element) {
            if (element.getElementType() == 6) {
                if (this.fElement.getElementType() == 6) {
                    IMethodDescriptor potential = (IMethodDescriptor)element;
                    IMethodDescriptor target = (IMethodDescriptor)this.fElement;
                    return potential.getName().equals(target.getName()) && potential.getSignature().equals(target.getSignature());
                }
                return true;
            }
            if (this.fElement.equals(element)) {
                return true;
            }
            Set parents = SearchCriteria.this.getParents(element);
            return parents.contains(this.fElement);
        }

        public String toString() {
            return this.fElement.toString();
        }
    }
}

