/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.AbstractClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.search.ScopedClassFileContainer;

public class SearchScope
extends AbstractClassFileContainer
implements IApiSearchScope {
    private Map fComponents = new HashMap();
    private Map fComponentIds = new HashMap();

    public void addComponent(IApiComponent component) {
        this.fComponents.put(component, new HashSet());
        HashSet<IApiComponent> components = (HashSet<IApiComponent>)this.fComponentIds.get(component.getId());
        if (components == null) {
            components = new HashSet<IApiComponent>();
            this.fComponentIds.put(component.getId(), components);
        }
        components.add(component);
    }

    public void addElement(IApiComponent component, IElementDescriptor element) {
        Set parents = this.getParents(element);
        Set leaves = (Set)this.fComponents.get(component);
        if (leaves == null) {
            this.addComponent(component);
            leaves = (Set)this.fComponents.get(component);
        }
        Iterator iterator = parents.iterator();
        while (iterator.hasNext()) {
            IElementDescriptor el = (IElementDescriptor)iterator.next();
            if (!leaves.contains(el)) continue;
            return;
        }
        iterator = leaves.iterator();
        while (iterator.hasNext()) {
            IElementDescriptor leaf = (IElementDescriptor)iterator.next();
            parents = this.getParents(leaf);
            if (!parents.contains(element)) continue;
            iterator.remove();
        }
        leaves.add(element);
    }

    private Set getParents(IElementDescriptor element) {
        HashSet<IElementDescriptor> parents = new HashSet<IElementDescriptor>();
        IElementDescriptor parent = element.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        return parents;
    }

    protected List createClassFileContainers() throws CoreException {
        ArrayList<IClassFileContainer> containers = new ArrayList<IClassFileContainer>(this.fComponents.size());
        Iterator iterator = this.fComponents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IApiComponent component = (IApiComponent)entry.getKey();
            if (component == null) continue;
            Set leaves = (Set)entry.getValue();
            if (leaves.isEmpty()) {
                containers.add(component);
                continue;
            }
            containers.add(new ScopedClassFileContainer(component, leaves.toArray(new IElementDescriptor[leaves.size()])));
        }
        return containers;
    }

    public boolean encloses(String componentId, IElementDescriptor element) {
        Set set = (Set)this.fComponentIds.get(componentId);
        if (set != null) {
            Iterator componets = set.iterator();
            while (componets.hasNext()) {
                Set leaves = (Set)this.fComponents.get(componets.next());
                if (leaves == null) continue;
                if (leaves.isEmpty()) {
                    return true;
                }
                Iterator iterator = leaves.iterator();
                Set parents = this.getParents(element);
                while (iterator.hasNext()) {
                    IElementDescriptor leaf = (IElementDescriptor)iterator.next();
                    if (!leaf.equals(element) && !parents.contains(leaf)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getOrigin() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("*** Search Scope ***\n");
        IApiComponent key = null;
        HashSet entry = null;
        Iterator iter = this.fComponents.keySet().iterator();
        while (iter.hasNext()) {
            key = (IApiComponent)iter.next();
            entry = (HashSet)this.fComponents.get(key);
            buffer.append("Component: ").append(key.getId()).append('\n');
            buffer.append("Elements: ").append(entry.toString()).append('\n');
        }
        return buffer.toString();
    }
}

