/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class SinceTagVersion {
    private String prefixString;
    private Version version;
    private String versionString;
    private String postfixString;
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\s([0-9]+\\.?[0-9]?\\.?[0-9]?\\.?[A-Za-z0-9]*)\\s");
    private static final Pattern NO_SPACE_VERSION_PATTERN = Pattern.compile("([0-9]+\\.?[0-9]?\\.?[0-9]?\\.?[A-Za-z0-9]*)");
    private static final Pattern NO_LEADING_SPACE_VERSION_PATTERN = Pattern.compile("([0-9]+\\.?[0-9]?\\.?[0-9]?\\.?[A-Za-z0-9]*)\\s");

    public SinceTagVersion(String value) {
        if (value == null) {
            throw new IllegalArgumentException("The given value cannot be null");
        }
        Matcher m = VERSION_PATTERN.matcher(value);
        if (m.find()) {
            this.versionString = m.group(1);
            m = NO_LEADING_SPACE_VERSION_PATTERN.matcher(value);
            if (m.find()) {
                this.versionString = m.group(1);
            }
        } else {
            m = NO_SPACE_VERSION_PATTERN.matcher(value);
            if (m.find()) {
                this.versionString = m.group(1);
            }
        }
        if (this.versionString != null) {
            int beginIndex;
            int prefixIndex = value.indexOf(this.versionString);
            if (this.versionString.length() != value.length() && prefixIndex != 0) {
                this.prefixString = value.substring(0, prefixIndex);
            }
            if ((beginIndex = prefixIndex + this.versionString.length()) != value.length()) {
                this.postfixString = value.substring(beginIndex);
            }
            try {
                this.version = new Version(this.versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (value.length() != 0) {
            this.postfixString = value;
        }
    }

    public String getVersionString() {
        return this.versionString;
    }

    public Version getVersion() {
        return this.version;
    }

    public String prefixString() {
        return this.prefixString;
    }

    public String postfixString() {
        return this.postfixString;
    }
}

