/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.target.TargetObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocationInfo
extends TargetObject
implements ILocationInfo {
    private static final long serialVersionUID = 1L;
    private String fPath = "";
    private boolean fUseDefault = true;

    public LocationInfo(ITargetModel model) {
        super(model);
    }

    public void parse(Node node) {
        Element element = (Element)node;
        this.fPath = element.getAttribute("path");
        this.fUseDefault = "true".equalsIgnoreCase(element.getAttribute("useDefault"));
    }

    public void write(String indent, PrintWriter writer) {
        writer.println();
        writer.print(String.valueOf(indent) + "<location");
        if (this.fUseDefault) {
            writer.print(" useDefault=\"true\"");
        } else if (this.fPath != null && this.fPath.trim().length() > 0) {
            writer.print(" path=\"" + this.getWritableString(this.fPath.trim()) + "\"");
        }
        writer.println("/>");
    }

    public boolean useDefault() {
        return this.fUseDefault;
    }

    public void setDefault(boolean value) {
        this.fUseDefault = value;
        if (value) {
            this.firePropertyChanged("location", this.fPath, "");
        } else {
            this.firePropertyChanged("location", "", this.fPath);
        }
    }

    public String getPath() {
        return this.fPath;
    }

    public void setPath(String path) {
        this.fUseDefault = false;
        String oldValue = this.fPath;
        this.fPath = path != null ? path : "";
        this.firePropertyChanged("location", oldValue, this.fPath);
    }
}

