/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.toc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.itoc.ITocConstants;
import org.eclipse.pde.internal.core.text.DocumentObject;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.toc.Toc;
import org.eclipse.pde.internal.core.text.toc.TocModel;

public abstract class TocObject
extends DocumentObject
implements ITocConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$0;

    public TocObject(TocModel model, String tagName) {
        super(model, tagName);
    }

    protected String getAttributeIndent() {
        return " ";
    }

    public List getChildren() {
        ArrayList<IDocumentElementNode> list = new ArrayList<IDocumentElementNode>();
        IDocumentElementNode[] childNodes = this.getChildNodes();
        if (childNodes.length > 0) {
            int i = 0;
            while (i < childNodes.length) {
                if (childNodes[i] instanceof TocObject) {
                    list.add(childNodes[i]);
                }
                ++i;
            }
        }
        return list;
    }

    public boolean isLeafNode() {
        return !this.canBeParent();
    }

    public abstract boolean canBeParent();

    public TocModel getModel() {
        IModel sharedModel = this.getSharedModel();
        if (sharedModel instanceof TocModel) {
            return (TocModel)sharedModel;
        }
        return null;
    }

    public Toc getToc() {
        TocModel model = this.getModel();
        if (model != null) {
            return model.getToc();
        }
        return null;
    }

    public abstract String getName();

    public abstract String getPath();

    public TocObject getParent() {
        IDocumentElementNode parent = this.getParentNode();
        return parent instanceof TocObject ? (TocObject)parent : null;
    }

    public boolean descendsFrom(TocObject obj) {
        if (this.equals(obj)) {
            return true;
        }
        if (this.getParent() != null && obj.canBeParent()) {
            return this.getParent().descendsFrom(obj);
        }
        return false;
    }

    public abstract int getType();

    public TocObject getPreviousSibling(TocObject tocObject) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.text.toc.TocObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TocObject)this.getPreviousSibling(tocObject, clazz);
    }

    public TocObject getNextSibling(TocObject tocObject) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.text.toc.TocObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TocObject)this.getNextSibling(tocObject, clazz);
    }

    public boolean canBeRemoved() {
        if (this.getType() == 0) {
            return false;
        }
        TocObject parent = this.getParent();
        if (parent != null) {
            if (parent.getType() == 0) {
                return parent.getChildren().size() > 1;
            }
            return true;
        }
        return false;
    }
}

