/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;

public class CoreUtility {
    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            fos = null;
            in.close();
            in = null;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
    }

    public static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                CoreUtility.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    public static void createProject(IProject project, IPath location, IProgressMonitor monitor) throws CoreException {
        if (!Platform.getLocation().equals((Object)location)) {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation(location);
            project.create(desc, monitor);
        } else {
            project.create(monitor);
        }
    }

    public static String normalize(String text) {
        if (text == null || text.trim().length() == 0) {
            return "";
        }
        text = text.replaceAll("\\r|\\n|\\f|\\t", " ");
        return text.replaceAll("\\s+", " ");
    }

    public static void deleteContent(File curr) {
        if (curr.exists()) {
            File[] children;
            if (curr.isDirectory() && (children = curr.listFiles()) != null) {
                int i = 0;
                while (i < children.length) {
                    CoreUtility.deleteContent(children[i]);
                    ++i;
                }
            }
            curr.delete();
        }
    }

    public static boolean guessUnpack(BundleDescription bundle) {
        IPluginModelBase model;
        if (bundle == null) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation((IPath)new Path(bundle.getLocation()));
        if (container == null) {
            return true;
        }
        if (container instanceof IProject) {
            try {
                if (!((IProject)container).hasNature("org.eclipse.jdt.core.javanature")) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        if ((model = PluginRegistry.findModel(bundle)) == null) {
            return true;
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        if (libraries.length == 0) {
            return false;
        }
        int i = 0;
        while (i < libraries.length) {
            if (libraries[i].getName().equals(".")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean jarContainsResource(File file, String resource, boolean directory) {
        block22: {
            block21: {
                jarFile = null;
                jarFile = new ZipFile(file, 1);
                resourceEntry = jarFile.getEntry(resource);
                if (resourceEntry == null) break block21;
                var6_5 = directory != false ? resourceEntry.isDirectory() : true;
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException v0) {}
                return var6_5;
                catch (IOException v1) {
                    ** try [egrp 2[TRYBLOCK] [6 : 54->55)] { 
lbl15:
                    // 1 sources

                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        break block22;
                    }
                    catch (IOException v2) {}
                    break block22;
                }
                catch (FactoryConfigurationError v3) {
                    ** try [egrp 4[TRYBLOCK] [7 : 70->71)] { 
lbl-1000:
                    // 3 sources

                    {
                        catch (Throwable var5_6) {
                            try {
                                if (jarFile != null) {
                                    jarFile.close();
                                }
                            }
                            catch (IOException v4) {}
                            throw var5_6;
                        }
                    }
lbl31:
                    // 1 sources

                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        break block22;
                    }
                    catch (IOException v5) {}
                    break block22;
                }
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException v6) {}
        }
        return false;
    }

    public static void copyFile(IPath originPath, String name, File target) {
        block19: {
            File source = new File(originPath.toFile(), name);
            if (!source.exists()) {
                return;
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                try {
                    is = new FileInputStream(source);
                    os = new FileOutputStream(target);
                    byte[] buf = new byte[1024];
                    long currentLen = 0L;
                    int len = is.read(buf);
                    while (len != -1) {
                        currentLen += (long)len;
                        os.write(buf, 0, len);
                        len = is.read(buf);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException2) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Loose catch block
     */
    public static Document getTextDocument(File bundleLocation, String path) {
        ZipFile jarFile = null;
        InputStream stream = null;
        String extension = new Path(bundleLocation.getName()).getFileExtension();
        if ("jar".equals(extension) && bundleLocation.isFile()) {
            jarFile = new ZipFile(bundleLocation, 1);
            ZipEntry manifestEntry = jarFile.getEntry(path);
            if (manifestEntry != null) {
                stream = jarFile.getInputStream(manifestEntry);
            }
        } else {
            File file = new File(bundleLocation, path);
            if (file.exists()) {
                stream = new FileInputStream(file);
            }
        }
        Document document = CoreUtility.getTextDocument(stream);
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {}
        return document;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException3) {}
        }
        return null;
    }

    public static Document getTextDocument(InputStream in) {
        String result;
        block8: {
            ByteArrayOutputStream output = null;
            result = null;
            try {
                int count;
                output = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                    output.write(buffer, 0, count);
                }
                result = output.toString("UTF-8");
                output.close();
                output = null;
                in.close();
                in = null;
            }
            catch (IOException iOException) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (in == null) break block8;
                try {
                    in.close();
                }
                catch (IOException iOException3) {}
            }
        }
        return result == null ? null : new Document(result);
    }
}

