/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.mirror;

import java.net.URL;
import java.util.Map;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.artifact.mirror.Mirroring;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.osgi.framework.BundleContext;

public class MirrorApplication
implements IApplication {
    private URL sourceLocation;
    private URL destinationLocation;
    private IArtifactRepository source;
    private IArtifactRepository destination;
    private boolean append;
    private boolean raw = false;
    static /* synthetic */ Class class$0;

    public Object start(IApplicationContext context) throws Exception {
        Map args = context.getArguments();
        this.initializeFromArguments((String[])args.get("application.args"));
        this.setupRepositories();
        new Mirroring(this.source, this.destination, this.raw).run();
        return null;
    }

    private void setupRepositories() throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return;
        }
        this.source = manager.loadRepository(this.sourceLocation, null);
        this.destination = this.destinationLocation != null ? this.initializeDestination() : this.source;
    }

    private IArtifactRepository initializeDestination() throws ProvisionException {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        try {
            IArtifactRepository repository = manager.loadRepository(this.destinationLocation, null);
            if (!repository.isModifiable()) {
                throw new IllegalArgumentException("Artifact repository not modifiable: " + this.destinationLocation);
            }
            if (!this.append) {
                repository.removeAll();
            }
            return repository;
        }
        catch (ProvisionException provisionException) {
            String repositoryName = this.destinationLocation + " - artifacts";
            return manager.createRepository(this.destinationLocation, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
    }

    public void stop() {
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-raw")) {
                this.raw = true;
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-source")) {
                    this.sourceLocation = new URL(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-destination")) {
                    this.destinationLocation = new URL(arg);
                }
            }
            ++i;
        }
    }
}

