/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;

public class PackageConfigScriptGenerator
extends AssembleConfigScriptGenerator {
    private Properties packagingProperties;

    private String getFinalName(BundleDescription bundle, String shape) {
        if (!AbstractScriptGenerator.getPropertyAsBoolean("packagerAsNormalizer")) {
            Path path = new Path(bundle.getLocation());
            if (shape.equals("file") && !"jar".equalsIgnoreCase(path.getFileExtension())) {
                return path.lastSegment().concat(".jar");
            }
            return path.lastSegment();
        }
        if (shape.equals("file")) {
            return String.valueOf(ModelBuildScriptGenerator.getNormalizedName(bundle)) + ".jar";
        }
        return ModelBuildScriptGenerator.getNormalizedName(bundle);
    }

    private String getFinalName(BuildTimeFeature feature) {
        if (!AbstractScriptGenerator.getPropertyAsBoolean("packagerAsNormalizer")) {
            Path featurePath = new Path(feature.getURL().getPath());
            return featurePath.segment(featurePath.segmentCount() - 2);
        }
        return String.valueOf(feature.getId()) + "_" + feature.getVersion();
    }

    protected void generateGatherBinPartsCalls() {
        String location;
        String excludedFiles = null;
        if (AbstractScriptGenerator.getPropertyAsBoolean("packagerAsNormalizer")) {
            excludedFiles = "build.properties, .project, .classpath";
        }
        Path baseLocation = null;
        try {
            String url = this.getSite(false).getSiteContentProvider().getInstalledBaseURL();
            if (url != null) {
                baseLocation = new Path(url);
            }
        }
        catch (CoreException coreException) {}
        int i = 0;
        while (i < this.plugins.length) {
            Path pluginLocation = new Path(this.plugins[i].getLocation());
            location = pluginLocation.toOSString();
            boolean isFolder = this.isFolder(pluginLocation);
            if (baseLocation != null && baseLocation.isPrefixOf((IPath)pluginLocation)) {
                IPath relative = pluginLocation.removeFirstSegments(baseLocation.segmentCount());
                location = new Path(Utils.getPropertyFormat("baseLocation")).append(relative).toOSString();
            }
            if (isFolder) {
                this.script.printCopyTask(null, String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("pluginArchivePrefix") + '/' + this.getFinalName(this.plugins[i], "folder"), new FileSet[]{new FileSet(location, null, null, null, excludedFiles, null, null)}, false, false);
            } else {
                this.script.printCopyFileTask(location, String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("pluginArchivePrefix") + '/' + this.getFinalName(this.plugins[i], "file"), false);
            }
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            Path featureLocation = new Path(this.features[i].getURL().getPath());
            featureLocation = featureLocation.removeLastSegments(1);
            location = featureLocation.toOSString();
            if (baseLocation != null && baseLocation.isPrefixOf((IPath)featureLocation)) {
                IPath relative = featureLocation.removeFirstSegments(baseLocation.segmentCount());
                location = new Path(Utils.getPropertyFormat("baseLocation")).append(relative).toOSString();
            }
            this.script.printCopyTask(null, String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("featureArchivePrefix") + '/' + this.getFinalName(this.features[i]), new FileSet[]{new FileSet(location, null, null, null, null, null, null)}, false, false);
            ++i;
        }
        if (this.packagingProperties.size() != 0) {
            String tmp;
            String filesToPackage = null;
            filesToPackage = this.packagingProperties.getProperty("root", null);
            if (filesToPackage != null) {
                filesToPackage = String.valueOf(filesToPackage) + ',';
            }
            if ((tmp = this.packagingProperties.getProperty("root." + this.configInfo.toString("."), null)) != null) {
                filesToPackage = String.valueOf(filesToPackage) + tmp;
            }
            if (filesToPackage == null) {
                filesToPackage = "**/**";
            }
            FileSet rootFiles = new FileSet(String.valueOf(Utils.getPropertyFormat("tempDirectory")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + "/eclipse", null, filesToPackage, null, null, null, null);
            String target = String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder");
            this.script.printCopyTask(null, target, new FileSet[]{rootFiles}, false, false);
            Utils.generatePermissions(this.packagingProperties, this.configInfo, "eclipse.base", this.script);
            this.rootFileProviders = new ArrayList(1);
            this.rootFileProviders.add("elt");
        }
    }

    public String getTargetName() {
        String config = this.getTargetConfig();
        return "package." + this.getTargetElement() + (config.length() > 0 ? "." : "") + config;
    }

    private boolean isFolder(Path pluginLocation) {
        return pluginLocation.toFile().isDirectory();
    }

    public void setPackagingPropertiesLocation(String packagingPropertiesLocation) throws CoreException {
        this.packagingProperties = new Properties();
        if (packagingPropertiesLocation == null || packagingPropertiesLocation.equals("")) {
            return;
        }
        BufferedInputStream propertyStream = null;
        try {
            propertyStream = new BufferedInputStream(new FileInputStream(packagingPropertiesLocation));
            try {
                this.packagingProperties.load(new BufferedInputStream(propertyStream));
            }
            finally {
                ((InputStream)propertyStream).close();
            }
        }
        catch (FileNotFoundException e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
    }

    protected void generateGatherSourceCalls() {
    }

    protected FileSet[] generatePermissions(boolean zip) {
        return new FileSet[0];
    }

    protected void generateGZipTarget(boolean assembling) {
        super.generateGZipTarget(false);
    }

    public void generateTarGZTasks(boolean assembling) {
        super.generateTarGZTasks(false);
    }

    protected Object[] getFinalShape(BundleDescription bundle) {
        if (AbstractScriptGenerator.getPropertyAsBoolean("packagerMode")) {
            String shape = this.isFolder(new Path(bundle.getLocation())) ? "folder" : "file";
            return new Object[]{this.getFinalName(bundle, shape), shape};
        }
        return this.shapeAdvisor.getFinalShape(bundle);
    }

    protected Object[] getFinalShape(BuildTimeFeature feature) {
        if (AbstractScriptGenerator.getPropertyAsBoolean("packagerMode")) {
            return new Object[]{this.getFinalName(feature), "folder"};
        }
        return this.shapeAdvisor.getFinalShape(feature);
    }

    protected void printP2GenerationModeCondition() {
        this.script.printConditionIsSet("p2.generation.mode", "final", "p2.final.mode.override", "incremental");
    }
}

