/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;

public abstract class Shape
extends Figure {
    protected int lineWidth = 1;
    protected int lineStyle = 1;
    private boolean fill = true;
    private boolean outline = true;
    private boolean xorFill;
    private boolean xorOutline;

    protected abstract void fillShape(Graphics var1);

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean isOpaque() {
        return false;
    }

    protected abstract void outlineShape(Graphics var1);

    public void paintFigure(Graphics graphics) {
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setBackgroundColor(ColorConstants.buttonLightest);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            if (this.fill) {
                graphics.setXORMode(this.xorFill);
                this.fillShape(graphics);
            }
            if (this.outline) {
                graphics.setXORMode(this.xorOutline);
                graphics.setLineStyle(this.lineStyle);
                graphics.setLineWidth(this.lineWidth);
                this.outlineShape(graphics);
            }
            graphics.setBackgroundColor(ColorConstants.buttonDarker);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
            graphics.translate(-1, -1);
        }
        if (this.fill) {
            graphics.setXORMode(this.xorFill);
            this.fillShape(graphics);
        }
        if (this.outline) {
            graphics.setXORMode(this.xorOutline);
            graphics.setLineStyle(this.lineStyle);
            graphics.setLineWidth(this.lineWidth);
            this.outlineShape(graphics);
        }
    }

    public void setFill(boolean b) {
        if (this.fill == b) {
            return;
        }
        this.fill = b;
        this.repaint();
    }

    public void setFillXOR(boolean b) {
        if (this.xorFill == b) {
            return;
        }
        this.xorFill = b;
        this.repaint();
    }

    public void setLineWidth(int w) {
        if (this.lineWidth == w) {
            return;
        }
        this.lineWidth = w;
        this.repaint();
    }

    public void setLineStyle(int s) {
        if (this.lineStyle == s) {
            return;
        }
        this.lineStyle = s;
        this.repaint();
    }

    public void setOutline(boolean b) {
        if (this.outline == b) {
            return;
        }
        this.outline = b;
        this.repaint();
    }

    public void setOutlineXOR(boolean b) {
        if (this.xorOutline == b) {
            return;
        }
        this.xorOutline = b;
        this.repaint();
    }

    public void setXOR(boolean b) {
        this.xorOutline = this.xorFill = b;
        this.repaint();
    }
}

