/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

public class CVSStatus
extends TeamStatus {
    public static final int SERVER_ERROR = -10;
    public static final int NO_SUCH_TAG = -11;
    public static final int CONFLICT = -12;
    public static final int ERROR_LINE = -14;
    public static final int TAG_ALREADY_EXISTS = -15;
    public static final int COMMITTING_SYNC_INFO_FAILED = -16;
    public static final int DOES_NOT_EXIST = -17;
    public static final int FOLDER_NEEDED_FOR_FILE_DELETIONS = -18;
    public static final int CASE_VARIANT_EXISTS = -19;
    public static final int UNSUPPORTED_SERVER_VERSION = -20;
    public static final int SERVER_IS_CVSNT = -21;
    public static final int SERVER_IS_UNKNOWN = -22;
    public static final int PROTOCOL_ERROR = -23;
    public static final int ERROR_LINE_PARSE_FAILURE = -24;
    public static final int FAILED_TO_CACHE_SYNC_INFO = -25;
    public static final int UNMEGERED_BINARY_CONFLICT = -26;
    public static final int INVALID_LOCAL_RESOURCE_PATH = -27;
    public static final int RESPONSE_HANDLING_FAILURE = -28;
    public static final int COMMUNICATION_FAILURE = -29;
    public static final int AUTHENTICATION_FAILURE = -30;
    private ICVSFolder commandRoot;
    private ICVSRepositoryLocation cvsLocation;

    public CVSStatus(int severity, int code, String message, Throwable t, ICVSRepositoryLocation cvsLocation) {
        super(severity, "org.eclipse.team.cvs.core", code, message, t, null);
        this.cvsLocation = cvsLocation;
    }

    public CVSStatus(int severity, int code, String message, ICVSRepositoryLocation cvsLocation) {
        this(severity, code, message, null, cvsLocation);
    }

    public CVSStatus(int severity, int code, String message, Throwable t, IResource cvsResource) {
        super(severity, "org.eclipse.team.cvs.core", code, message, t, cvsResource);
    }

    public CVSStatus(int severity, int code, String message, IResource resource) {
        this(severity, code, message, null, resource);
    }

    public CVSStatus(int severity, int code, String message, Throwable t, ICVSFolder commandRoot) {
        super(severity, "org.eclipse.team.cvs.core", code, message, t, null);
        this.commandRoot = commandRoot;
    }

    public CVSStatus(int severity, int code, String message, ICVSFolder commandRoot) {
        this(severity, code, message, null, commandRoot);
    }

    public CVSStatus(int severity, int code, String message, Throwable t) {
        super(severity, "org.eclipse.team.cvs.core", code, message, t, null);
    }

    public CVSStatus(int severity, String message, Throwable t) {
        super(severity, "org.eclipse.team.cvs.core", 4, message, t, null);
    }

    public CVSStatus(int severity, String message) {
        super(severity, "org.eclipse.team.cvs.core", 4, message, null, null);
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.commandRoot != null) {
            message = NLS.bind((String)CVSMessages.CVSStatus_messageWithRoot, (Object[])new String[]{this.commandRoot.getName(), message});
        }
        return message;
    }

    public boolean isInternalError() {
        Throwable ex = this.getException();
        if (ex instanceof CVSException) {
            CVSException cvsEx = (CVSException)((Object)ex);
            IStatus status = cvsEx.getStatus();
            return CVSStatus.isInternalError(status);
        }
        return ex != null;
    }

    public static boolean isInternalError(IStatus status) {
        if (status instanceof CVSStatus) {
            return ((CVSStatus)status).isInternalError();
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (CVSStatus.isInternalError(child)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public ICVSRepositoryLocation getCvsLocation() {
        if (this.cvsLocation == null) {
            try {
                ICVSFolder folder;
                FolderSyncInfo info;
                if (this.commandRoot != null) {
                    FolderSyncInfo info2 = this.commandRoot.getFolderSyncInfo();
                    if (info2 != null) {
                        String repoString = info2.getRoot();
                        this.cvsLocation = KnownRepositories.getInstance().getRepository(repoString);
                    }
                } else if (this.getResource() != null && (info = (folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.getResource().getProject())).getFolderSyncInfo()) != null) {
                    String repoString = info.getRoot();
                    this.cvsLocation = KnownRepositories.getInstance().getRepository(repoString);
                }
            }
            catch (CVSException cVSException) {}
        }
        return this.cvsLocation;
    }

    public ICVSFolder getCommandRoot() {
        return this.commandRoot;
    }
}

