/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfileManager;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiToolsLabelProvider;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiProfilesConfigurationBlock;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiProfileWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ApiProfilesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IApiProfileManager manager = ApiPlugin.getDefault().getApiProfileManager();
    private static HashSet removed = new HashSet(8);
    private CheckboxTableViewer tableviewer = null;
    private ArrayList backingcollection = new ArrayList(8);
    private String newdefault = null;
    private Button newbutton = null;
    private Button removebutton = null;
    private Button editbutton = null;
    protected static int rebuildcount = 0;
    private String origdefault = null;
    private boolean dirty = false;
    private boolean needsbuild = false;
    private ApiProfilesConfigurationBlock block = null;

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        SWTFactory.createWrapLabel(comp, PreferenceMessages.ApiProfilesPreferencePage_0, 2, 200);
        SWTFactory.createVerticalSpacer(comp, 1);
        Composite lcomp = SWTFactory.createComposite(comp, 2, 1, 1808, 0, 0);
        SWTFactory.createWrapLabel(lcomp, PreferenceMessages.ApiProfilesPreferencePage_1, 2);
        Table table = new Table(lcomp, 67618);
        table.setLayoutData((Object)new GridData(1808));
        this.tableviewer = new CheckboxTableViewer(table);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider());
        this.tableviewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                ApiProfilesPreferencePage.this.doEdit((IApiProfile)ss.getFirstElement());
            }
        });
        this.tableviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IApiProfile profile = (IApiProfile)event.getElement();
                if (event.getChecked()) {
                    ApiProfilesPreferencePage.this.tableviewer.setCheckedElements(new Object[]{profile});
                    ApiProfilesPreferencePage.this.newdefault = profile.getName();
                } else {
                    ApiProfilesPreferencePage.this.newdefault = null;
                    ApiProfilesPreferencePage.this.manager.setDefaultApiProfile(null);
                }
                rebuildcount = 0;
                ApiProfilesPreferencePage.this.tableviewer.refresh(true);
                ApiProfilesPreferencePage.this.dirty = true;
            }
        });
        this.tableviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IApiProfile[] state = ApiProfilesPreferencePage.this.getCurrentSelection();
                ApiProfilesPreferencePage.this.removebutton.setEnabled(state.length > 0);
                ApiProfilesPreferencePage.this.editbutton.setEnabled(state.length == 1);
            }
        });
        this.tableviewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IApiProfile)e1).getName().compareTo(((IApiProfile)e2).getName());
            }
        });
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ApiProfilesPreferencePage.this.backingcollection.addAll(Arrays.asList(ApiProfilesPreferencePage.this.manager.getApiProfiles()));
                ApiProfilesPreferencePage.this.tableviewer.setInput((Object)ApiProfilesPreferencePage.this.backingcollection);
            }
        });
        Composite bcomp = SWTFactory.createComposite(lcomp, 1, 1, 1042, 0, 0);
        this.newbutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_2, null);
        this.newbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IApiProfile profile;
                ApiProfileWizard wizard = new ApiProfileWizard(null);
                WizardDialog dialog = new WizardDialog(ApiUIPlugin.getShell(), (IWizard)wizard);
                if (dialog.open() == 0 && (profile = wizard.getProfile()) != null) {
                    ApiProfilesPreferencePage.this.backingcollection.add(profile);
                    ApiProfilesPreferencePage.this.tableviewer.refresh();
                    ApiProfilesPreferencePage.this.tableviewer.setSelection((ISelection)new StructuredSelection((Object)profile), true);
                    if (ApiProfilesPreferencePage.this.backingcollection.size() == 1) {
                        ApiProfilesPreferencePage.this.newdefault = profile.getName();
                        ApiProfilesPreferencePage.this.tableviewer.setCheckedElements(new Object[]{profile});
                        ApiProfilesPreferencePage.this.tableviewer.refresh((Object)profile);
                    }
                    ApiProfilesPreferencePage.this.dirty = true;
                }
            }
        });
        this.editbutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_4, null);
        this.editbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiProfilesPreferencePage.this.doEdit(ApiProfilesPreferencePage.this.getCurrentSelection()[0]);
            }
        });
        this.editbutton.setEnabled(false);
        this.removebutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiProfilesPreferencePage_3, null);
        this.removebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IApiProfile[] states = ApiProfilesPreferencePage.this.getCurrentSelection();
                int i = 0;
                while (i < states.length) {
                    if (ApiProfilesPreferencePage.this.isDefault(states[i])) {
                        ApiProfilesPreferencePage.this.newdefault = null;
                        rebuildcount = 0;
                    }
                    removed.add(states[i].getName());
                    ++i;
                }
                if (ApiProfilesPreferencePage.this.backingcollection.removeAll(Arrays.asList(states))) {
                    ApiProfilesPreferencePage.this.dirty = true;
                }
                ApiProfilesPreferencePage.this.tableviewer.refresh();
            }
        });
        this.removebutton.setEnabled(false);
        IApiProfile profile = this.manager.getDefaultApiProfile();
        this.newdefault = profile == null ? null : profile.getName();
        this.origdefault = this.newdefault;
        this.initialize();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.APIPROFILES_PREF_PAGE);
        this.block = new ApiProfilesConfigurationBlock((IWorkbenchPreferenceContainer)this.getContainer());
        this.block.createControl(comp, this);
        SWTFactory.createVerticalSpacer(parent, 1);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    public static boolean isRemovedBaseline(String name) {
        return removed.contains(name);
    }

    protected void doEdit(IApiProfile profile) {
        IApiProfile newprofile;
        ApiProfileWizard wizard = new ApiProfileWizard(profile);
        WizardDialog dialog = new WizardDialog(ApiUIPlugin.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (newprofile = wizard.getProfile()) != null) {
            removed.add(profile.getName());
            this.backingcollection.remove(profile);
            this.backingcollection.add(newprofile);
            this.tableviewer.refresh();
            if (this.isDefault(profile)) {
                this.tableviewer.setCheckedElements(new Object[]{newprofile});
                this.tableviewer.setSelection((ISelection)new StructuredSelection((Object)newprofile), true);
                this.newdefault = newprofile.getName();
                rebuildcount = 0;
                this.needsbuild = true;
                this.tableviewer.refresh(true);
            }
            this.dirty = true;
        }
    }

    protected void initialize() {
        IApiProfile def = ApiPlugin.getDefault().getApiProfileManager().getDefaultApiProfile();
        if (def != null) {
            this.tableviewer.setCheckedElements(new Object[]{def});
        }
    }

    protected boolean isDefault(Object element) {
        if (element instanceof IApiProfile) {
            IApiProfile profile = (IApiProfile)element;
            if (this.newdefault == null) {
                IApiProfile def = ApiPlugin.getDefault().getApiProfileManager().getDefaultApiProfile();
                if (def != null) {
                    return profile.getName().equals(def.getName());
                }
            } else {
                return profile.getName().equals(this.newdefault);
            }
        }
        return false;
    }

    protected IApiProfile[] getCurrentSelection() {
        IStructuredSelection ss = (IStructuredSelection)this.tableviewer.getSelection();
        if (ss.isEmpty()) {
            return new IApiProfile[0];
        }
        return ((IStructuredSelection)this.tableviewer.getSelection()).toList().toArray(new IApiProfile[ss.size()]);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        this.manager.setDefaultApiProfile(this.origdefault);
        this.backingcollection.clear();
        removed.clear();
        if (this.block != null) {
            this.block.performCancel();
        }
        return super.performCancel();
    }

    protected void applyChanges() {
        if (!this.dirty) {
            return;
        }
        Iterator iter = removed.iterator();
        while (iter.hasNext()) {
            this.manager.removeApiProfile((String)iter.next());
        }
        iter = this.backingcollection.iterator();
        while (iter.hasNext()) {
            this.manager.addApiProfile((IApiProfile)iter.next());
        }
        IApiProfile def = ApiPlugin.getDefault().getApiProfileManager().getDefaultApiProfile();
        if (def != null && !def.getName().equals(this.newdefault)) {
            this.manager.setDefaultApiProfile(this.newdefault);
            this.needsbuild = true;
        } else if (def == null) {
            this.manager.setDefaultApiProfile(this.newdefault);
            this.needsbuild = true;
        }
        if (this.needsbuild && rebuildcount < 1) {
            ++rebuildcount;
            IProject[] projects = Util.getApiProjects();
            if (projects != null && MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferenceMessages.ApiProfilesPreferencePage_6, (String)PreferenceMessages.ApiProfilesPreferencePage_7)) {
                Util.getBuildJob((IProject[])projects).schedule();
            }
        }
        this.origdefault = this.newdefault;
        this.dirty = false;
        removed.clear();
    }

    public boolean performOk() {
        this.block.performOK();
        this.applyChanges();
        return true;
    }

    protected void performApply() {
        this.block.performApply();
        this.applyChanges();
    }

    class ProfileLabelProvider
    extends ApiToolsLabelProvider {
        ProfileLabelProvider() {
        }

        protected boolean isDefaultProfile(Object element) {
            return ApiProfilesPreferencePage.this.isDefault(element);
        }
    }
}

