/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.scanner.ApiDescriptionProcessor;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiToolingSetupRefactoring;
import org.eclipse.pde.api.tools.ui.internal.wizards.ProjectUpdateChange;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;

public class ApiToolingSetupWizardPage
extends UserInputWizardPage {
    private static final String SETTINGS_SECTION = "ApiToolingSetupWizardPage";
    private static final String SETTINGS_REMOVECXML = "remove_componentxml";
    private CheckboxTableViewer tableviewer = null;
    private Button removecxml = null;
    static /* synthetic */ Class class$0;

    protected ApiToolingSetupWizardPage() {
        super(WizardMessages.UpdateJavadocTagsWizardPage_4);
        this.setTitle(WizardMessages.UpdateJavadocTagsWizardPage_4);
        this.setMessage(WizardMessages.UpdateJavadocTagsWizardPage_7);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.API_TOOLING_SETUP_WIZARD_PAGE);
        SWTFactory.createWrapLabel(comp, WizardMessages.UpdateJavadocTagsWizardPage_6, 1, 100);
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, WizardMessages.UpdateJavadocTagsWizardPage_8, 1, 50);
        Table table = new Table(comp, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        this.tableviewer = new CheckboxTableViewer(table);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tableviewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableviewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects());
        this.tableviewer.setComparator(new ViewerComparator());
        this.tableviewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    try {
                        return project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("org.eclipse.pde.PluginNature") && !project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
                    }
                    catch (CoreException coreException) {}
                }
                return false;
            }
        });
        this.tableviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ApiToolingSetupWizardPage.this.setPageComplete(ApiToolingSetupWizardPage.this.pageValid());
            }
        });
        Composite bcomp = SWTFactory.createComposite(comp, 2, 1, 771, 0, 0);
        Button button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_10, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiToolingSetupWizardPage.this.tableviewer.setAllChecked(true);
                ApiToolingSetupWizardPage.this.setPageComplete(ApiToolingSetupWizardPage.this.pageValid());
            }
        });
        button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_11, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiToolingSetupWizardPage.this.tableviewer.setAllChecked(false);
                ApiToolingSetupWizardPage.this.setPageComplete(ApiToolingSetupWizardPage.this.pageValid());
            }
        });
        this.tableviewer.setCheckedElements(this.getWorkbenchSelection());
        this.setPageComplete(this.tableviewer.getCheckedElements().length > 0);
        SWTFactory.createVerticalSpacer(comp, 1);
        this.removecxml = SWTFactory.createCheckButton(comp, WizardMessages.ApiToolingSetupWizardPage_0, null, true, 1);
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION);
        if (settings != null) {
            this.removecxml.setSelection(settings.getBoolean(SETTINGS_REMOVECXML));
        }
    }

    protected Object[] getWorkbenchSelection() {
        ISelection selection;
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            Object[] jps = ((IStructuredSelection)provider.getSelection()).toArray();
            ArrayList<IProject> pjs = new ArrayList<IProject>();
            int i = 0;
            while (i < jps.length) {
                if (jps[i] instanceof IAdaptable) {
                    IProject pj;
                    IAdaptable adapt = (IAdaptable)jps[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IProject");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((pj = (IProject)adapt.getAdapter((Class)clazz)) != null) {
                        pjs.add(pj);
                    }
                }
                ++i;
            }
            return pjs.toArray();
        }
        return new Object[0];
    }

    protected boolean pageValid() {
        if (this.tableviewer.getCheckedElements().length < 1) {
            this.setErrorMessage(WizardMessages.UpdateJavadocTagsWizardPage_12);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public IWizardPage getNextPage() {
        this.collectChanges();
        IWizardPage page = super.getNextPage();
        if (page != null) {
            page.setDescription(WizardMessages.ApiToolingSetupWizardPage_5);
        }
        return page;
    }

    private void createTagChanges(CompositeChange projectchange, IJavaProject project, File cxml) {
        try {
            HashMap map = new HashMap();
            ApiDescriptionProcessor.collectTagUpdates((IJavaProject)project, (File)cxml, map);
            IFile file = null;
            TextFileChange change = null;
            MultiTextEdit multiedit = null;
            HashSet alledits = null;
            TextEdit edit = null;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                file = (IFile)iter.next();
                change = new TextFileChange(MessageFormat.format((String)WizardMessages.JavadocTagRefactoring_2, (Object[])new String[]{file.getName()}), file);
                multiedit = new MultiTextEdit();
                change.setEdit((TextEdit)multiedit);
                alledits = (HashSet)map.get(file);
                if (alledits != null) {
                    Iterator iter2 = alledits.iterator();
                    while (iter2.hasNext()) {
                        edit = (TextEdit)iter2.next();
                        multiedit.addChild(edit);
                    }
                }
                if (change == null) continue;
                projectchange.add((Change)change);
            }
        }
        catch (CoreException e) {
            ApiUIPlugin.log(e);
        }
        catch (IOException e) {
            ApiUIPlugin.log(e);
        }
    }

    private void collectChanges() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Object[] projects = ApiToolingSetupWizardPage.this.tableviewer.getCheckedElements();
                IProject project = null;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", projects.length);
                monitor.setTaskName(WizardMessages.ApiToolingSetupWizardPage_7);
                ApiToolingSetupRefactoring refactoring = (ApiToolingSetupRefactoring)ApiToolingSetupWizardPage.this.getRefactoring();
                refactoring.resetRefactoring();
                boolean remove = ApiToolingSetupWizardPage.this.removecxml.getSelection();
                CompositeChange pchange = null;
                int i = 0;
                while (i < projects.length) {
                    project = (IProject)projects[i];
                    pchange = new CompositeChange(project.getName());
                    refactoring.addChange((Change)pchange);
                    pchange.add((Change)new ProjectUpdateChange(project));
                    monitor.subTask(MessageFormat.format((String)WizardMessages.ApiToolingSetupWizardPage_4, (Object[])new String[]{project.getName()}));
                    IResource cxml = project.findMember("component.xml");
                    if (cxml != null) {
                        ApiToolingSetupWizardPage.this.createTagChanges(pchange, JavaCore.create((IProject)project), new File(cxml.getLocationURI()));
                        if (remove) {
                            pchange.add((Change)new DeleteResourceChange(cxml.getFullPath(), true));
                        }
                    }
                    if (monitor.isCanceled()) break;
                    monitor.worked(1);
                    ++i;
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InvocationTargetException e) {
            ApiUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            ApiUIPlugin.log(e);
        }
    }

    protected boolean performFinish() {
        this.collectChanges();
        return super.performFinish();
    }

    public boolean finish() {
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION);
        settings.put(SETTINGS_REMOVECXML, this.removecxml.getSelection());
        this.notifyNoDefaultProfile();
        return true;
    }

    private void notifyNoDefaultProfile() {
        if (ApiPlugin.getDefault().getApiProfileManager().getDefaultApiProfile() == null) {
            UIJob job = new UIJob("No default API profile detected"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    boolean doit = MessageDialog.openQuestion((Shell)ApiToolingSetupWizardPage.this.getShell(), (String)WizardMessages.ApiToolingSetupWizardPage_1, (String)(String.valueOf(WizardMessages.ApiToolingSetupWizardPage_2) + WizardMessages.ApiToolingSetupWizardPage_3));
                    if (doit) {
                        SWTFactory.showPreferencePage(ApiToolingSetupWizardPage.this.getShell(), "org.eclipse.pde.api.tools.ui.apiprofiles.prefpage", null);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }
}

