/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.results.BuildResults;
import org.eclipse.test.internal.performance.results.SQL_Results;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class DB_Results {
    static final boolean DEBUG = false;
    static final boolean LOG = false;
    private static final String DERBY = "derby";
    private static final String CLOUDSCAPE = "cloudscape";
    private static DB_Results fgDefault;
    private Connection fConnection;
    private SQL_Results fSQL;
    private boolean fIsEmbedded;
    private String fDBType;
    static final StringWriter DEBUG_STR_WRITER;
    static final PrintWriter DEBUG_WRITER;
    static final StringWriter LOG_STR_WRITER;
    static final LogWriter LOG_WRITER;
    private static String[] CONFIGS;
    private static String[] COMPONENTS;
    private static String[] BUILDS;
    private static int BUILDS_LENGTH;
    private static String[] SCENARII;
    private static String[] COMMENTS;
    private static final int MAX_CONFIGS = 5;
    private static final String[] SUPPORTED_VMS;
    private static final String[] SUPPORTED_COMPONENTS;

    static {
        DEBUG_STR_WRITER = null;
        DEBUG_WRITER = null;
        LOG_STR_WRITER = new StringWriter();
        LOG_WRITER = new LogWriter();
        SUPPORTED_VMS = new String[]{"sun"};
        SUPPORTED_COMPONENTS = new String[]{"org.eclipse.ant", "org.eclipse.compare", "org.eclipse.core", "org.eclipse.help", "org.eclipse.jdt.core", "org.eclipse.jdt.debug", "org.eclipse.jdt.text", "org.eclipse.jdt.ui", "org.eclipse.jface", "org.eclipse.osgi", "org.eclipse.pde.ui", "org.eclipse.swt", "org.eclipse.team", "org.eclipse.ua", "org.eclipse.ui"};
    }

    private DB_Results() {
    }

    static synchronized DB_Results getDefault() {
        if (fgDefault == null) {
            fgDefault = new DB_Results();
            fgDefault.connect();
            if (PerformanceTestPlugin.getDefault() == null) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        DB_Results.shutdown();
                    }
                });
            }
        }
        return fgDefault;
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.disconnect();
            fgDefault = null;
        }
    }

    static List getAllComponents() {
        return Arrays.asList(COMPONENTS);
    }

    static int getBuildId(String name) {
        if (BUILDS == null) {
            return -1;
        }
        return Arrays.binarySearch(BUILDS, name);
    }

    static String getBuildName(int id) {
        if (BUILDS == null) {
            return null;
        }
        return BUILDS[id];
    }

    static String getComponentNameFromScenario(String scenarioName) {
        int length = SUPPORTED_COMPONENTS.length;
        int i = 0;
        while (i < length) {
            if (scenarioName.startsWith(SUPPORTED_COMPONENTS[i])) {
                return SUPPORTED_COMPONENTS[i];
            }
            ++i;
        }
        return null;
    }

    static String getConfig(int id) {
        return CONFIGS[id];
    }

    public static List getScenariosNames() {
        return Arrays.asList(SCENARII);
    }

    static Map queryAllScenarios(String scenarioPattern, String buildName) {
        return DB_Results.getDefault().internalQueryBuildScenarios(scenarioPattern, buildName);
    }

    static void queryAllVariations(String configPattern) {
        DB_Results.getDefault().internalQueryAllVariations(configPattern);
    }

    static void queryScenarioFailures(ScenarioResults scenarioResults, String configPattern, BuildResults currentBuild, BuildResults baselineBuild) {
        DB_Results.getDefault().internalQueryScenarioFailures(scenarioResults, configPattern, currentBuild, baselineBuild);
    }

    static void queryScenarioSummaries(ScenarioResults scenarioResults, String configPattern, BuildResults currentBuild, BuildResults baselineBuild) {
        DB_Results.getDefault().internalQueryScenarioSummaries(scenarioResults, configPattern, currentBuild, baselineBuild);
    }

    static void queryScenarioValues(ScenarioResults scenarioResults, String configPattern) {
        DB_Results.getDefault().internalQueryScenarioValues(scenarioResults, configPattern, null, -1L);
    }

    static void queryScenarioValues(ScenarioResults scenarioResults, String configPattern, String lastBuildName, long lastBuildDate) {
        DB_Results.getDefault().internalQueryScenarioValues(scenarioResults, configPattern, lastBuildName, lastBuildDate);
    }

    private void connect() {
        if (this.fConnection != null) {
            return;
        }
        String dbloc = PerformanceTestPlugin.getDBLocation();
        if (dbloc == null) {
            return;
        }
        String dbname = PerformanceTestPlugin.getDBName();
        String url = null;
        Properties info = new Properties();
        this.fDBType = DERBY;
        try {
            if (dbloc.startsWith("net://")) {
                this.fIsEmbedded = false;
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("retrieveMessagesFromServerOnGetMessage", "true");
                info.put("create", "true");
                url = String.valueOf(dbloc) + '/' + dbname;
            } else if (dbloc.startsWith("//")) {
                this.fIsEmbedded = false;
                Class.forName("org.apache.derby.jdbc.ClientDriver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
                url = String.valueOf(dbloc) + '/' + dbname;
            } else {
                File f;
                if ("Mac OS X".equals(System.getProperty("os.name"))) {
                    System.setProperty("derby.storage.fileSyncTransactionLog", "true");
                }
                this.fIsEmbedded = true;
                try {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class.forName("com.ihost.cs.jdbc.CloudscapeDriver");
                    this.fDBType = CLOUDSCAPE;
                }
                if (dbloc.length() == 0) {
                    String user_home = System.getProperty("user.home");
                    if (user_home == null) {
                        return;
                    }
                    f = new File(user_home, this.fDBType);
                } else {
                    f = new File(dbloc);
                }
                url = new File(f, dbname).getAbsolutePath();
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
            }
            try {
                this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
            }
            catch (SQLException e) {
                if ("08001".equals(e.getSQLState()) && DERBY.equals(this.fDBType)) {
                    this.fDBType = CLOUDSCAPE;
                    this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
                }
                throw e;
            }
            this.fConnection.setAutoCommit(false);
            this.fSQL = new SQL_Results(this.fConnection);
            this.fConnection.commit();
        }
        catch (SQLException ex) {
            PerformanceTestPlugin.logError(ex.getMessage());
        }
        catch (ClassNotFoundException e) {
            PerformanceTestPlugin.log(e);
        }
    }

    private void disconnect() {
        block11: {
            if (this.fSQL != null) {
                try {
                    this.fSQL.dispose();
                }
                catch (SQLException e1) {
                    PerformanceTestPlugin.log(e1);
                }
                this.fSQL = null;
            }
            if (this.fConnection != null) {
                try {
                    this.fConnection.commit();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                try {
                    this.fConnection.close();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                this.fConnection = null;
            }
            if (this.fIsEmbedded) {
                try {
                    DriverManager.getConnection("jdbc:" + this.fDBType + ":;shutdown=true");
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    if (message.indexOf("system shutdown.") >= 0) break block11;
                    e.printStackTrace();
                }
            }
        }
    }

    private int getConfigId(String config) {
        if (CONFIGS == null) {
            return -1;
        }
        return Arrays.binarySearch(CONFIGS, config);
    }

    SQL_Results getSQL() {
        return this.fSQL;
    }

    private void internalQueryAllComments() {
        block20: {
            if (this.fSQL == null) {
                return;
            }
            if (COMMENTS != null) {
                return;
            }
            System.currentTimeMillis();
            ResultSet result = null;
            try {
                try {
                    String[] comments = null;
                    result = this.fSQL.queryAllComments();
                    while (result.next()) {
                        int commentID = result.getInt(1);
                        String comment = result.getString(3);
                        if (comments == null) {
                            comments = new String[commentID + 10];
                        } else if (commentID >= comments.length) {
                            int length = comments.length;
                            String[] stringArray = comments;
                            comments = new String[commentID + 10];
                            System.arraycopy(stringArray, 0, comments, 0, length);
                        }
                        comments[commentID] = comment;
                    }
                    COMMENTS = comments;
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void internalQueryAllVariations(String configPattern) {
        block19: {
            if (this.fSQL == null) {
                return;
            }
            if (BUILDS != null) {
                return;
            }
            System.currentTimeMillis();
            ResultSet result = null;
            try {
                try {
                    CONFIGS = new String[5];
                    BUILDS = null;
                    BUILDS_LENGTH = 0;
                    result = this.fSQL.queryAllVariations(configPattern);
                    while (result.next()) {
                        String variation = result.getString(1);
                        StringTokenizer tokenizer = new StringTokenizer(variation, "=|");
                        tokenizer.nextToken();
                        String buildName = tokenizer.nextToken();
                        tokenizer.nextToken();
                        this.storeConfig(tokenizer.nextToken());
                        tokenizer.nextToken();
                        String vmName = tokenizer.nextToken();
                        if (!vmName.equals(SUPPORTED_VMS[0])) continue;
                        this.storeBuildName(buildName);
                    }
                    String[] stringArray = BUILDS;
                    BUILDS = new String[BUILDS_LENGTH];
                    System.arraycopy(stringArray, 0, BUILDS, 0, BUILDS_LENGTH);
                    int i = 0;
                    while (i < 5) {
                        if (CONFIGS[i] == null) {
                            String[] stringArray2 = CONFIGS;
                            CONFIGS = new String[i];
                            System.arraycopy(stringArray2, 0, CONFIGS, 0, i);
                            break;
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private Map internalQueryBuildScenarios(String scenarioPattern, String buildName) {
        HashMap allScenarios;
        block17: {
            if (this.fSQL == null) {
                return null;
            }
            System.currentTimeMillis();
            ResultSet result = null;
            allScenarios = new HashMap();
            try {
                try {
                    result = this.fSQL.queryBuildScenarios(scenarioPattern, buildName);
                    int previousId = -1;
                    ArrayList<ScenarioResults> scenarios = null;
                    ArrayList<String> scenariosNames = new ArrayList<String>();
                    int i = 0;
                    while (result.next()) {
                        int id = result.getInt(1);
                        String name = result.getString(2);
                        scenariosNames.add(name);
                        String shortName = result.getString(3);
                        int component_id = this.storeComponent(DB_Results.getComponentNameFromScenario(name));
                        if (component_id != previousId) {
                            scenarios = new ArrayList<ScenarioResults>();
                            allScenarios.put(COMPONENTS[component_id], scenarios);
                            previousId = component_id;
                        }
                        scenarios.add(new ScenarioResults(id, name, shortName));
                        ++i;
                    }
                    SCENARII = new String[scenariosNames.size()];
                    scenariosNames.toArray(SCENARII);
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return allScenarios;
    }

    private void internalQueryScenarioValues(ScenarioResults scenarioResults, String configPattern, String lastBuildName, long lastBuildDate) {
        block18: {
            if (this.fSQL == null) {
                return;
            }
            this.internalQueryAllVariations(configPattern);
            ResultSet result = null;
            try {
                try {
                    int count = 0;
                    result = lastBuildName == null ? this.fSQL.queryScenarioDataPoints(configPattern, scenarioResults.getId()) : this.fSQL.queryScenarioTimestampDataPoints(configPattern, scenarioResults.getId(), lastBuildName, lastBuildDate);
                    while (result.next()) {
                        int dp_id = result.getInt(1);
                        int step = result.getInt(2);
                        String variation = result.getString(3);
                        StringTokenizer tokenizer = new StringTokenizer(variation, "=|");
                        tokenizer.nextToken();
                        String buildName = tokenizer.nextToken();
                        tokenizer.nextToken();
                        int config_id = this.getConfigId(tokenizer.nextToken());
                        int build_id = DB_Results.getBuildId(buildName);
                        ResultSet rs2 = this.fSQL.queryDimScalars(dp_id);
                        while (rs2.next()) {
                            int dim_id = rs2.getInt(1);
                            long value = rs2.getBigDecimal(2).longValue();
                            if (build_id >= 0) {
                                scenarioResults.setValue(build_id, dim_id, config_id, step, value);
                            }
                            ++count;
                        }
                    }
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void internalQueryScenarioFailures(ScenarioResults scenarioResults, String config, BuildResults currentBuild, BuildResults baselineBuild) {
        block17: {
            if (this.fSQL == null) {
                return;
            }
            System.currentTimeMillis();
            ResultSet result = null;
            try {
                try {
                    String currentBuildName = currentBuild.getName();
                    String baselineBuildName = baselineBuild.getName();
                    result = this.fSQL.queryScenarioFailures(scenarioResults.getId(), config, currentBuildName, baselineBuildName);
                    while (result.next()) {
                        String variation = result.getString(1);
                        String failure = result.getString(2);
                        StringTokenizer tokenizer = new StringTokenizer(variation, "=|");
                        tokenizer.nextToken();
                        String buildName = tokenizer.nextToken();
                        if (buildName.equals(currentBuildName)) {
                            currentBuild.setFailure(failure);
                            continue;
                        }
                        if (!buildName.equals(baselineBuildName)) continue;
                        baselineBuild.setFailure(failure);
                    }
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void internalQueryScenarioSummaries(ScenarioResults scenarioResults, String config, BuildResults currentBuild, BuildResults baselineBuild) {
        block24: {
            if (this.fSQL == null) {
                return;
            }
            System.currentTimeMillis();
            this.internalQueryAllComments();
            ResultSet result = null;
            try {
                try {
                    String variation;
                    String bBuildName;
                    String cBuildName;
                    String currentBuildName = cBuildName = currentBuild.getName();
                    String baselineBuildName = bBuildName = baselineBuild.getName();
                    int scenarioID = scenarioResults.getId();
                    result = this.fSQL.queryScenarioSummaries(scenarioID, config, cBuildName, bBuildName, InternalDimensions.ELAPSED_PROCESS.getId());
                    boolean hasResults = false;
                    while (result.next()) {
                        hasResults = true;
                        variation = result.getString(1);
                        short summaryKind = result.getShort(2);
                        int comment_id = result.getInt(3);
                        StringTokenizer tokenizer = new StringTokenizer(variation, "=|");
                        tokenizer.nextToken();
                        String buildName = tokenizer.nextToken();
                        BuildResults buildResults = null;
                        if (buildName.equals(currentBuildName)) {
                            buildResults = currentBuild;
                        } else if (buildName.equals(baselineBuildName)) {
                            buildResults = baselineBuild;
                        }
                        if (buildResults == null) continue;
                        buildResults.setSummary(summaryKind, COMMENTS[comment_id]);
                    }
                    if (!hasResults) {
                        result = this.fSQL.queryScenarioSummaries(scenarioID, config, cBuildName, bBuildName, 0);
                        while (result.next()) {
                            variation = result.getString(1);
                            int comment_id = result.getInt(3);
                            StringTokenizer tokenizer = new StringTokenizer(variation, "=|");
                            tokenizer.nextToken();
                            String buildName = tokenizer.nextToken();
                            BuildResults buildResults = null;
                            if (buildName.equals(currentBuildName)) {
                                buildResults = currentBuild;
                            } else if (buildName.equals(baselineBuildName)) {
                                buildResults = baselineBuild;
                            }
                            if (buildResults == null) continue;
                            buildResults.setComment(COMMENTS[comment_id]);
                        }
                    }
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private int storeComponent(String component) {
        int idx;
        if (COMPONENTS == null) {
            COMPONENTS = new String[SUPPORTED_COMPONENTS.length];
        }
        if ((idx = Arrays.binarySearch(SUPPORTED_COMPONENTS, component)) < 0) {
            throw new RuntimeException("Unexpected component name: " + component);
        }
        if (COMPONENTS[idx] == null) {
            DB_Results.COMPONENTS[idx] = SUPPORTED_COMPONENTS[idx];
        }
        return idx;
    }

    private int storeBuildName(String build) {
        if (BUILDS == null) {
            BUILDS = new String[1];
            DB_Results.BUILDS[DB_Results.BUILDS_LENGTH++] = build;
            return 0;
        }
        int idx = Arrays.binarySearch(BUILDS, build);
        if (idx >= 0) {
            return idx;
        }
        int index = -idx - 1;
        int length = BUILDS.length;
        if (BUILDS_LENGTH == length) {
            String[] array = new String[length + 1];
            if (index > 0) {
                System.arraycopy(BUILDS, 0, array, 0, index);
            }
            array[index] = build;
            if (index < length) {
                System.arraycopy(BUILDS, index, array, index + 1, length - index);
            }
            BUILDS = array;
        } else if (index < length) {
            System.arraycopy(BUILDS, index, BUILDS, index + 1, length - index);
            DB_Results.BUILDS[index] = build;
        }
        ++BUILDS_LENGTH;
        return index;
    }

    private int storeConfig(String config) {
        int i = 0;
        while (i < 5) {
            if (CONFIGS[i] == null) {
                DB_Results.CONFIGS[i] = config;
                return i;
            }
            if (config.equals(CONFIGS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static class LogWriter
    extends PrintWriter {
        long[] starts = new long[10];
        long[] times = new long[10];
        StringBuffer[] buffers = new StringBuffer[10];
        int depth = -1;
        int max = -1;

        public LogWriter() {
            super(LOG_STR_WRITER);
        }

        void starts(String log) {
            if (++this.depth >= this.buffers.length) {
                this.times = new long[this.depth + 10];
                System.arraycopy(this.times, 0, this.times, 0, this.depth);
                this.buffers = new StringBuffer[this.depth + 10];
                System.arraycopy(this.buffers, 0, this.buffers, 0, this.depth);
            }
            StringBuffer buffer = this.buffers[this.depth];
            if (this.buffers[this.depth] == null) {
                buffer = this.buffers[this.depth] = new StringBuffer();
            }
            buffer.append(log);
            this.starts[this.depth] = System.currentTimeMillis();
            if (this.depth > this.max) {
                this.max = this.depth;
            }
        }

        void ends(String log) {
            if (this.depth < 0) {
                throw new RuntimeException("Invalid call to ends (missing corresponding starts call)!");
            }
            this.buffers[this.depth].append(log);
            if (this.depth > 0) {
                int n = this.depth;
                this.times[n] = this.times[n] + (System.currentTimeMillis() - this.starts[this.depth]);
                --this.depth;
                return;
            }
            int i = 0;
            while (i < this.max) {
                this.print(this.buffers[i].toString());
                this.print(" ( in ");
                this.print(this.times[this.depth]);
                this.println("ms)");
                ++i;
            }
            this.max = -1;
            this.depth = -1;
            this.starts = new long[10];
            this.times = new long[10];
            this.buffers = new StringBuffer[10];
        }

        public String toString() {
            return LOG_STR_WRITER.toString();
        }
    }
}

