/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class SynchronizeModelElement
extends DiffNode
implements IAdaptable,
ISynchronizeModelElement {
    private static final int BUSY_FLAG = 1;
    private static final int PROPAGATED_CONFLICT_FLAG = 2;
    private static final int PROPAGATED_ERROR_FLAG = 4;
    private static final int PROPAGATED_WARNING_FLAG = 8;
    private int flags;
    private ListenerList listeners;
    private SynchronizeModelElement parent;
    static /* synthetic */ Class class$0;

    public SynchronizeModelElement(IDiffContainer parent) {
        super(parent, 0);
        this.internalSetParent(parent);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList(1);
        }
        this.listeners.add((Object)listener);
    }

    public synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public void setParent(IDiffContainer parent) {
        super.setParent(parent);
        this.internalSetParent(parent);
    }

    public boolean getProperty(String propertyName) {
        return (this.getFlags() & this.getFlag(propertyName)) > 0;
    }

    public void setProperty(String propertyName, boolean value) {
        if (value) {
            if (!this.getProperty(propertyName)) {
                int flag = this.getFlag(propertyName);
                this.flags |= flag;
                this.firePropertyChange(propertyName);
            }
        } else if (this.getProperty(propertyName)) {
            int flag = this.getFlag(propertyName);
            this.flags ^= flag;
            this.firePropertyChange(propertyName);
        }
    }

    public void setPropertyToRoot(String propertyName, boolean value) {
        if (value) {
            this.addToRoot(propertyName);
        } else {
            this.removeToRoot(propertyName);
        }
    }

    public void fireChanges() {
        this.fireChange();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        IResource resource = this.getResource();
        if (resource != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)resource.getAdapter((Class)clazz);
            return adapter.getImageDescriptor((Object)resource);
        }
        return null;
    }

    public abstract IResource getResource();

    private void addToRoot(String flag) {
        this.setProperty(flag, true);
        if (this.parent != null) {
            if (this.parent.getProperty(flag)) {
                return;
            }
            this.parent.addToRoot(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String propertyName) {
        Object[] allListeners;
        SynchronizeModelElement synchronizeModelElement = this;
        synchronized (synchronizeModelElement) {
            if (this.listeners == null) {
                return;
            }
            allListeners = this.listeners.getListeners();
        }
        boolean set = this.getProperty(propertyName);
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName, (Object)(!set ? 1 : 0), (Object)set);
        int i = 0;
        while (i < allListeners.length) {
            Object object = allListeners[i];
            if (object instanceof IPropertyChangeListener) {
                final IPropertyChangeListener listener = (IPropertyChangeListener)object;
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.propertyChange(event);
                    }
                });
            }
            ++i;
        }
    }

    private int getFlag(String propertyName) {
        if (propertyName == "org.eclipse.team.ui.busy") {
            return 1;
        }
        if (propertyName == "org.eclipse.team.ui.conflict") {
            return 2;
        }
        if (propertyName == "org.eclipse.team.ui.error") {
            return 4;
        }
        if (propertyName == "org.eclipse.team.ui.warning") {
            return 8;
        }
        return 0;
    }

    private int getFlags() {
        return this.flags;
    }

    private boolean hasChildWithFlag(String flag) {
        IDiffElement[] childen = this.getChildren();
        int i = 0;
        while (i < childen.length) {
            IDiffElement element = childen[i];
            if (((SynchronizeModelElement)element).getProperty(flag)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeToRoot(String flag) {
        boolean hasProperty = this.getProperty(flag);
        if (hasProperty) {
            this.setProperty(flag, false);
            if (this.parent != null && this.parent.getProperty(flag) && !this.parent.hasChildWithFlag(flag)) {
                this.parent.removeToRoot(flag);
            }
        }
    }

    private void internalSetParent(IDiffContainer parent) {
        if (parent != null && parent instanceof SynchronizeModelElement) {
            this.parent = (SynchronizeModelElement)parent;
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

