/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.text.edits.TextEdit;

public final class AddGetterSetterOperation
implements IWorkspaceRunnable {
    private static final String[] EMPTY_STRINGS = new String[0];
    private final IField[] fAccessorFields;
    private boolean fApply = true;
    private TextEdit fEdit = null;
    private final IField[] fGetterFields;
    private final IJavaElement fInsert;
    private final boolean fSave;
    private final IField[] fSetterFields;
    private final CodeGenerationSettings fSettings;
    private boolean fSkipAllExisting = false;
    private final IRequestQuery fSkipExistingQuery;
    private boolean fSort = false;
    private final IType fType;
    private final CompilationUnit fASTRoot;
    private int fVisibility = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public AddGetterSetterOperation(IType type, IField[] getters, IField[] setters, IField[] accessors, CompilationUnit unit, IRequestQuery skipExistingQuery, IJavaElement insert, CodeGenerationSettings settings, boolean apply, boolean save) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)settings);
        this.fType = type;
        this.fGetterFields = getters;
        this.fSetterFields = setters;
        this.fAccessorFields = accessors;
        this.fASTRoot = unit;
        this.fSkipExistingQuery = skipExistingQuery;
        this.fInsert = insert;
        this.fSettings = settings;
        this.fSave = save;
        this.fApply = apply;
    }

    private void addNewAccessor(IType type, IField field, String contents, ListRewrite rewrite, ASTNode insertion) throws JavaModelException {
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)type);
        MethodDeclaration declaration = (MethodDeclaration)rewrite.getASTRewrite().createStringPlaceholder(CodeFormatterUtil.format(4, contents, 0, delimiter, field.getJavaProject()), 31);
        if (insertion != null) {
            rewrite.insertBefore((ASTNode)declaration, insertion, null);
        } else {
            rewrite.insertLast((ASTNode)declaration, null);
        }
    }

    private void generateGetterMethod(IField field, ListRewrite rewrite) throws CoreException, OperationCanceledException {
        IType type = field.getDeclaringType();
        String name = GetterSetterUtil.getGetterName(field, null);
        IMethod existing = JavaModelUtil.findMethod(name, EMPTY_STRINGS, false, type);
        if (existing == null || !this.querySkipExistingMethods(existing)) {
            IJavaElement sibling = null;
            if (existing != null) {
                sibling = StubUtility.findNextSibling((IJavaElement)existing);
                this.removeExistingAccessor(existing, rewrite);
            } else {
                sibling = this.fInsert;
            }
            ASTNode insertion = StubUtility2.getNodeToInsertBefore(rewrite, sibling);
            this.addNewAccessor(type, field, GetterSetterUtil.getGetterStub(field, name, this.fSettings.createComments, this.fVisibility | field.getFlags() & 8), rewrite, insertion);
        }
    }

    private void generateSetterMethod(IField field, ASTRewrite astRewrite, ListRewrite rewrite) throws CoreException, OperationCanceledException {
        IType type = field.getDeclaringType();
        String name = GetterSetterUtil.getSetterName(field, null);
        IMethod existing = JavaModelUtil.findMethod(name, new String[]{field.getTypeSignature()}, false, type);
        if (existing == null || this.querySkipExistingMethods(existing)) {
            IJavaElement sibling = null;
            if (existing != null) {
                sibling = StubUtility.findNextSibling((IJavaElement)existing);
                this.removeExistingAccessor(existing, rewrite);
            } else {
                sibling = this.fInsert;
            }
            ASTNode insertion = StubUtility2.getNodeToInsertBefore(rewrite, sibling);
            this.addNewAccessor(type, field, GetterSetterUtil.getSetterStub(field, name, this.fSettings.createComments, this.fVisibility | field.getFlags() & 8), rewrite, insertion);
            if (Flags.isFinal((int)field.getFlags())) {
                ASTNode fieldDecl;
                ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fASTRoot, field.getNameRange());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.FieldDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((fieldDecl = ASTNodes.getParent(aSTNode, clazz)) != null) {
                    ModifierRewrite.create(astRewrite, fieldDecl).setModifiers(0, 16, null);
                }
            }
        }
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final int getVisibility() {
        return this.fVisibility;
    }

    public final boolean isSkipAllExisting() {
        return this.fSkipAllExisting;
    }

    private boolean querySkipExistingMethods(IMethod method) throws OperationCanceledException {
        if (!this.fSkipAllExisting) {
            switch (this.fSkipExistingQuery.doQuery((IMember)method)) {
                case 0: {
                    throw new OperationCanceledException();
                }
                case 1: {
                    return false;
                }
                case 3: {
                    this.fSkipAllExisting = true;
                }
            }
        }
        return true;
    }

    private void removeExistingAccessor(IMethod accessor, ListRewrite rewrite) throws JavaModelException {
        MethodDeclaration declaration;
        ASTNode aSTNode = NodeFinder.perform(rewrite.getParent().getRoot(), accessor.getNameRange());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((declaration = (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
            rewrite.remove((ASTNode)declaration, null);
        }
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.setTaskName(CodeGenerationMessages.AddGetterSetterOperation_description);
            monitor.beginTask("", this.fGetterFields.length + this.fSetterFields.length);
            ICompilationUnit unit = this.fType.getCompilationUnit();
            ASTRewrite astRewrite = ASTRewrite.create((AST)this.fASTRoot.getAST());
            ListRewrite listRewriter = null;
            if (this.fType.isAnonymous()) {
                AnonymousClassDeclaration declaration;
                ClassInstanceCreation creation;
                ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fASTRoot, this.fType.getNameRange());
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.ClassInstanceCreation");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((creation = (ClassInstanceCreation)ASTNodes.getParent(aSTNode, clazz)) != null && (declaration = creation.getAnonymousClassDeclaration()) != null) {
                    listRewriter = astRewrite.getListRewrite((ASTNode)declaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                }
            } else {
                AbstractTypeDeclaration declaration;
                ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fASTRoot, this.fType.getNameRange());
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((declaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
                    listRewriter = astRewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
                }
            }
            if (listRewriter == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, CodeGenerationMessages.AddGetterSetterOperation_error_input_type_not_found, null));
            }
            boolean bl = this.fSkipAllExisting = this.fSkipExistingQuery == null;
            if (!this.fSort) {
                int index = 0;
                while (index < this.fAccessorFields.length) {
                    this.generateGetterMethod(this.fAccessorFields[index], listRewriter);
                    this.generateSetterMethod(this.fAccessorFields[index], astRewrite, listRewriter);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++index;
                }
            }
            int index = 0;
            while (index < this.fGetterFields.length) {
                this.generateGetterMethod(this.fGetterFields[index], listRewriter);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++index;
            }
            index = 0;
            while (index < this.fSetterFields.length) {
                this.generateSetterMethod(this.fSetterFields[index], astRewrite, listRewriter);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++index;
            }
            this.fEdit = astRewrite.rewriteAST();
            if (this.fApply) {
                JavaModelUtil.applyEdit(unit, this.fEdit, this.fSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public final void setSkipAllExisting(boolean skip) {
        this.fSkipAllExisting = skip;
    }

    public void setSort(boolean sort) {
        this.fSort = sort;
    }

    public final void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }
}

