/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.IMultiLineCleanUp;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.PlatformUI;

public class CleanUpPostSaveListener
implements IPostSaveListener {
    public static final String POSTSAVELISTENER_ID = "org.eclipse.jdt.ui.postsavelistener.cleanup";
    private static final String WARNING_VALUE = "warning";
    private static final String ERROR_VALUE = "error";
    private static final String CHANGED_REGION_POSITION_CATEGORY = "changed_region_position_category";

    public boolean needsChangedRegions(ICompilationUnit unit) throws CoreException {
        ICleanUp[] cleanUps = this.getCleanUps(unit.getJavaProject().getProject());
        return this.requiresChangedRegions(cleanUps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saved(ICompilationUnit unit, IRegion[] changedRegions, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(this.getName(), -1);
        try {
            ICleanUp[] cleanUps;
            if (!ActionUtil.isOnBuildPath((IJavaElement)unit)) {
                return;
            }
            IProject project = unit.getJavaProject().getProject();
            Map settings = CleanUpPreferenceUtil.loadSaveParticipantOptions((IScopeContext)new ProjectScope(project));
            if (settings == null) {
                IEclipsePreferences contextNode = new InstanceScope().getNode("org.eclipse.jdt.ui");
                String id = contextNode.get("cleanup.on_save_profile_id", null);
                if (id != null) throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(FixMessages.CleanUpPostSaveListener_unknown_profile_error_message, id)));
                id = new DefaultScope().getNode("org.eclipse.jdt.ui").get("cleanup.on_save_profile_id", "org.eclipse.jdt.ui.default.save_participant_clean_up_profile");
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(FixMessages.CleanUpPostSaveListener_unknown_profile_error_message, id)));
            }
            if ("true".equals(settings.get("cleanup.on_save_use_additional_actions"))) {
                cleanUps = CleanUpRefactoring.createCleanUps(settings);
            } else {
                HashMap filteredSettins = new HashMap();
                filteredSettins.put("cleanup.format_source_code", settings.get("cleanup.format_source_code"));
                filteredSettins.put("cleanup.organize_imports", settings.get("cleanup.organize_imports"));
                cleanUps = CleanUpRefactoring.createCleanUps(filteredSettins);
            }
            long oldFileValue = unit.getResource().getModificationStamp();
            long oldDocValue = this.getDocumentStamp((IFile)unit.getResource(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            CompositeChange result = new CompositeChange(FixMessages.CleanUpPostSaveListener_SaveAction_ChangeName);
            LinkedList<UndoEdit> undoEdits = new LinkedList<UndoEdit>();
            IUndoManager manager = RefactoringCore.getUndoManager();
            boolean success = false;
            try {
                manager.aboutToPerformChange((Change)result);
                do {
                    RefactoringStatus preCondition = new RefactoringStatus();
                    int i = 0;
                    while (i < cleanUps.length) {
                        RefactoringStatus conditions = cleanUps[i].checkPreConditions(unit.getJavaProject(), new ICompilationUnit[]{unit}, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                        preCondition.merge(conditions);
                        ++i;
                    }
                    if (this.showStatus(preCondition) != 0) {
                        return;
                    }
                    HashMap options = new HashMap();
                    int i2 = 0;
                    while (i2 < cleanUps.length) {
                        Map map = cleanUps[i2].getRequirements().getCompilerOptions();
                        if (map != null) {
                            options.putAll(map);
                        }
                        ++i2;
                    }
                    CompilationUnit ast = null;
                    if (this.requiresAST(cleanUps)) {
                        ast = this.createAst(unit, options, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    }
                    ICleanUp.CleanUpContext context = changedRegions == null ? new ICleanUp.CleanUpContext(unit, ast) : new IMultiLineCleanUp.MultiLineCleanUpContext(unit, ast, changedRegions);
                    ArrayList undoneCleanUps = new ArrayList();
                    CleanUpRefactoring.CleanUpChange change = CleanUpRefactoring.calculateChange(context, cleanUps, undoneCleanUps);
                    RefactoringStatus postCondition = new RefactoringStatus();
                    int i3 = 0;
                    while (i3 < cleanUps.length) {
                        RefactoringStatus conditions = cleanUps[i3].checkPostConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        postCondition.merge(conditions);
                        ++i3;
                    }
                    if (this.showStatus(postCondition) != 0) {
                        return;
                    }
                    cleanUps = undoneCleanUps.toArray(new ICleanUp[undoneCleanUps.size()]);
                    if (change == null) continue;
                    result.add((Change)change);
                    change.setSaveMode(4);
                    change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    PerformChangeOperation performChangeOperation = RefactoringUI.createUIAwareChangeOperation((Change)change);
                    performChangeOperation.setSchedulingRule(unit.getSchedulingRule());
                    if (changedRegions != null && changedRegions.length > 0 && this.requiresChangedRegions(cleanUps)) {
                        changedRegions = this.performWithChangedRegionUpdate(performChangeOperation, changedRegions, unit, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    } else {
                        performChangeOperation.run((IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    }
                    performChangeOperation.getUndoChange();
                    undoEdits.addFirst(change.getUndoEdit());
                } while (cleanUps.length > 0);
                success = true;
            }
            finally {
                manager.changePerformed((Change)result, success);
                return;
            }
            if (undoEdits.size() <= 0) return;
            UndoEdit[] undoEditArray = undoEdits.toArray(new UndoEdit[undoEdits.size()]);
            CleanUpSaveUndo undo = new CleanUpSaveUndo(result.getName(), (IFile)unit.getResource(), undoEditArray, oldDocValue, oldFileValue);
            undo.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            manager.addUndo(result.getName(), (Change)undo);
            return;
        }
        finally {
            monitor.done();
        }
    }

    private ICleanUp[] getCleanUps(IProject project) throws CoreException {
        ICleanUp[] cleanUps;
        Map settings = CleanUpPreferenceUtil.loadSaveParticipantOptions((IScopeContext)new ProjectScope(project));
        if (settings == null) {
            IEclipsePreferences contextNode = new InstanceScope().getNode("org.eclipse.jdt.ui");
            String id = contextNode.get("cleanup.on_save_profile_id", null);
            if (id == null) {
                id = new DefaultScope().getNode("org.eclipse.jdt.ui").get("cleanup.on_save_profile_id", "org.eclipse.jdt.ui.default.save_participant_clean_up_profile");
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(FixMessages.CleanUpPostSaveListener_unknown_profile_error_message, id)));
        }
        if ("true".equals(settings.get("cleanup.on_save_use_additional_actions"))) {
            cleanUps = CleanUpRefactoring.createCleanUps(settings);
        } else {
            HashMap filteredSettins = new HashMap();
            filteredSettins.put("cleanup.format_source_code", settings.get("cleanup.format_source_code"));
            filteredSettins.put("cleanup.format_source_code_changes_only", settings.get("cleanup.format_source_code_changes_only"));
            filteredSettins.put("cleanup.organize_imports", settings.get("cleanup.organize_imports"));
            cleanUps = CleanUpRefactoring.createCleanUps(filteredSettins);
        }
        return cleanUps;
    }

    private int showStatus(RefactoringStatus status) {
        if (!status.hasError()) {
            return 0;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)shell, (String)"", (boolean)false);
        return dialog.open();
    }

    private long getDocumentStamp(IFile file, IProgressMonitor monitor) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        monitor.beginTask("", 2);
        ITextFileBuffer buffer = null;
        try {
            manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
            IDocument document = buffer.getDocument();
            if (document instanceof IDocumentExtension4) {
                long l = ((IDocumentExtension4)document).getModificationStamp();
                return l;
            }
            long l = file.getModificationStamp();
            return l;
        }
        finally {
            if (buffer != null) {
                manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.done();
        }
    }

    private IRegion[] performWithChangedRegionUpdate(PerformChangeOperation performChangeOperation, IRegion[] changedRegions, ICompilationUnit unit, IProgressMonitor monitor) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = unit.getResource().getFullPath();
        monitor.beginTask("", 7);
        ITextFileBuffer buffer = null;
        try {
            IRegion[] iRegionArray;
            manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
            IDocument document = buffer.getDocument();
            document.addPositionCategory(CHANGED_REGION_POSITION_CATEGORY);
            DefaultPositionUpdater updater = new DefaultPositionUpdater(CHANGED_REGION_POSITION_CATEGORY);
            try {
                document.addPositionUpdater((IPositionUpdater)updater);
                Position[] positions = new Position[changedRegions.length];
                int i = 0;
                while (i < changedRegions.length) {
                    try {
                        Position position = new Position(changedRegions[i].getOffset(), changedRegions[i].getLength());
                        document.addPosition(CHANGED_REGION_POSITION_CATEGORY, position);
                        positions[i] = position;
                    }
                    catch (BadLocationException e) {
                        throw CleanUpPostSaveListener.wrapBadLocationException(e);
                    }
                    catch (BadPositionCategoryException e) {
                        throw this.wrapBadPositionCategoryException(e);
                    }
                    ++i;
                }
                performChangeOperation.run((IProgressMonitor)new SubProgressMonitor(monitor, 5));
                ArrayList<Region> result = new ArrayList<Region>();
                int i2 = 0;
                while (i2 < positions.length) {
                    Position position = positions[i2];
                    if (!position.isDeleted()) {
                        result.add(new Region(position.getOffset(), position.getLength()));
                    }
                    ++i2;
                }
                iRegionArray = result.toArray(new IRegion[result.size()]);
            }
            catch (Throwable throwable) {
                document.removePositionUpdater((IPositionUpdater)updater);
                try {
                    document.removePositionCategory(CHANGED_REGION_POSITION_CATEGORY);
                }
                catch (BadPositionCategoryException e) {
                    throw this.wrapBadPositionCategoryException(e);
                }
                throw throwable;
            }
            document.removePositionUpdater((IPositionUpdater)updater);
            try {
                document.removePositionCategory(CHANGED_REGION_POSITION_CATEGORY);
            }
            catch (BadPositionCategoryException e) {
                throw this.wrapBadPositionCategoryException(e);
            }
            return iRegionArray;
        }
        finally {
            if (buffer != null) {
                manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.done();
        }
    }

    private boolean requiresAST(ICleanUp[] cleanUps) {
        int i = 0;
        while (i < cleanUps.length) {
            if (cleanUps[i].getRequirements().requiresAST()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean requiresChangedRegions(ICleanUp[] cleanUps) {
        int i = 0;
        while (i < cleanUps.length) {
            ICleanUp.CleanUpRequirements requirements = cleanUps[i].getRequirements();
            if (requirements instanceof ICleanUp.SaveActionRequirements && ((ICleanUp.SaveActionRequirements)requirements).requiresChangedRegions()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private CompilationUnit createAst(ICompilationUnit unit, Map cleanUpOptions, IProgressMonitor monitor) {
        CompilationUnit ast;
        IJavaProject project = unit.getJavaProject();
        if (this.compatibleOptions(project, cleanUpOptions) && (ast = SharedASTProvider.getAST((ITypeRoot)unit, SharedASTProvider.WAIT_NO, monitor)) != null) {
            return ast;
        }
        ASTParser parser = CleanUpRefactoring.createCleanUpASTParser();
        parser.setSource(unit);
        Map compilerOptions = RefactoringASTParser.getCompilerOptions((IJavaElement)unit.getJavaProject());
        compilerOptions.putAll(cleanUpOptions);
        parser.setCompilerOptions(compilerOptions);
        return (CompilationUnit)parser.createAST(monitor);
    }

    private boolean compatibleOptions(IJavaProject project, Map cleanUpOptions) {
        if (cleanUpOptions.size() == 0) {
            return true;
        }
        Map projectOptions = project.getOptions(true);
        Iterator iterator = cleanUpOptions.keySet().iterator();
        while (iterator.hasNext()) {
            String cleanUpOption;
            String key = (String)iterator.next();
            String projectOption = (String)projectOptions.get(key);
            if (this.strongerEquals(projectOption, cleanUpOption = (String)cleanUpOptions.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean strongerEquals(String projectOption, String cleanUpOption) {
        if (projectOption == null) {
            return false;
        }
        if (ERROR_VALUE.equals(cleanUpOption)) {
            return ERROR_VALUE.equals(projectOption);
        }
        if (WARNING_VALUE.equals(cleanUpOption)) {
            return ERROR_VALUE.equals(projectOption) || WARNING_VALUE.equals(projectOption);
        }
        return false;
    }

    public String getName() {
        return FixMessages.CleanUpPostSaveListener_name;
    }

    public String getId() {
        return POSTSAVELISTENER_ID;
    }

    private static CoreException wrapBadLocationException(BadLocationException e) {
        String message = e.getMessage();
        if (message == null) {
            message = "BadLocationException";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 10001, message, (Throwable)e));
    }

    private CoreException wrapBadPositionCategoryException(BadPositionCategoryException e) {
        String message = e.getMessage();
        if (message == null) {
            message = "BadPositionCategoryException";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 0, message, (Throwable)e));
    }

    private static class CleanUpSaveUndo
    extends TextFileChange {
        private final IFile fFile;
        private final UndoEdit[] fUndos;
        private final long fDocumentStamp;
        private final long fFileStamp;

        public CleanUpSaveUndo(String name, IFile file, UndoEdit[] undos, long documentStamp, long fileStamp) {
            super(name, file);
            Assert.isNotNull((Object)undos);
            this.fDocumentStamp = documentStamp;
            this.fFileStamp = fileStamp;
            this.fFile = file;
            this.fUndos = undos;
        }

        public final boolean needsSaving() {
            return true;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            if (this.isValid(pm).hasFatalError()) {
                return new NullChange();
            }
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            pm.beginTask("", 2);
            ITextFileBuffer buffer = null;
            try {
                manager.connect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                buffer = manager.getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
                IDocument document = buffer.getDocument();
                long oldFileValue = this.fFile.getModificationStamp();
                long oldDocValue = document instanceof IDocumentExtension4 ? ((IDocumentExtension4)document).getModificationStamp() : oldFileValue;
                LinkedList<UndoEdit> list = new LinkedList<UndoEdit>();
                int index = 0;
                while (index < this.fUndos.length) {
                    UndoEdit edit = this.fUndos[index];
                    UndoEdit redo = edit.apply(document, 1);
                    list.addFirst(redo);
                    ++index;
                }
                boolean stampSetted = false;
                if (document instanceof IDocumentExtension4 && this.fDocumentStamp != -1L) {
                    try {
                        ((IDocumentExtension4)document).replace(0, 0, "", this.fDocumentStamp);
                        stampSetted = true;
                    }
                    catch (BadLocationException e) {
                        throw CleanUpPostSaveListener.wrapBadLocationException(e);
                    }
                }
                buffer.commit(pm, false);
                if (!stampSetted) {
                    this.fFile.revertModificationStamp(this.fFileStamp);
                }
                CleanUpSaveUndo cleanUpSaveUndo = new CleanUpSaveUndo(this.getName(), this.fFile, list.toArray(new UndoEdit[list.size()]), oldDocValue, oldFileValue);
                return cleanUpSaveUndo;
            }
            catch (BadLocationException e) {
                throw CleanUpPostSaveListener.wrapBadLocationException(e);
            }
            finally {
                if (buffer != null) {
                    manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
            }
        }
    }
}

