/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.CleanUpOptions;
import org.eclipse.jdt.internal.ui.fix.CodeFormatCleanUp;
import org.eclipse.jdt.internal.ui.fix.CodeStyleCleanUp;
import org.eclipse.jdt.internal.ui.fix.ControlStatementsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ConvertLoopCleanUp;
import org.eclipse.jdt.internal.ui.fix.ExpressionsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.ImportsCleanUp;
import org.eclipse.jdt.internal.ui.fix.Java50CleanUp;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.fix.PotentialProgrammingProblemsCleanUp;
import org.eclipse.jdt.internal.ui.fix.SortMembersCleanUp;
import org.eclipse.jdt.internal.ui.fix.StringCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnimplementedCodeCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnnecessaryCodeCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.fix.VariableDeclarationCleanUp;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpMessages;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CodeFormatingTabPage;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CodeStyleTabPage;
import org.eclipse.jdt.internal.ui.preferences.cleanup.ICleanUpTabPage;
import org.eclipse.jdt.internal.ui.preferences.cleanup.MemberAccessesTabPage;
import org.eclipse.jdt.internal.ui.preferences.cleanup.MissingCodeTabPage;
import org.eclipse.jdt.internal.ui.preferences.cleanup.UnnecessaryCodeTabPage;

public class CleanUpRegistry {
    private ICleanUp[] fCleanUps;
    private CleanUpTabPageDescriptor[] fPageDescriptors;

    public synchronized ICleanUp[] getCleanUps() {
        this.ensureCleanUpRegistered();
        return this.fCleanUps;
    }

    public synchronized CleanUpTabPageDescriptor[] getCleanUpTabPageDescriptors() {
        this.ensurePagesRegistered();
        return this.fPageDescriptors;
    }

    public MapCleanUpOptions getDefaultOptions(int kind) {
        MapCleanUpOptions result = new MapCleanUpOptions();
        ICleanUp[] cleanUps = this.getCleanUps();
        int i = 0;
        while (i < cleanUps.length) {
            CleanUpOptions options = cleanUps[i].getDefaultOptions(kind);
            result.addAll(options);
            ++i;
        }
        return result;
    }

    private synchronized void ensureCleanUpRegistered() {
        if (this.fCleanUps != null) {
            return;
        }
        ArrayList<AbstractCleanUp> result = new ArrayList<AbstractCleanUp>();
        result.add(new CodeStyleCleanUp());
        result.add(new ControlStatementsCleanUp());
        result.add(new ConvertLoopCleanUp());
        result.add(new VariableDeclarationCleanUp());
        result.add(new ExpressionsCleanUp());
        result.add(new UnusedCodeCleanUp());
        result.add(new Java50CleanUp());
        result.add(new PotentialProgrammingProblemsCleanUp());
        result.add(new UnnecessaryCodeCleanUp());
        result.add(new StringCleanUp());
        result.add(new UnimplementedCodeCleanUp());
        result.add(new SortMembersCleanUp());
        result.add(new ImportsCleanUp());
        result.add(new CodeFormatCleanUp());
        this.fCleanUps = result.toArray(new ICleanUp[result.size()]);
    }

    private synchronized void ensurePagesRegistered() {
        if (this.fPageDescriptors != null) {
            return;
        }
        ArrayList<CleanUpTabPageDescriptor> result = new ArrayList<CleanUpTabPageDescriptor>();
        result.add(new CleanUpTabPageDescriptor("org.eclipse.jdt.ui.cleanup.tabpage.code_style", CleanUpMessages.CleanUpModifyDialog_TabPageName_CodeStyle){

            public ICleanUpTabPage createTabPage() {
                return new CodeStyleTabPage();
            }
        });
        result.add(new CleanUpTabPageDescriptor("org.eclipse.jdt.ui.cleanup.tabpage.member_accesses", CleanUpMessages.CleanUpModifyDialog_TabPageName_MemberAccesses){

            public ICleanUpTabPage createTabPage() {
                return new MemberAccessesTabPage();
            }
        });
        result.add(new CleanUpTabPageDescriptor("org.eclipse.jdt.ui.cleanup.tabpage.unnecessary_code", CleanUpMessages.CleanUpModifyDialog_TabPageName_UnnecessaryCode){

            public ICleanUpTabPage createTabPage() {
                return new UnnecessaryCodeTabPage();
            }
        });
        result.add(new CleanUpTabPageDescriptor("org.eclipse.jdt.ui.cleanup.tabpage.missing_code", CleanUpMessages.CleanUpModifyDialog_TabPageName_MissingCode){

            public ICleanUpTabPage createTabPage() {
                return new MissingCodeTabPage();
            }
        });
        result.add(new CleanUpTabPageDescriptor("org.eclipse.jdt.ui.cleanup.tabpage.code_formatting", CleanUpMessages.CleanUpModifyDialog_TabPageName_CodeFormating){

            public ICleanUpTabPage createTabPage() {
                return new CodeFormatingTabPage();
            }
        });
        this.fPageDescriptors = result.toArray(new CleanUpTabPageDescriptor[result.size()]);
    }

    public synchronized void registerCleanUp(ICleanUp cleanUp) {
        this.ensureCleanUpRegistered();
        ICleanUp[] oldCleanUps = this.fCleanUps;
        int oldLength = oldCleanUps.length;
        this.fCleanUps = new ICleanUp[oldLength + 1];
        System.arraycopy(oldCleanUps, 0, this.fCleanUps, 0, oldLength);
        this.fCleanUps[oldLength] = cleanUp;
    }

    public synchronized void registerTabPage(CleanUpTabPageDescriptor descriptor) {
        this.ensurePagesRegistered();
        CleanUpTabPageDescriptor[] oldDescriptorps = this.fPageDescriptors;
        int oldLength = oldDescriptorps.length;
        this.fPageDescriptors = new CleanUpTabPageDescriptor[oldLength + 1];
        System.arraycopy(oldDescriptorps, 0, this.fPageDescriptors, 0, oldLength);
        this.fPageDescriptors[oldLength] = descriptor;
    }

    public static abstract class CleanUpTabPageDescriptor {
        private String fName;
        private String fId;

        public CleanUpTabPageDescriptor(String id, String name) {
            this.fId = id;
            this.fName = name;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public abstract ICleanUpTabPage createTabPage();
    }
}

