/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.HistoryAction;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class HistoryListAction
extends Action {
    private CallHierarchyViewPart fView;

    public HistoryListAction(CallHierarchyViewPart view) {
        this.fView = view;
        this.setText(CallHierarchyMessages.HistoryListAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.history_list_action");
    }

    public void run() {
        IMember[][] historyEntries = this.fView.getHistoryEntries();
        HistoryListDialog dialog = new HistoryListDialog(JavaPlugin.getActiveWorkbenchShell(), historyEntries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            this.fView.setInputElements(dialog.getResult());
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private ListDialogField fHistoryList;
        private IStatus fHistoryStatus;
        private IMember[] fResult;

        private HistoryListDialog(Shell shell, IMember[][] elements) {
            super(shell);
            this.setTitle(CallHierarchyMessages.HistoryListDialog_title);
            String[] buttonLabels = new String[]{CallHierarchyMessages.HistoryListDialog_remove_button};
            IListAdapter adapter = new IListAdapter(this){
                final /* synthetic */ HistoryListDialog this$1;
                {
                    this.this$1 = historyListDialog;
                }

                public void customButtonPressed(ListDialogField field, int index) {
                    HistoryListDialog.access$0(this.this$1);
                }

                public void selectionChanged(ListDialogField field) {
                    HistoryListDialog.access$1(this.this$1);
                }

                public void doubleClicked(ListDialogField field) {
                    HistoryListDialog.access$2(this.this$1);
                }
            };
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(this, 1088){
                final /* synthetic */ HistoryListDialog this$1;
                {
                    this.this$1 = historyListDialog;
                }

                public String getText(Object element) {
                    IMember[] members = (IMember[])element;
                    return HistoryAction.getElementLabel(members);
                }

                public Image getImage(Object element) {
                    IMember[] members = (IMember[])element;
                    if (members.length == 1) {
                        return super.getImage(members[0]);
                    }
                    return null;
                }
            };
            this.fHistoryList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
            this.fHistoryList.setLabelText(CallHierarchyMessages.HistoryListDialog_label);
            this.fHistoryList.setElements(Arrays.asList(elements));
            StructuredSelection sel = elements.length > 0 ? new StructuredSelection(elements[0]) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)sel);
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setLayoutData((Object)new GridData(1808));
            inner.setFont(composite.getFont());
            LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fHistoryList}, true, 0, 0);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doCustomButtonPressed() {
            this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
        }

        private void doDoubleClicked() {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }

        private void doSelectionChanged() {
            StatusInfo status = new StatusInfo();
            List selected = this.fHistoryList.getSelectedElements();
            if (selected.size() != 1) {
                status.setError("");
                this.fResult = null;
            } else {
                this.fResult = (IMember[])selected.get(0);
            }
            this.fHistoryList.enableButton(0, this.fHistoryList.getSize() > selected.size() && selected.size() != 0);
            this.fHistoryStatus = status;
            this.updateStatus(status);
        }

        public IMember[] getResult() {
            return this.fResult;
        }

        public IMember[][] getRemaining() {
            List elems = this.fHistoryList.getElements();
            return (IMember[][])elems.toArray((T[])new IMember[elems.size()][]);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.history_list_dialog_context");
        }

        protected boolean isResizable() {
            return true;
        }

        static /* synthetic */ void access$0(HistoryListDialog historyListDialog) {
            historyListDialog.doCustomButtonPressed();
        }

        static /* synthetic */ void access$1(HistoryListDialog historyListDialog) {
            historyListDialog.doSelectionChanged();
        }

        static /* synthetic */ void access$2(HistoryListDialog historyListDialog) {
            historyListDialog.doDoubleClicked();
        }
    }
}

