/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class ConvertLoopCleanUp
extends AbstractCleanUp {
    public ConvertLoopCleanUp(Map options) {
        super(options);
    }

    public ConvertLoopCleanUp() {
    }

    public ICleanUp.CleanUpRequirements getRequirements() {
        return new ICleanUp.CleanUpRequirements(this.isEnabled("cleanup.convert_to_enhanced_for_loop"), false, null);
    }

    public IFix createFix(ICleanUp.CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean convertForLoops = this.isEnabled("cleanup.convert_to_enhanced_for_loop");
        return ConvertLoopFix.createCleanUp(compilationUnit, convertForLoops, convertForLoops, this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final"));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
            result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
            buf.append("for (int element : ids) {\n");
            buf.append("    double value= element / 2; \n");
            buf.append("    System.out.println(value);\n");
            buf.append("}\n");
        } else {
            buf.append("for (int i = 0; i < ids.length; i++) {\n");
            buf.append("    double value= ids[i] / 2; \n");
            buf.append("    System.out.println(value);\n");
            buf.append("}\n");
        }
        return buf.toString();
    }
}

