/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

public abstract class AbstractJarDestinationWizardPage
extends WizardExportResourcesPage
implements IJarPackageWizardPage {
    private final String fStoreDestinationNamesId;
    private Combo fDestinationNamesCombo;
    private Button fDestinationBrowseButton;
    private final JarPackageData fJarPackage;

    public AbstractJarDestinationWizardPage(String pageName, IStructuredSelection selection, JarPackageData jarPackage) {
        super(pageName, selection);
        this.fStoreDestinationNamesId = String.valueOf(pageName) + ".DESTINATION_NAMES_ID";
        this.fJarPackage = jarPackage;
    }

    protected void createDestinationGroup(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        String label = this.getDestinationLabel();
        if (label != null) {
            new Label(destinationSelectionGroup, 0).setText(label);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.fDestinationNamesCombo = new Combo(destinationSelectionGroup, 2052);
        this.fDestinationNamesCombo.setVisibleItemCount(20);
        this.fDestinationNamesCombo.addListener(24, (Listener)this);
        this.fDestinationNamesCombo.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = label == null ? 2 : 1;
        this.fDestinationNamesCombo.setLayoutData((Object)data);
        if (label == null) {
            SWTUtil.setAccessibilityText((Control)this.fDestinationNamesCombo, JarPackagerMessages.AbstractJarDestinationWizardPage_destinationCombo_AccessibilityText);
        }
        this.fDestinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.fDestinationBrowseButton.setText(JarPackagerMessages.JarPackageWizardPage_browseButton_text);
        this.fDestinationBrowseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fDestinationBrowseButton);
        this.fDestinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractJarDestinationWizardPage.this.handleDestinationBrowseButtonPressed();
            }
        });
    }

    protected void handleDestinationBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(ArchiveFileFilter.JAR_ZIP_FILTER_EXTENSIONS);
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
            dialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
        }
        if ((selectedFileName = dialog.open()) != null) {
            IContainer[] findContainersForLocation = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)new Path(selectedFileName));
            if (findContainersForLocation.length > 0) {
                selectedFileName = findContainersForLocation[0].getFullPath().makeRelative().toString();
            }
            this.fDestinationNamesCombo.setText(selectedFileName);
        }
    }

    protected String getDestinationValue() {
        String destinationText = this.fDestinationNamesCombo.getText().trim();
        if (destinationText.indexOf(46) < 0) {
            destinationText = String.valueOf(destinationText) + this.getOutputSuffix();
        }
        return destinationText;
    }

    protected String getDestinationLabel() {
        return JarPackagerMessages.JarPackageWizardPage_destination_label;
    }

    protected String getOutputSuffix() {
        return ".jar";
    }

    protected void restoreWidgetValues() {
        if (this.fJarPackage.getJarLocation().isEmpty()) {
            this.fDestinationNamesCombo.setText("");
        } else {
            this.fDestinationNamesCombo.setText(this.fJarPackage.getJarLocation().toOSString());
        }
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreDestinationNamesId);
            if (directoryNames == null) {
                return;
            }
            if (!this.fDestinationNamesCombo.getText().equals(directoryNames[0])) {
                this.fDestinationNamesCombo.add(this.fDestinationNamesCombo.getText());
            }
            int i = 0;
            while (i < directoryNames.length) {
                this.fDestinationNamesCombo.add(directoryNames[i]);
                ++i;
            }
        }
    }

    protected void updateModel() {
        String comboText = this.fDestinationNamesCombo.getText();
        IPath path = Path.fromOSString((String)comboText);
        if (path.segmentCount() > 0 && this.ensureTargetFileIsValid(path.toFile()) && path.getFileExtension() == null) {
            path = path.addFileExtension("jar");
        }
        this.fJarPackage.setJarLocation(path);
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory() && this.fDestinationNamesCombo.getText().length() > 0) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_exportDestinationMustNotBeDirectory);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        if (targetFile.exists() && !targetFile.canWrite()) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_jarFileExistsAndNotWritable);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        return true;
    }

    protected boolean validateDestinationGroup() {
        if (this.fDestinationNamesCombo.getText().length() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if (this.getMessage() != null) {
                this.setMessage(null);
            }
            return false;
        }
        if (this.fJarPackage.getAbsoluteJarLocation().toString().endsWith("/")) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_exportDestinationMustNotBeDirectory);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceLocation != null && workspaceLocation.isPrefixOf(this.fJarPackage.getAbsoluteJarLocation())) {
            int segments = workspaceLocation.matchingFirstSegments(this.fJarPackage.getAbsoluteJarLocation());
            IPath path = this.fJarPackage.getAbsoluteJarLocation().removeFirstSegments(segments);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 1 && JarPackagerUtil.contains(JarPackagerUtil.asResources(this.fJarPackage.getElements()), (IFile)resource)) {
                this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_cantExportJARIntoItself);
                return false;
            }
        }
        String currentMessage = this.getMessage();
        if (!new File(this.fDestinationNamesCombo.getText()).isAbsolute()) {
            if (currentMessage == null) {
                this.setMessage(JarPackagerMessages.JarPackageWizardPage_info_relativeExportDestination, 1);
            }
        } else if (currentMessage != null) {
            this.setMessage(null);
        }
        return this.ensureTargetFileIsValid(this.fJarPackage.getAbsoluteJarLocation().toFile());
    }

    protected void giveFocusToDestination() {
        this.fDestinationNamesCombo.setFocus();
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreDestinationNamesId);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(this.fStoreDestinationNamesId, directoryNames);
        }
    }

    protected void initializeJarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreDestinationNamesId);
            if (directoryNames == null) {
                return;
            }
            this.fJarPackage.setJarLocation(Path.fromOSString((String)directoryNames[0]));
        }
    }

    public void finish() {
        this.saveWidgetValues();
    }

    public void handleEvent(Event e) {
        if (this.getControl() == null) {
            return;
        }
        this.update();
    }

    protected void update() {
        this.updateModel();
        this.updateWidgetEnablements();
        this.updatePageCompletion();
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }
}

