/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class JavaNavigatorContentProvider
extends PackageExplorerContentProvider
implements IPipelinedTreeContentProvider {
    public static final String JDT_EXTENSION_ID = "org.eclipse.jdt.ui.javaContent";
    private IExtensionStateModel fStateModel;
    private Object fRealInput;
    private IPropertyChangeListener fLayoutPropertyListener;
    static /* synthetic */ Class class$0;

    public JavaNavigatorContentProvider() {
        super(false);
    }

    public JavaNavigatorContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        IExtensionStateModel stateModel = commonContentExtensionSite.getExtensionStateModel();
        IMemento memento = commonContentExtensionSite.getMemento();
        this.fStateModel = stateModel;
        this.restoreState(memento);
        this.fLayoutPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("isLayoutFlat".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue() != false;
                    JavaNavigatorContentProvider.this.setIsFlatLayout(newValue);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.fLayoutPropertyListener);
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
        this.setProvideMembers(showCUChildren);
    }

    public void dispose() {
        super.dispose();
        this.fStateModel.removePropertyChangeListener(this.fLayoutPropertyListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fRealInput = newInput;
        super.inputChanged(viewer, oldInput, this.findInputElement(newInput));
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (parent instanceof IJavaModel) {
            return this.getViewerInput() != null ? this.fRealInput : parent;
        }
        if (parent instanceof IJavaProject) {
            return ((IJavaProject)parent).getProject();
        }
        return parent;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)inputElement;
            return root.getProjects();
        }
        if (inputElement instanceof IJavaModel) {
            return ((IJavaModel)inputElement).getWorkspace().getRoot().getProjects();
        }
        if (inputElement instanceof IProject) {
            return super.getElements(JavaCore.create((IProject)((IProject)inputElement)));
        }
        return super.getElements(inputElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            return ((IProject)element).isAccessible();
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)parentElement;
            return root.getProjects();
        }
        if (parentElement instanceof IProject) {
            return super.getChildren(JavaCore.create((IProject)((IProject)parentElement)));
        }
        return super.getChildren(parentElement);
    }

    private Object findInputElement(Object newInput) {
        if (newInput instanceof IWorkspaceRoot) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspaceRoot)newInput));
        }
        return newInput;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        this.customize(this.getChildren(parent), currentChildren);
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        this.customize(this.getElements(input), currentElements);
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        Object parent = addModification.getParent();
        if (parent instanceof IJavaProject) {
            addModification.setParent((Object)((IJavaProject)parent).getProject());
        }
        if (parent instanceof IWorkspaceRoot) {
            this.deconvertJavaProjects(addModification);
        }
        this.convertToJavaElements(addModification);
        return addModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        this.deconvertJavaProjects(removeModification);
        this.convertToJavaElements(removeModification.getChildren());
        return removeModification;
    }

    private void deconvertJavaProjects(PipelinedShapeModification modification) {
        LinkedHashSet<IProject> convertedChildren = new LinkedHashSet<IProject>();
        Iterator iterator = modification.getChildren().iterator();
        while (iterator.hasNext()) {
            Object added = iterator.next();
            if (!(added instanceof IJavaProject)) continue;
            iterator.remove();
            convertedChildren.add(((IJavaProject)added).getProject());
        }
        modification.getChildren().addAll(convertedChildren);
    }

    private boolean convertToJavaElements(PipelinedShapeModification modification) {
        IJavaElement element;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (element = JavaCore.create((IResource)((IContainer)parent))) != null && element.exists()) {
            if (!(element instanceof IJavaModel) && !(element instanceof IJavaProject)) {
                modification.setParent((Object)element);
            }
            return this.convertToJavaElements(modification.getChildren());
        }
        return false;
    }

    private boolean convertToJavaElements(Set currentChildren) {
        LinkedHashSet<Object> convertedChildren = new LinkedHashSet<Object>();
        Iterator childrenItr = currentChildren.iterator();
        while (childrenItr.hasNext()) {
            Object child = childrenItr.next();
            if (child instanceof IFolder || child instanceof IFile) {
                IJavaElement newChild = JavaCore.create((IResource)((IResource)child));
                if (newChild == null || !newChild.exists()) continue;
                childrenItr.remove();
                convertedChildren.add(newChild);
                continue;
            }
            if (!(child instanceof IJavaProject)) continue;
            childrenItr.remove();
            convertedChildren.add(((IJavaProject)child).getProject());
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    private void customize(Object[] javaElements, Set proposedChildren) {
        Object element;
        List<Object> elementList = Arrays.asList(javaElements);
        Iterator iter = proposedChildren.iterator();
        while (iter.hasNext()) {
            int i;
            element = iter.next();
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (resource == null || (i = elementList.indexOf(resource)) < 0) continue;
            javaElements[i] = null;
        }
        int i = 0;
        while (i < javaElements.length) {
            element = javaElements[i];
            if (element instanceof IJavaElement) {
                IJavaElement cElement = (IJavaElement)element;
                IResource resource = cElement.getResource();
                if (resource != null) {
                    proposedChildren.remove(resource);
                }
                proposedChildren.add(element);
            } else if (element != null) {
                proposedChildren.add(element);
            }
            ++i;
        }
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return this.convertToJavaElements(refreshSynchronization.getRefreshTargets());
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        return this.convertToJavaElements(updateSynchronization.getRefreshTargets());
    }

    protected void postAdd(Object parent, Object element, Collection runnables) {
        if (parent instanceof IJavaModel) {
            super.postAdd(((IJavaModel)parent).getWorkspace().getRoot(), element, runnables);
        } else if (parent instanceof IJavaProject) {
            super.postAdd(((IJavaProject)parent).getProject(), element, runnables);
        } else {
            super.postAdd(parent, element, runnables);
        }
    }

    protected void postRefresh(List toRefresh, boolean updateLabels, Collection runnables) {
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IJavaModel)) continue;
            iter.remove();
            toRefresh.add(this.fRealInput);
            super.postRefresh(toRefresh, updateLabels, runnables);
            return;
        }
        super.postRefresh(toRefresh, updateLabels, runnables);
    }
}

